﻿// <summary>ソースコード：>ＨＹＳＳＯＰ演算スケジュール構成要素</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>演算スケジュール構成要素</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// 複数の種類のシミュレーターを　スケジューリングし順次動作させる等将来機能への拡張用クラス
    /// </para>
    /// </remarks>
    [Serializable]
    public class HySSimulationScheduleUnitData : HySDataRoot, HySVersionManagement
    {
        /// <summary>スケジュール構成要素名称</summary>
        protected HySString m_csSimSchUnitName;
        /// <summary>スケジュール構成要素識別子</summary>
        protected HySID m_csID;
        /// <summary>ロック中フラグ</summary>
        protected bool m_bLockFlg;

        /// <summary>シミュレータ管理テーブル</summary>
        HySDataLinkedList m_csSimlatorTable;

         
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySSimulationScheduleUnitData()
        {
            try
            {
                m_sDecodedVersion = null;
                m_bLockFlg = false;
                if (m_csSimlatorTable != null)
                {
                    m_csSimlatorTable.Clear();
                }
                m_csSimlatorTable = null;
                m_csSimSchUnitName = null;
                m_csID = null;
            }
            catch
            {
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulationScheduleUnitData csSimulationScheduleUnitData = new HySSimulationScheduleUnitData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySSimulationScheduleUnitData  生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSimulationScheduleUnitData()
        {
            m_csSimlatorTable = new HySDataLinkedList();
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>演算スケジュール構成要素名称設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimSchUnitName(csUnitName) </para>
        /// </example>
        /// <param name="csUnitName">名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSimSchUnitName(HySString csUnitName)
        {
            m_csSimSchUnitName = csUnitName;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算スケジュール構成要素名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csUnitName = GetSimSchUnitName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  演算スケジュール構成要素名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetSimSchUnitName()
        {
            return m_csSimSchUnitName;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetID(csID) </para>
        /// </example>
        /// <param name="csID">識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetID(HySIdentifier csID)
        {
            m_csID = (HySID)csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySIdentifier GetID()
        {
            return m_csID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子による同一比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Equal(csID) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool Equal(HySIdentifier csID)
        {
            return m_csID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>データ変更ロック中フラグの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLockFlg(bFlg) </para>
        /// </example>
        /// <param name="bFlg">=true:ロック中、=false:ロック解除</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ロック解除待ち等は行わない。単に目印をつけるのみ</para>
        /// </remarks>
        public void SetLockFlg(bool bFlg)
        {   m_bLockFlg = bFlg;  }
        /// <summary><para>method outline:</para>
        /// <para>データ変更ロック中フラグの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bFlg = GetLockFlg() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=ロック中, false:=ロック解除中</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ロック解除待ち等は行わない。単に目印をつけるのみ</para>
        /// </remarks>
        public bool GetLockFlg()
        {   return m_bLockFlg; }

        /// <summary><para>method outline:</para>
        /// <para>登録シミュレーターの数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetSimulatorNum() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  登録中のシミュレーターの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetSimulatorNum()
        {
            return m_csSimlatorTable.GetCount(); 
        }
        /// <summary><para>method outline:</para>
        /// <para>登録シミュレータークリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearSimulator() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearSimulator()
        {
            m_csSimlatorTable.Clear();
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddSimulator(csSimuKind, csSimuID) </para>
        /// </example>
        /// <param name="csSimuKind">シミュレーター種別</param>
        /// <param name="csSimuID">シミュレーター識別子</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddSimulator(HySObjectKind csSimuKind, HySID csSimuID)
        {
            m_csSimlatorTable.AddLast(new SimulatorInfo(csSimuKind, csSimuID));
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = GetSimulatorInfo(lIndex, csSimuKind, csSimuID) </para>
        /// </example>
        /// <param name="lIndex">位置</param>
        /// <param name="csSimuKind">シミュレーター種別</param>
        /// <param name="csSimuID">シミュレーター識別子</param>
        /// <returns>bool  =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetSimulatorInfo(long lIndex, HySObjectKind csSimuKind, HySID csSimuID)
        {
            bool bRtn = false;
            SimulatorInfo csData = (SimulatorInfo)m_csSimlatorTable.GetData(lIndex);
            if (csData != null)
            {
                csSimuKind = csData.GetSimuKind();
                csSimuID = csData.GetSimuID();
                bRtn = true;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター情報保管クラス</para>
        /// </summary>
        /// <remarks><para>remarks:</para>
        /// <para>内部クラス</para>
        /// </remarks>
        [Serializable]
        protected class SimulatorInfo : HySDataRoot, HySVersionManagement
        {
            /// <summary>シミュレータ種別</summary>
            protected HySObjectKind m_csSimulatorKind;
            /// <summary>シミュレータ識別子</summary>
            protected HySID m_csSimulatorID;

            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SimulatorInfo csSimulatorInfo = new SimulatorInfo(csSimuKind, csSimuID) </para>
            /// </example>
            /// <param name="csSimuKind">シミュレーター種別</param>
            /// <param name="csSimuID">シミュレーター識別子</param>
            /// <returns>生成したインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            internal SimulatorInfo(HySObjectKind csSimuKind, HySID csSimuID)
            {
                m_csSimulatorKind = csSimuKind;
                m_csSimulatorID = csSimuID;
                //バージョン情報設定
                SetNowVersion();
            }
            /// <summary><para>method outline:</para>
            /// <para>シミュレータ種別取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySObjectKind csSimuKind = GetSimuKind() </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>HySObjectKind  シミュレータ種別</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            internal HySObjectKind GetSimuKind()
            {
                return m_csSimulatorKind;
            }
            /// <summary><para>method outline:</para>
            /// <para>シミュレータ識別子取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySID csSimuID = GetSimuID() </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>HySID  シミュレータ識別子</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            internal HySID GetSimuID()
            {
                return m_csSimulatorID;
            }
            // ================================================
            //   バージョンアップ時の下位互換性を保つ為の処理
            // ================================================
            /// <summary>保存バージョン情報</summary>
            private string m_sDecodedVersion;
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sDecodedVersion = GetDecodedVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 保存バージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>メンバー変数に設定されているバージョン情報を返す</para>
            /// </remarks>
            public string GetDecodedVersion()
            {
                return m_sDecodedVersion;
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sVersion = GetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 現在のバージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetNowVersion()
            {
                return "1.00";
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>現在のバージョン情報をメンバー変数に設定する</para>
            /// </remarks>
            public void SetNowVersion()
            {
                m_sDecodedVersion = GetNowVersion();
            }
            /// <summary><para>method outline:</para>
            /// <para>復元後の整合性確保処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> PostDeserialize( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
            /// バージョンによって変数等追加がない場合には、実装の必要がない
            /// </para>
            /// </remarks>
            public virtual void PostDeserialize()
            {
                if (GetDecodedVersion() != GetNowVersion())
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            break;
                    }
                    SetNowVersion();
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>逆シリアル化時追加処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
            /// </example>
            /// <param name="csObj">ダミー</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>予約処理</para>
            /// </remarks>
            void IDeserializationCallback.OnDeserialization(Object csObj)
            {
                PostDeserialize();
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
