﻿// <summary>ソースコード：>ＨＹＳＳＯＰ文字列クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Globalization;
using System.Reflection;
using System.Runtime.ConstrainedExecution;
using System.Runtime.InteropServices;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>文字列クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>Remarks:</para>
    /// <para>C++ 等へ移植の際に便利な様に、Stringクラスを設ける</para>
    /// </remarks>
    [Serializable]
    public class HySString : HySStringRoot, HySVersionManagement
    {
        /// <summary> 文字列 </summary>
        private String m_sString;

        /// <summary>
        /// 空の文字列
        /// </summary>
        public static readonly string Empty;

         
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySString()
        {
            m_sString=null;
            m_sDecodedVersion = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = new HySString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString()
        {
            SetChar("");
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = new HySString(csVal) </para>
        /// </example>
        /// <param name="csVal">文字列</param>
        /// <returns>HySString  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString(String csVal)
        {
            m_sString = csVal;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = new HySString(cValue) </para>
        /// </example>
        /// <param name="cValue">Unicode 文字の配列</param>
        /// <returns>HySString  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString(char[] cValue)
        {
            m_sString = new String(cValue);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = new HySString(cValue, iCount) </para>
        /// </example>
        /// <param name="cValue">Unicode 文字</param>
        /// <param name="iCount">cValue の発生回数</param>
        /// <returns>HySString  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString(char cValue, int iCount)
        {
            m_sString = new String(cValue, iCount);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = new HySString(cValue, iStartIndex, iLength) </para>
        /// </example>
        /// <param name="cValue">Unicode 文字の配列</param>
        /// <param name="iStartIndex">cValue 内の開始位置</param>
        /// <param name="iLength">使用する cValue 内の文字数</param>
        /// <returns>HySString  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString(char[] cValue, int iStartIndex, int iLength)
        {
            m_sString = new String(cValue, iStartIndex, iLength);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySString  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Clone()
        {
            HySString csRtn = new HySString(this.m_sString);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>文字数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iWork = GetLength() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int　文字数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetLength()
        {
            int Len;
            Len = m_sString.Length;
            return Len;
        }

        /// <summary><para>method outline:</para>
        /// <para>文字列のコピー</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Copy(csString) </para>
        /// </example>
        /// <param name="csString">コピーする文字列</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Copy(HySString csString)
        {
            string Str;
            Str = csString.ToString();
            SetChar(Str);

        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンスと、指定した HySString オブジェクトを比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iWork = CompareTo(csString) </para>
        /// </example>
        /// <param name="csString">比較する文字列</param>
        /// <returns>int　相対値を示す値　0:一致、0以外:不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int CompareTo(HySString csString)
        {
            int num;
            string Str;

            Str = csString.ToString();
            num = m_sString.CompareTo(Str);
            return num;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定した Unicode 文字がこの文字列内で最初に見つかった位置を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iWork = IndexOf(cValue) </para>
        /// </example>
        /// <param name="cValue">文字</param>
        /// <returns>int　cValue のインデックス位置。見つからなかった場合は -1</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int IndexOf(char cValue)
        {
            int num;
            num = m_sString.IndexOf(cValue);
            return num;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定したStringがこの文字列内で最初に見つかった位置を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iWork = IndexOf(sValue) </para>
        /// </example>
        /// <param name="sValue">文字列</param>
        /// <returns>int　sValue のインデックス位置。見つからなかった場合は -1</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int IndexOf(string sValue)
        {
            int num;
            num = m_sString.IndexOf(sValue);
            return num;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定したHySStringがこの文字列内で最初に見つかった位置を返す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iWork = IndexOf(csValue) </para>
        /// </example>
        /// <param name="csValue">文字列</param>
        /// <returns>int　csValue のインデックス位置。見つからなかった場合は -1</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int IndexOf(HySString csValue)
        {
            int num;
            num = m_sString.IndexOf(csValue.ToString());
            return num;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定したインデックス位置に文字列を挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Insert(iStartIndex, sValue) </para>
        /// </example>
        /// <param name="iStartIndex">挿入先インデックス位置</param>
        /// <param name="sValue">挿入する文字列</param>
        /// <returns>HySString　iStartIndex の位置に sValue が挿入された文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Insert(int iStartIndex, string sValue)
        {
            m_sString = m_sString.Insert(iStartIndex, sValue);
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定したインデックス位置に文字列を挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Insert(iStartIndex, csValue) </para>
        /// </example>
        /// <param name="iStartIndex">挿入先インデックス位置</param>
        /// <param name="csValue">挿入する文字列</param>
        /// <returns>HySString　iStartIndex の位置に csValue が挿入された文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Insert(int iStartIndex, HySString csValue)
        {
            m_sString = m_sString.Insert(iStartIndex, csValue.ToString());
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>文字列のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetChar(sString) </para>
        /// </example>
        /// <param name="sString">文字列</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetChar(string sString)
        {
            m_sString = sString;
        }
        /// <summary><para>method outline:</para>
        /// <para>文字列のセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetString(csString) </para>
        /// </example>
        /// <param name="csString">文字列</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetString(HySString csString)
        {
            if ((object)csString != null)
            {
                m_sString = (string)csString.m_sString.Clone();
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>指定位置から指定した数の文字を削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Remove(iStartIndex, iCount) </para>
        /// </example>
        /// <param name="iStartIndex">開始位置</param>
        /// <param name="iCount">削除する文字数</param>
        /// <returns>HySString　削除後の文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Remove(int iStartIndex, int iCount)
        {
            m_sString = m_sString.Remove(iStartIndex, iCount);
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定文字をすべて、別に指定した文字に置換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Replace(cOldChar, cNewChar) </para>
        /// </example>
        /// <param name="cOldChar">置換する文字</param>
        /// <param name="cNewChar">cOldCharを置換する文字</param>
        /// <returns>HySString　置換されている文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Replace(char cOldChar, char cNewChar)
        {
            m_sString = m_sString.Replace(cOldChar, cNewChar);
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定文字列をすべて、別に指定した文字列に置換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Replace(sOldValue, sNewValue) </para>
        /// </example>
        /// <param name="sOldValue">置換する文字列</param>
        /// <param name="sNewValue">sOldValueを置換する文字列</param>
        /// <returns>HySString　置換されている文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Replace(string sOldValue, string sNewValue)
        {
            m_sString = m_sString.Replace(sOldValue, sNewValue);
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定文字列をすべて、別に指定した文字列に置換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Replace(csOldValue, sNewValue) </para>
        /// </example>
        /// <param name="csOldValue">置換する文字列</param>
        /// <param name="sNewValue">csOldValueを置換する文字列</param>
        /// <returns>HySString　置換されている文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Replace(HySString csOldValue, string sNewValue)
        {
            m_sString = m_sString.Replace(csOldValue.ToString(), sNewValue);
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定文字列をすべて、別に指定した文字列に置換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Replace(sOldValue, csNewValue) </para>
        /// </example>
        /// <param name="sOldValue">置換する文字列</param>
        /// <param name="csNewValue">sOldValueを置換する文字列</param>
        /// <returns>HySString　置換されている文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Replace(string sOldValue, HySString csNewValue)
        {
            m_sString = m_sString.Replace(sOldValue, csNewValue.ToString());
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定文字列をすべて、別に指定した文字列に置換</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = Replace(csOldValue, csNewValue) </para>
        /// </example>
        /// <param name="csOldValue">置換する文字列</param>
        /// <param name="csNewValue">csOldValueを置換する文字列</param>
        /// <returns>HySString　置換されている文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString Replace(HySString csOldValue, HySString csNewValue)
        {
            m_sString = m_sString.Replace(csOldValue.ToString(), csNewValue.ToString());
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>部分文字列を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Substring(iStartIndex, csString) </para>
        /// </example>
        /// <param name="iStartIndex">部分文字列の開始文字位置</param>
        /// <param name="csString">格納先</param>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Substring(int iStartIndex , ref HySString csString)
        {
            string Str;
            Str = m_sString.Substring(iStartIndex);

            csString.SetChar(Str);
        }

        /// <summary><para>method outline:</para>
        /// <para>文字列比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = Equal(csString) </para>
        /// </example>
        /// <param name="csString">文字列</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean Equal(HySString csString)
        {
            return m_sString.Equals(csString.m_sString);
        }


        // 以下のメソッドが要
        //  =,+,+=,== 演算子
        //  = "x", + "x", += "x", =="x"  の演算子

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（+）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = csString1 + csString2 </para>
        /// </example>
        /// <param name="csString1">演算する文字列クラスオブジェクト</param>
        /// <param name="csString2">演算する文字列クラスオブジェクト</param>
        /// <returns>HySString　演算（+）した文字列クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySString operator +(HySString csString1, HySString csString2)
        {
            return new HySString(csString1.ToString() + csString2.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（+）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = csString + sString </para>
        /// </example>
        /// <param name="csString">演算する文字列クラスオブジェクト</param>
        /// <param name="sString">stringクラスオブジェクト</param>
        /// <returns>HySString　演算（+）した文字列クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySString operator +(HySString csString, string sString)
        {
            return new HySString(csString.ToString() + sString);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（+）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csString = csString + lNumber </para>
        /// </example>
        /// <param name="csString">演算する文字列クラスオブジェクト</param>
        /// <param name="lNumber">演算するlongクラスオブジェクト</param>
        /// <returns>HySString　演算（+）した文字列クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySString operator +(HySString csString, long lNumber)
        {
            return new HySString(csString.ToString() + lNumber.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（==）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = csString1 == csString2 </para>
        /// </example>
        /// <param name="csString1">演算する文字列クラスオブジェクト</param>
        /// <param name="csString2">演算する文字列クラスオブジェクト</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator ==(HySString csString1, HySString csString2)
        {
            if (((object)csString1 == null) || ((object)csString2 == null))
            {
                return false;
            }

            return csString1.Equal(csString2);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（!=）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = csString1 != csString2 </para>
        /// </example>
        /// <param name="csString1">演算する文字列クラスオブジェクト</param>
        /// <param name="csString2">演算する文字列クラスオブジェクト</param>
        /// <returns>bool　true:=不一致, false:=一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator !=(HySString csString1, HySString csString2)
        {
            return !(csString1 == csString2);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（==）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = csString == sString </para>
        /// </example>
        /// <param name="csString">演算する文字列クラスオブジェクト</param>
        /// <param name="sString">演算するstringクラスオブジェクト</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator ==(HySString csString, string sString)
        {
            if (((object)csString == null) || ((object)sString == null))
            {
                return false;
            }

            return csString.ToString().Equals(sString);
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（!=）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = csString1 != sString </para>
        /// </example>
        /// <param name="csString">演算する文字列クラスオブジェクト</param>
        /// <param name="sString">演算するstringクラスオブジェクト</param>
        /// <returns>bool　true:=不一致, false:=一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator !=(HySString csString, string sString)
        {
            if (((object)csString == null) || ((object)sString == null))
            {
                return false;
            }

            return !(csString.ToString().Equals(sString));
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（==）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = sString == csString </para>
        /// </example>
        /// <param name="sString">演算するstringクラスオブジェクト</param>
        /// <param name="csString">演算する文字列クラスオブジェクト</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator ==(string sString, HySString csString)
        {
            if (((object)sString == null) || ((object)csString == null))
            {
                return false;
            }

            return sString.Equals(csString.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（!=）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = sString != csString </para>
        /// </example>
        /// <param name="sString">演算するstringクラスオブジェクト</param>
        /// <param name="csString">演算する文字列クラスオブジェクト</param>
        /// <returns>bool　true:=不一致, false:=一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static bool operator !=(string sString, HySString csString)
        {
            if (((object)sString == null) || ((object)csString == null))
            {
                return false;
            }

            return !(sString.Equals(csString.ToString()));
        }

        /// <summary><para>method outline:</para>
        /// <para>オーバーライド（Equals）　このインスタンスと、指定したオブジェクトの値が同一かどうかを判断します</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Equals(csObject) </para>
        /// </example>
        /// <param name="csObject">比較するオブジェクト　HySStringオブジェクトを指定する必要があります</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool Equals(object csObject)
        {
            if (csObject == null)
            {
                return false;
            }

            HySString csHySString = csObject as HySString;
            if ((object)csHySString == null)
            {
                return false;
            }

            return m_sString == csHySString.m_sString;
        }

        /// <summary><para>method outline:</para>
        /// <para>オーバーライド（GetHashCode）　この文字列のハッシュコードを返します</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iWork = GetHashCode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>int　32 ビット符号付き整数ハッシュコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override int GetHashCode()
        {
            return m_sString.GetHashCode();
        }


        /// <summary><para>method outline:</para>
        /// <para>文字列取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> String csString = ToString() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>String　文字列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        new public String ToString()
        {
            return m_sString;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================

        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
