﻿// <summary>ソースコード：>ＨＹＳＳＯＰ日付管理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>日付管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySTime : HySDate, HySVersionManagement
    {
        /// <summary>２０００年を０としての地質学的経年を示す。負は、２０００年よりも過去 （将来用）</summary>
        double m_dGeologicalTime = 0.0;
        /// <summary> 1970 年 1 月 1 日、0 時 0 分 0 秒 GMT (グリニッジ標準時) を起点とした時間を秒で表した値(ミリ秒でない事に注意) </summary>
        double m_dSecTime = 0.0;

               
        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySTime()
        {
            m_sDecodedVersion = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = new HySTime(lDay, lHour, lMinutem, lSecond) </para>
        /// </example>
        /// <param name="lDay">日データ</param>
        /// <param name="lHour">時データ</param>
        /// <param name="lMinute">分データ</param>
        /// <param name="lSecond">秒データ</param>
        /// <returns>HySTime  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime(long lDay, long lHour, long lMinute, long lSecond)
        {
            m_dSecTime = (3600*24)*lDay + 3600 * lHour + 60 * lMinute + lSecond;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = new HySTime(lHour, lMinutem, lSecond) </para>
        /// </example>
        /// <param name="lHour">時データ</param>
        /// <param name="lMinute">分データ</param>
        /// <param name="lSecond">秒データ</param>
        /// <returns>HySTime  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime(long lHour, long lMinute, long lSecond)
        {
            m_dSecTime = 3600 * lHour + 60 * lMinute + lSecond;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = new HySTime(lMinutem, lSecond) </para>
        /// </example>
        /// <param name="lMinute">分データ</param>
        /// <param name="lSecond">秒データ</param>
        /// <returns>HySTime  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime(long lMinute, long lSecond)
        {
            m_dSecTime = 60 * lMinute + lSecond;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = new HySTime(lSecond) </para>
        /// </example>
        /// <param name="lSecond">秒データ　1970 年 1 月 1 日、0 時 0 分 0 秒 GMT (グリニッジ標準時) を起点とした時間を秒で表した値(ミリ秒でない事に注意)</param>
        /// <returns>HySTime  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime(long lSecond)
        {
            m_dSecTime = (double)lSecond;
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = new HySTime(dSecond) </para>
        /// </example>
        /// <param name="dSecond">ミリ秒付き秒データ　1970 年 1 月 1 日、0 時 0 分 0 秒 GMT (グリニッジ標準時) を起点とした時間を秒で表した値(ミリ秒は小数点以下)</param>
        /// <returns>HySTime  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime(double dSecond)
        {
            m_dSecTime = dSecond;
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime  生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime Clone()
        {
            HySTime csRtn = new HySTime(m_dSecTime);
            csRtn.m_dGeologicalTime = this.m_dGeologicalTime;
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時間</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime SetTime(HySTime csTime)
        {
            m_dGeologicalTime = csTime.m_dGeologicalTime;
            m_dSecTime = csTime.m_dSecTime;
            return this;
        }
        /// <summary><para>method outline:</para>
        /// <para>時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = SetTime(lSecond) </para>
        /// </example>
        /// <param name="lSecond">秒データ　1970 年 1 月 1 日、0 時 0 分 0 秒 GMT (グリニッジ標準時) を起点とした時間を秒で表した値(ミリ秒でない事に注意)</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime SetTime(long lSecond)
        {
            m_dSecTime = (double)lSecond;
            return this;
        }
        /// <summary><para>method outline:</para>
        /// <para>時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = SetTime(dSecond) </para>
        /// </example>
        /// <param name="dSecond">秒データ　1970 年 1 月 1 日、0 時 0 分 0 秒 GMT (グリニッジ標準時) を起点とした時間を秒で表した値(ミリ秒でない事に注意)</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime SetTime(double dSecond)
        {
            m_dSecTime = dSecond;
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>時間更新（加算）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = AddTime(lSecond) </para>
        /// </example>
        /// <param name="lSecond">秒データ　時間更新（加算）する時間（秒）のデータ
        /// </param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime AddTime(long lSecond)
        {
            m_dSecTime += (double)lSecond;
            return this;
        }
        /// <summary><para>method outline:</para>
        /// <para>時間更新（加算）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = AddTime(dSecond) </para>
        /// </example>
        /// <param name="dSecond">秒データ　時間更新（加算）する時間（秒）のデータ
        /// </param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime AddTime(double dSecond)
        {
            m_dSecTime += dSecond;
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>時間設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = SetSubSecondTime(dSecond) </para>
        /// </example>
        /// <param name="dSecond">ミリ秒データ　ミリ秒を小数点以下で入力</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime SetSubSecondTime(double dSecond)
        {
            m_dSecTime = (double)((long)(m_dSecTime)) + dSecond;
            return this;
        }
        /// <summary><para>method outline:</para>
        /// <para>時間更新（加算）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = AddSubSecondTime(dSecond) </para>
        /// </example>
        /// <param name="dSecond">ミリ秒データ　ミリ秒を小数点以下で入力</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        [Obsolete("ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない　AddTime()メソッドを使用して下さい")]
        public HySTime AddSubSecondTime(double dSecond)
        {
            m_dSecTime += dSecond;
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>時間更新（加算）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = Add(csTime) </para>
        /// </example>
        /// <param name="csTime">日付管理クラスオブジェクト</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime Add(HySTime csTime)
        {
            m_dGeologicalTime += csTime.m_dGeologicalTime;
            m_dSecTime += csTime.m_dSecTime;
            return this;
        }
        /// <summary><para>method outline:</para>
        /// <para>時間更新（減算）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = Subtract(csTime) </para>
        /// </example>
        /// <param name="csTime">日付管理クラスオブジェクト</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public HySTime Subtract(HySTime csTime)
        {
            m_dGeologicalTime -= csTime.m_dGeologicalTime;
            m_dSecTime -= csTime.m_dSecTime;
            return this;
        }


        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（+）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = csTime1 + csTime2 </para>
        /// </example>
        /// <param name="csTime1">日付管理クラスオブジェクト１</param>
        /// <param name="csTime2">日付管理クラスオブジェクト２</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Add() 使用に比べて処理時間は遅くなる</para>
        /// </remarks>
        public static HySTime operator +(HySTime csTime1, HySTime csTime2)
        {
            HySTime csHySTime = new HySTime(0);
            csHySTime.m_dGeologicalTime = csTime1.m_dGeologicalTime + csTime2.m_dGeologicalTime;
            csHySTime.m_dSecTime = csTime1.m_dSecTime + csTime2.m_dSecTime;

            return csHySTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（-）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = csTime1 - csTime2 </para>
        /// </example>
        /// <param name="csTime1">日付管理クラスオブジェクト１</param>
        /// <param name="csTime2">日付管理クラスオブジェクト２</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>Subtract() 使用に比べて処理時間は遅くなる</para>
        /// </remarks>
        public static HySTime operator -(HySTime csTime1, HySTime csTime2)
        {
            HySTime csHySTime = new HySTime(0);
            csHySTime.m_dGeologicalTime = csTime1.m_dGeologicalTime - csTime2.m_dGeologicalTime;
            csHySTime.m_dSecTime = csTime1.m_dSecTime - csTime2.m_dSecTime;

            return csHySTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（*）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = csTime1 * csTime2 </para>
        /// </example>
        /// <param name="dK">倍数</param>
        /// <param name="csTime2">日付管理クラスオブジェクト２</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySTime operator *(double dK, HySTime csTime2)
        {
            HySTime csHySTime = new HySTime(0);
            csHySTime.m_dGeologicalTime = dK * csTime2.m_dGeologicalTime;
            csHySTime.m_dSecTime = dK * csTime2.m_dSecTime;

            return csHySTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算子のオーバーロード（*）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = csTime1 * csTime2 </para>
        /// </example>
        /// <param name="csTime1">日付管理クラスオブジェクト</param>
        /// <param name="dK">倍数</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySTime operator *(HySTime csTime1,double dK)
        {
            HySTime csHySTime = new HySTime(0);
            csHySTime.m_dGeologicalTime = dK * csTime1.m_dGeologicalTime;
            csHySTime.m_dSecTime = dK * csTime1.m_dSecTime;

            return csHySTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Equals(csDate) </para>
        /// </example>
        /// <param name="csDate">比較用日付管理クラスオブジェクト</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Equals(HySDate csDate)
        {
            bool bRtn = false;
            HySTime csTime = csDate as HySTime;
            if ((object)csTime == null)
            {
                return bRtn;
            }
            if (m_dSecTime == csTime.m_dSecTime)
            {
                bRtn = true;
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Equals(csDate) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト</param>
        /// <returns>bool　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Equals(HySTime csTime)
        {
            // bool bRtn = false; <-- 速度アップのため、ローカル変数のnew を防ぐ
            if (csTime != null)
            {
                if (m_dSecTime == csTime.m_dSecTime)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = After(csDate) </para>
        /// </example>
        /// <param name="csDate">比較用日付管理クラスオブジェクト</param>
        /// <returns>bool　true:=条件一致, false:=条件不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool After(HySDate csDate)
        {
            bool bRtn = false;
            HySTime csTime = csDate as HySTime;
            if ((object)csTime == null)
            {
                return bRtn;
            }
            if (m_dSecTime > csTime.m_dSecTime)
            {
                bRtn = true;
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = After(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト</param>
        /// <returns>bool　true:=条件一致, false:=条件不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool After(HySTime csTime)
        {
            // bool bRtn = false; <-- 速度アップのため、ローカル変数のnew を防ぐ
            if (csTime != null)
            {
                if (m_dSecTime > csTime.m_dSecTime)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Before(csDate) </para>
        /// </example>
        /// <param name="csDate">比較用日付管理クラスオブジェクト</param>
        /// <returns>bool　true:=条件一致, false:=条件不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Before(HySDate csDate)
        {
            bool bRtn = false;

            HySTime csTime = csDate as HySTime;
            if ((object)csTime == null)
            {
                return bRtn;
            }
            if (m_dSecTime < csTime.m_dSecTime)
            {
                bRtn = true;
            }

            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bWork = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト</param>
        /// <returns>bool　true:=条件一致, false:=条件不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Before(HySTime csTime)
        {
            // bool bRtn = false; <-- 速度アップのため、ローカル変数のnew を防ぐ
            if (csTime != null)
            {
                if (m_dSecTime < csTime.m_dSecTime)
                {
                    return true;
                }
            }
            return false;
        }

        /// <summary><para>method outline:</para>
        /// <para>地質学的経年設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = SetGeologicalYear(dYear) </para>
        /// </example>
        /// <param name="dYear">地質学的経年　２０００年を０としての地質学的経年を示す。負は、２０００年よりも過去</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>将来用</para>
        /// </remarks> 
        public HySTime SetGeologicalYear(double dYear)
        {   
            m_dGeologicalTime = dYear;
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>地質学的経年更新（加算）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = AddGeologicalYear(dYear) </para>
        /// </example>
        /// <param name="dYear">地質学的経年</param>
        /// <returns>HySTime　日付管理クラスオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>将来用</para>
        /// </remarks> 
        public HySTime AddGeologicalYear(double dYear)
        {   
            m_dGeologicalTime += dYear;
            return this;
        }

        /// <summary><para>method outline:</para>
        /// <para>時間取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dData = GetTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double  秒数取得 </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public double GetTime()
        {
            return m_dSecTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>時間取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dData = csHySTime.TotalSec() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double  秒数取得</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ﾌﾟﾛﾄﾀｲﾌﾟ版互換用：使用を奨励しない　GetTime()メソッドを使用して下さい</para>
        /// </remarks>
        //[Obsolete("旧バージョン互換用：使用を奨励しない　GetTime()メソッドを使用して下さい")]
        public double TotalSec()
        {
            return m_dSecTime;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================

        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>地質学的経年取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dData = GetGeologicalYear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double　２０００年を０としての地質学的経年を示す。負は、２０００年よりも過去</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        public virtual double GetGeologicalYear()
        {
            return m_dGeologicalTime;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }

        /// <summary>未設定時刻</summary>
        //static public readonly HySTime DEFAULT_TIME = new HySTime(-20000 * 365, -20000 * 6, 0, 0);
        static public readonly HySTime DEFAULT_TIME = new HySTime( (-1970 * 365) -112, 0, 0, 0);
    }
}
