﻿// <summary>ソースコード：拡張ツール情報基底クラス（抽象クラス）</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>拡張ツール情報クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>本クラスの派生クラスは全て[Serializable]であること</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/10/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySUserToolInfoData : HySDataRoot
    {
        /// <summary>
        /// 業務識別子
        /// </summary>
        protected HySString m_csBusinessKind = new HySString("");
        /// <summary>
        /// ツール名称
        /// </summary>
        protected HySString m_csToolName = new HySString("");
        /// <summary>
        /// ランチャー用アイコン名称
        /// </summary>
        protected HySString m_csToolIconName = new HySString("");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySUserToolInfoData csToolInfoData = new HySUserToolInfoData( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySUserToolInfoData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySUserToolInfoData()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySUserToolInfoData csToolInfoData = new HySUserToolInfoData( sBusinessKind, sToolName, sIconName )</para>
        /// </example>
        /// <param name="sBusinessKind">業務識別子</param>
        /// <param name="sToolName">ツール名称</param>
        /// <param name="sIconName">ランチャー用アイコン名称</param>
        /// <returns>HySUserToolInfoData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySUserToolInfoData(string sBusinessKind, string sToolName, string sIconName)
        {
            m_csBusinessKind = new HySString(sBusinessKind);
            m_csToolName = new HySString(sToolName);
            m_csToolIconName = new HySString(sIconName);
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySUserToolInfoData csToolInfoData = new HySUserToolInfoData( sBusinessKind, sToolName, sIconName )</para>
        /// </example>
        /// <param name="sBusinessKind">業務識別子</param>
        /// <param name="sToolName">ツール名称</param>
        /// <param name="sIconName">ランチャー用アイコン名称</param>
        /// <returns>HySUserToolInfoData 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySUserToolInfoData(HySKind sBusinessKind, HySString sToolName, HySString sIconName)
        {
            m_csBusinessKind = (HySString)sBusinessKind.GetString();
            m_csToolName = sToolName;
            m_csToolIconName = sIconName;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetBusinessKind()</para>
        /// </example>
        /// <returns>業務識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetBusinessKind()
        { 
            return m_csBusinessKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetToolName()</para>
        /// </example>
        /// <returns>ツール名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetToolName()
        { 
            return m_csToolName;
        }

        /// <summary><para>method outline:</para>
        /// <para>ランチャー用アイコン名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetToolIconName()</para>
        /// </example>
        /// <returns>ランチャー用アイコン名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetToolIconName()
        { 
            return m_csToolIconName;
        }

    }
}
