﻿// <summary>ソースコード：ＧＩＳ楕円クラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ楕円クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>HySGeometryから引き継いだ属性としては</para> 
    /// <para>個別図形識別子、線幅、線色(RGBA)、面色(RGBA)、塗り潰しパターン、高度設定モード、地面からの突き出しモードが有効</para>
    /// </remarks>
    [Serializable]
    public class HySGeometryEllipse : HySGeometry , HySVersionManagement
    {
        /// <summary>南西頂点緯度（度単位）</summary>
        protected double m_dSWLatitude;
        /// <summary>南西頂点経度（度単位）</summary>
        protected double m_dSWLongitude;
        /// <summary>北東頂点緯度（度単位）</summary>
        protected double m_dNELatitude;
        /// <summary>北東頂点経度（度単位）</summary>
        protected double m_dNELongitude;

        /// <summary>標高（m単位）</summary>
        protected double m_dAltitude = 0.0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeometry csGeometry = new HySGeometryEllipse()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeometry 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeometryEllipse()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>南西頂点緯度設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSWLatitude( dSWLatit ) </para>
        /// </example>
        /// <param name="dSWLatit">南西頂点緯度</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSWLatitude(double dSWLatit)
        {
            m_dSWLatitude = dSWLatit;
        }
        /// <summary><para>method outline:</para>
        /// <para>南西頂点緯度取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dSWLatit = GetSWLatitude( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>南西頂点緯度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetSWLatitude()
        {
            return m_dSWLatitude;
        }

        /// <summary><para>method outline:</para>
        /// <para>南西頂点経度設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSWLongitude( dSWLongit ) </para>
        /// </example>
        /// <param name="dSWLongit">南西頂点経度</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSWLongitude(double dSWLongit)
        {
            m_dSWLongitude = dSWLongit;
        }
        /// <summary><para>method outline:</para>
        /// <para>南西頂点経度取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dSWLongit = GetSWLongitude( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>南西頂点経度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetSWLongitude()
        {
            return m_dSWLongitude;
        }

        /// <summary><para>method outline:</para>
        /// <para>北東頂点緯度設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNELatitude( dNELatit ) </para>
        /// </example>
        /// <param name="dNELatit">北東頂点緯度</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetNELatitude(double dNELatit)
        {
            m_dNELatitude = dNELatit;
        }
        /// <summary><para>method outline:</para>
        /// <para>北東頂点緯度取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dNELatit = GetNELatitude( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>北東頂点緯度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetNELatitude()
        {
            return m_dNELatitude;
        }

        /// <summary><para>method outline:</para>
        /// <para>北東頂点経度設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNELongitude( dNELongit ) </para>
        /// </example>
        /// <param name="dNELongit">北東頂点経度</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetNELongitude(double dNELongit)
        {
            m_dNELongitude = dNELongit;
        }
        /// <summary><para>method outline:</para>
        /// <para>北東頂点経度取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dNELongit = GetNELongitude( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>北東頂点経度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetNELongitude()
        {
            return m_dNELongitude;
        }

        /// <summary><para>method outline:</para>
        /// <para>標高設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAltitude( dAltit ) </para>
        /// </example>
        /// <param name="dAltit">標高</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAltitude(double dAltit)
        {
            m_dAltitude = dAltit;
        }
        /// <summary><para>method outline:</para>
        /// <para>標高取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dAltit = GetAltitude( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>標高</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetAltitude()
        {
            return m_dAltitude;
        }



        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();
            
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
