﻿// <summary>ソースコード：地理的一次元配列  データ 基底抽象化クラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
//using CommonMP.HYSSOP.CoreImpl.HSData.CommonData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>1次元地理情報データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>
    /// 地理空間上に1次元情報を保持できる（但し直交座標）
    /// 将来用：コーディング
    /// </para>
    /// </remarks>
    [Serializable]
    public class HySGeoDim1Data : HySTimeRecordIF, HySVersionManagement
    {
        /// <summary>分割セル数</summary>
        protected long m_lCellDim = 1;
        //============　保持情報　================
        /// <summary>配列データ本体</summary>
        protected HySD1CellArrayData m_csCellData = null;
        //============　地理的情報　================
        ///// <summary>代表位置情報</summary>
        //protected HySGeoPoint m_csGeoPosition = new HySGeoPoint(35.0, 135.0, 1000.0);

        //==================================================================
        //                                                                  
        //       　　　　　　       セル                                    
        //    ------------------------------------------------------        
        //    | ①  |    ②  | ③ |     ④      |   ⑤   |   ⑥    |        
        //    ------------------------------------------------------        
        // 　                    ↑             ↑                          
        // 　　　　    　　　セル④の始点　   セル④の終点                  
        //                  セル③の終点　   セル⑤の始点                   
        //                                                                  
        //==================================================================

        /// <summary>距離配列[m] 最初のセルの始点からの距離</summary>
        protected double[] m_dDistance = null;
        /// <summary>セルの始点／終点の緯度「度」　セル数よりも１点多くなることに注意</summary>
        protected double[] m_dCellLat = null;
        /// <summary>セルの始点／終点の経度「度」　セル数よりも１点多くなることに注意</summary>
        protected double[] m_dCellLon = null;
        /// <summary>代表点の緯度「度」</summary>
        protected double[] m_dSpecificLat = null;
        /// <summary>代表点の経度「度」</summary>
        protected double[] m_dSpecificLon = null;

        //============　パターン情報　================
        /// <summary>メッシュセルパターン数</summary>
        protected long m_lPatternNum = 0;
        /// <summary>メッシュセル表示パターン情報</summary>
        protected HySGeoMeshDispPattern[] m_csPatternInf = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySGeoDim1Data()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1Data csData = new HySGeoDim1Data(lDataDimInCell); </para>
        /// </example>
        /// <param name="lDataDimInCell">１メッシュ内のデータ配列数</param>
        /// <returns> HySGeoDim1Data 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim1Data(long lDataDimInCell)
        {
            m_csCellData = new HySD1CellArrayData(lDataDimInCell);
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1Data csData = new HySGeoDim1Data(lCellDim, lDataDimInCell); </para>
        /// </example>
        /// <param name="lCellDim1">セル分割数</param>
        /// <param name="lDataDimInCell">１メッシュ内のデータ配列数</param>
        /// <returns> HySGeoDim1Data 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim1Data(long lCellDim1, long lDataDimInCell)
        {
            //m_lCellDim = lCellDim;
            //m_csCellData = new HySD1CellArrayData(lCellDim, lDataDimInCell);
            //m_dDistance = new double[m_lCellDim];
            //m_dCellLat = new double[m_lCellDim + 1];
            //m_dCellLon = new double[m_lCellDim + 1];
            //m_dSpecificLat = new double[m_lCellDim];
            //m_dSpecificLon = new double[m_lCellDim];
            this.Init(lCellDim1, lDataDimInCell, true);
            //バージョン情報設定
            SetNowVersion();
        }    
        /// <summary><para>method outline:</para>
        /// <para>内部処理用コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1Data csData = new HySGeoDim1Data(lCellDim1, lDataDimInCell, false); </para>
        /// </example>
        /// <param name="lCellDim1">セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <param name="bSW">常にfalse</param>
        /// <returns> HySGeoDim1Data 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>内部処理用：
        ///   時系列情報として情報を設定するとき　各レコード間に共通な情報を
        /// 　内部に冗長な情報として持たないように、共通情報の生成を止めて生成する
        /// </para>
        /// </remarks>
        internal HySGeoDim1Data(long lCellDim1, long lDataDimInCell, bool bSW)
        {
            //m_csCellData = new HySD1CellArrayData(lCellDim1, lDataDimInCell, false);
            this.Init(lCellDim1, lDataDimInCell, true);
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1Data csData = new HySGeoDim1Data(csOrgData); </para>
        /// </example>
        /// <param name="csOrgData">コピー元データ</param>
        /// <returns> HySGeoDim1Data 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim1Data( HySGeoDim1Data csOrgData )
        {
            this.CopyData(csOrgData);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lCellDim1, lDataDimInCell, bSW) </para>
        /// </example>
        /// <param name="lCellDim1">セル配列数</param>
        /// <param name="lDataDimInCell">セル内データ配列数</param>
        /// <param name="bSW">レコードフラグ：</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected virtual void Init(long lCellDim1, long lDataDimInCell, bool bSW)
        {
            if (bSW == true)
            {
                m_lCellDim = lCellDim1;
                m_csCellData = new HySD1CellArrayData(lCellDim1, lDataDimInCell);
                m_dDistance = new double[m_lCellDim];
                m_dCellLat = new double[m_lCellDim + 1];
                m_dCellLon = new double[m_lCellDim + 1];
                m_dSpecificLat = new double[m_lCellDim];
                m_dSpecificLon = new double[m_lCellDim];
            }
            else
            {
                m_csCellData = new HySD1CellArrayData(lCellDim1, lDataDimInCell, false);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>配列インスタンス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySCellData[] csData = GetCellData();</para>
        /// <para>y = csData[j]; (取得)</para>
        /// <para>csData[i] = x; (代入)</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellData[] １次元配列インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>配列のインデックスは０相対</para>
        /// </remarks>
        public HySCellData[] GetCellData()
        {
            return ((HySD1CellArrayData)m_csCellData).GetCellData();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySCellArray csCellArry = GetCellArray();
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellArray セル内データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellArray GetCellArray()
        {
            return m_csCellData; 
        }

        /// <summary><para>method outline:</para>
        /// <para>距離配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellDistance(dDistance)</para> 
        /// </example>
        /// <param name="dDistance">double[] 最初のセル始点からの距離配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellDistance(double[] dDistance)
        {
            m_dDistance = dDistance;
        }

        /// <summary><para>method outline:</para>
        /// <para>距離配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dDistance = GetCellDistance()</para> 
        /// <para>例：1番目のセル始点から、1番目のセル終点までの距離情報設定　dDistance[0] = x;</para>
        /// <para>例：1番目のセル始点から、2番目のセル終点までの距離情報設定　dDistance[1] = x;</para>
        /// <para>例：1番目のセル始点から、1番目のセル終点までの距離情報取得　y = dDistance[0];</para>
        /// <para>例：1番目のセル始点から、2番目のセル終点までの距離情報取得　y = dDistance[1];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 最初のセル始点からの距離配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetCellDistance()
        {
            return m_dDistance;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点緯度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellLatitude(dCellLat)</para> 
        /// </example>
        /// <param name="dCellLat">double[] セルの始点／終点の緯度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellLatitude(double[] dCellLat)
        {
            m_dCellLat = dCellLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点緯度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dCellLat = GetCellLatitude()</para> 
        /// <para>例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;</para>
        /// <para>例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;</para>
        /// <para>dCellLat[1]は同時に2番目のセル始点となる</para>
        /// <para>例：1番目のセル始点の緯度情報取得　y = dCellLat[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] セルの始点／終点の緯度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetCellLatitude()
        {
            return m_dCellLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点経度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellLongitude(dCellLon)</para> 
        /// </example>
        /// <param name="dCellLon">double[] セルの始点／終点の経度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellLongitude(double[] dCellLon)
        {
            m_dCellLon = dCellLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点経度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dCellLon = GetCellLongitude()</para> 
        /// <para>例：1番目のセル始点の経度情報設定　dCellLon[0] = x;</para>
        /// <para>例：1番目のセル終点の経度情報設定　dCellLon[1] = x;</para>
        /// <para>dCellLon[1]は同時に2番目のセル始点となる</para>
        /// <para>例：1番目のセル始点の経度情報取得　y = dCellLon[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] セルの始点／終点の経度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetCellLongitude()
        {
            return m_dCellLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の緯度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSpecificLatitude(dSpecificLat)</para> 
        /// </example>
        /// <param name="dSpecificLat">double[] 代表点の緯度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSpecificLatitude(double[] dSpecificLat)
        {
            m_dSpecificLat = dSpecificLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の緯度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dSpecificLat = GetSpecificLatitude()</para> 
        /// <para>例：1番目のセルデータの緯度情報設定　dSpecificLat[0] = x;</para>
        /// <para>例：1番目のセルデータの緯度情報取得　y = dSpecificLat[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 代表点の緯度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetSpecificLatitude()
        {
            return m_dSpecificLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の経度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSpecificLongitude(dSpecificLon)</para> 
        /// </example>
        /// <param name="dSpecificLon">double[] 代表点の経度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSpecificLongitude(double[] dSpecificLon)
        {
            m_dSpecificLon = dSpecificLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の経度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dSpecificLon = GetSpecificLongitude()</para> 
        /// <para>例：1番目のセルデータの経度情報設定　dSpecificLon[0] = x;</para>
        /// <para>例：1番目のセルデータの経度情報取得　y = dSpecificLon[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 代表点の経度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetSpecificLongitude()
        {
            return m_dSpecificLon;
        }

        ///// <summary><para>method outline:</para>
        ///// <para>地理的代表位置設定</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> SetLocation(dLat, dLon, dAlt) </para>
        ///// </example>
        ///// <param name="dLat">緯度（度単位）</param>
        ///// <param name="dLon">経度（度単位）</param>
        ///// <param name="dAlt">緯度（ｍ単位）</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public void SetLocation(double dLat, double dLon, double dAlt)
        //{
        //    m_csGeoPosition.m_dLatitude = dLat;
        //    m_csGeoPosition.m_dLongitude = dLon;
        //    m_csGeoPosition.m_dAltitude = dAlt;
        //}
        ///// <summary><para>method outline:</para>
        ///// <para>地理的代表位置取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> GetLocation(ref dLat, ref dLon, ref dAlt) </para>
        ///// </example>
        ///// <param name="dLat">緯度（度単位）</param>
        ///// <param name="dLon">経度（度単位）</param>
        ///// <param name="dAlt">緯度（ｍ単位）</param>
        ///// <returns>HySGeoPoint 代表位置</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySGeoPoint GetLocation(ref double dLat, ref double dLon, ref double dAlt)
        //{
        //    dLat = m_csGeoPosition.m_dLatitude;
        //    dLon = m_csGeoPosition.m_dLongitude;
        //    dAlt = m_csGeoPosition.m_dAltitude;
        //    return m_csGeoPosition;
        //}
        ///// <summary><para>method outline:</para>
        ///// <para>地理的代表位置取得</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> HySGeoPoint csPos = GetLocation() </para>
        ///// </example>
        ///// <param name="">無し</param>
        ///// <returns>HySGeoPoint 代表位置</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>無し</para>
        ///// </remarks>
        //public HySGeoPoint GetLocation( )
        //{
        //    return m_csGeoPosition;
        //}


        /// <summary><para>method outline:</para>
        /// <para>時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTime(HySTime csTime)
        {
            m_csCellData.SetTime(csTime);
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime 時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetLastTime()
        {
            return m_csCellData.GetLastTime();
        }

        /// <summary><para>method outline:</para>
        /// <para>日付時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date と同じ場合は true、そうでない場合は false
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool EqualTime(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csCellData != null)
            {
                bRtn = m_csCellData.EqualTime(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">
        /// 比較用日付管理クラスオブジェクト(HySTime)
        /// </param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool After(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csCellData != null)
            {
                bRtn = m_csCellData.After(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻より前の場合は true、そうでない場合は false</para>
        /// </remarks>
        public bool Before(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csCellData != null)
            {
                bRtn = m_csCellData.Before(csTime);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        {
            m_csCellData.SetCellDataCharacteristic(csCellChara);
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();</para>
        /// <para> csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { 
            return m_csCellData.GetCellDataCharacteristic();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            return m_csCellData.GetDataDimentionInCell();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData); </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別子とセルの配列管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellIDMngData(HySCellIDManageData csCellIDMngData)
        {
            m_csCellData.SetCellIDMngData(csCellIDMngData);
        }

        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMngDt = GetCellIDMngData( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>HySCellIDManageData セル識別管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellIDManageData GetCellIDMngData()
        {
            return m_csCellData.GetCellIDMngData();
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataMeaning(lDimItemNo, csMeaningKind) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <param name="csMeaning">データの意味</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataMeaning(long lDimItemNo, HySObjectKind csMeaning)
        {
            m_csCellData.SetDataMeaning(lDimItemNo, csMeaning);
        }
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtMeaning = GetDataMeaning(lDimItemNo) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <returns>HySObjectKind データの意味</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataMeaning(long lDimItemNo)
        {
            return m_csCellData.GetDataMeaning(lDimItemNo);
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyData(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CopyData(HySGeoDim1Data csOrgData)
        {
            if (csOrgData != null)
            {
                this.m_lCellDim = csOrgData.m_lCellDim;
                this.m_csCellData = new HySD1CellArrayData(csOrgData.m_csCellData);
                //m_csGeoPosition = new HySGeoPoint(
                //    csOrgData.m_csGeoPosition.m_dLatitude,
                //    csOrgData.m_csGeoPosition.m_dLongitude,
                //    csOrgData.m_csGeoPosition.m_dAltitude);

                this.m_dDistance = new double[m_lCellDim];
                this.m_dSpecificLat = new double[m_lCellDim];
                this.m_dSpecificLon = new double[m_lCellDim];
                for (long lLp = 0; lLp < m_lCellDim; lLp++)
                {
                    m_dDistance[lLp] = csOrgData.m_dDistance[lLp];
                    m_dSpecificLat[lLp] = csOrgData.m_dSpecificLat[lLp];
                    m_dSpecificLon[lLp] = csOrgData.m_dSpecificLon[lLp];
                }

                this.m_dCellLat = new double[m_lCellDim + 1];
                this.m_dCellLon = new double[m_lCellDim + 1];
                for (long lLp = 0; lLp < m_lCellDim + 1; lLp++)
                {
                    m_dCellLat[lLp] = csOrgData.m_dCellLat[lLp];
                    m_dCellLon[lLp] = csOrgData.m_dCellLon[lLp];
                }
            }
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
