﻿// <summary>ソースコード：ＨＹＳＳＯＰ２次元地理メッシュ情報　時系列 データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>1次元地理情報時系列データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>地理空間上に1次元情報を保持できる（但し直交座標）</para>
    /// <para>Remarks</para>
    /// <para>将来用：コーディング</para>
    /// </remarks>
    [Serializable]
    public class HySGeoDim1SerialData : HySTimeSeriesBase, HySVersionManagement
    {
        /// <summary>分割セル数</summary>
        protected long m_lCellDim=1;
        /// <summary> 配列データの意味を示す </summary>
        protected HySDataCharacteristicInCell m_csCellDataKind = null;
        /// <summary>セル識別子管理情報 </summary>
        protected HySCellIDManageData m_csCellIDMngData = new HySCellIDManageData();

        // 位置情報としては、１）、２）、３）の何れかを設定する。
        // 全てを設定する必要はない

        // １）
        //    -------------------------------------------------- 
        //    | (0) | ①  |    ②  | ③ |     ④      |   ⑤   |  
        //    --------------------------------------------------
        //          ↑                               ↑         
        //         m_dDistance[0]                 m_dDistance[4]
        /// <summary>距離配列[m] 最初のセルの始点からの対象セルの終点までの距離</summary>
        protected double[] m_dDistance = null;

        // ２）
        /// <summary>代表点の緯度「度」</summary>
        protected double[] m_dSpecificLat = null;
        /// <summary>代表点の経度「度」</summary>
        protected double[] m_dSpecificLon = null;

        // ３）
        //==================================================================
        //                                                                  
        //       　　　　　　       セル                                    
        //    -----------------------------------------------------------  
        //   | (0)  | ①  |    ②  | ③ |     ④      |   ⑤   |   ⑥    |  
        //    -----------------------------------------------------------  
        // 　                          ↑             ↑                   
        // 　　　　    　      　　セル④の始点　   セル④の終点              
        //                        セル③の終点　   セル⑤の始点               
        //                                                                  
        //==================================================================
        /// <summary>セルの始点／終点の緯度「度」　セル数よりも１点多くなることに注意</summary>
        protected double[] m_dCellLat = null;
        /// <summary>セルの始点／終点の経度「度」　セル数よりも１点多くなることに注意</summary>
        protected double[] m_dCellLon = null;

    
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySGeoDim1SerialData()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1SerialData csData = new HySGeoDim1SerialData(lDataDimInCell); </para>
        /// </example>
        /// <param name="lDataDimInCell">１メッシュ内のデータ配列数</param>
        /// <returns> HySGeoDim1SerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim1SerialData(long lDataDimInCell)
        {
            m_csCellDataKind = new HySDataCharacteristicInCell(lDataDimInCell);
            m_dDistance = new double[m_lCellDim];
            m_dCellLat = new double[m_lCellDim + 1];
            m_dCellLon = new double[m_lCellDim + 1];
            m_dSpecificLat = new double[m_lCellDim];
            m_dSpecificLon = new double[m_lCellDim];
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1SerialData csData = new HySGeoDim1SerialData(lCellDim,lDataDimInCell); </para>
        /// </example>
        /// <param name="lCellDim">セル分割数</param>
        /// <param name="lDataDimInCell">１メッシュ内のデータ配列数</param>
        /// <returns> HySGeoDim1SerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim1SerialData(long lCellDim, long lDataDimInCell)
        {
            m_lCellDim = lCellDim;
            m_csCellDataKind = new HySDataCharacteristicInCell(lDataDimInCell);
            m_dDistance = new double[m_lCellDim];
            m_dCellLat = new double[m_lCellDim + 1];
            m_dCellLon = new double[m_lCellDim + 1];
            m_dSpecificLat = new double[m_lCellDim];
            m_dSpecificLon = new double[m_lCellDim];
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>距離配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellDistance(dDistance)</para> 
        /// </example>
        /// <param name="dDistance">double[] 最初のセル始点からの距離配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellDistance(double[] dDistance)
        {
            m_dDistance = dDistance;
        }

        /// <summary><para>method outline:</para>
        /// <para>距離配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dDistance = GetCellDistance()</para> 
        /// <para>例：1番目のセル始点から、1番目のセル終点までの距離情報設定　dDistance[0] = x;</para>
        /// <para>例：1番目のセル始点から、2番目のセル終点までの距離情報設定　dDistance[1] = x;</para>
        /// <para>例：1番目のセル始点から、1番目のセル終点までの距離情報取得　y = dDistance[0];</para>
        /// <para>例：1番目のセル始点から、2番目のセル終点までの距離情報取得　y = dDistance[1];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 最初のセル始点からの距離配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetCellDistance()
        {
            return m_dDistance;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点緯度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellLatitude(dCellLat)</para> 
        /// </example>
        /// <param name="dCellLat">double[] セルの始点／終点の緯度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellLatitude(double[] dCellLat)
        {
            m_dCellLat = dCellLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点緯度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dCellLat = GetCellLatitude()</para> 
        /// <para>例：1番目のセル始点の緯度情報設定　dCellLat[0] = x;</para>
        /// <para>例：1番目のセル終点の緯度情報設定　dCellLat[1] = x;</para>
        /// <para>dCellLat[1]は同時に2番目のセル始点となる</para>
        /// <para>例：1番目のセル始点の緯度情報取得　y = dCellLat[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] セルの始点／終点の緯度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetCellLatitude()
        {
            return m_dCellLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点経度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCellLongitude(dCellLon)</para> 
        /// </example>
        /// <param name="dCellLon">double[] セルの始点／終点の経度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellLongitude(double[] dCellLon)
        {
            m_dCellLon = dCellLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル始点・終点経度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dCellLon = GetCellLongitude()</para> 
        /// <para>例：1番目のセル始点の経度情報設定　dCellLon[0] = x;</para>
        /// <para>例：1番目のセル終点の経度情報設定　dCellLon[1] = x;</para>
        /// <para>dCellLon[1]は同時に2番目のセル始点となる</para>
        /// <para>例：1番目のセル始点の経度情報取得　y = dCellLon[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] セルの始点／終点の経度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetCellLongitude()
        {
            return m_dCellLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の緯度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSpecificLatitude(dSpecificLat)</para> 
        /// </example>
        /// <param name="dSpecificLat">double[] 代表点の緯度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSpecificLatitude(double[] dSpecificLat)
        {
            m_dSpecificLat = dSpecificLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の緯度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dSpecificLat = GetSpecificLatitude()</para> 
        /// <para>例：1番目のセルデータの緯度情報設定　dSpecificLat[0] = x;</para>
        /// <para>例：1番目のセルデータの緯度情報取得　y = dSpecificLat[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 代表点の緯度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetSpecificLatitude()
        {
            return m_dSpecificLat;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の経度情報配列の設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSpecificLongitude(dSpecificLon)</para> 
        /// </example>
        /// <param name="dSpecificLon">double[] 代表点の経度情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSpecificLongitude(double[] dSpecificLon)
        {
            m_dSpecificLon = dSpecificLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>代表点の経度情報配列の取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[] dSpecificLon = GetSpecificLongitude()</para> 
        /// <para>例：1番目のセルデータの経度情報設定　dSpecificLon[0] = x;</para>
        /// <para>例：1番目のセルデータの経度情報取得　y = dSpecificLon[0];</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>double[] 代表点の経度情報配列</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[] GetSpecificLongitude()
        {
            return m_dSpecificLon;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            return m_csCellDataKind.m_lDim;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        {
            m_csCellDataKind = csCellChara;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();</para>
        /// <para> csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellDataKind; }

        /// <summary><para>method outline:</para>
        /// <para>分割セル数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetCellDimension() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 分割セル数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCellDimension()
        {
            return m_lCellDim;
        }

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>GetNewRecord 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return new HySGeoDim1Data(m_lCellDim, m_csCellDataKind.m_lDim);
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyData(csOrgTimeSeriesData) </para>
        /// </example>
        /// <param name="csOrgTimeSeriesData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySTimeSeriesBase csOrgTimeSeriesData)
        {
            HySGeoDim1SerialData csOrgData = csOrgTimeSeriesData as HySGeoDim1SerialData;
            HySGeoDim1Data csRecordData = null;
            if (csOrgData != null)
            {
                // 時系列情報のコピー
                m_lMaxDataNum = csOrgData.m_lMaxDataNum;
                m_csLastTime = csOrgData.m_csLastTime.Clone();
                this.m_csDataList.Clear();

                long lDataNum = csOrgData.GetCount();
                csOrgData.SetCursorFirst();
                for(long lLp=0;lLp<lDataNum;lLp++)
                {
                    csRecordData = csOrgData.GetCursorData() as HySGeoDim1Data;
                    this.AddData(new HySGeoDim1Data(csRecordData));
                    csOrgData.MoveCursorNext();
                }
                // 地理情報のコピー
                m_lCellDim = csOrgData.m_lCellDim;
                m_csCellDataKind = csOrgData.m_csCellDataKind.Clone();
                m_csCellIDMngData.CopyData(csOrgData.m_csCellIDMngData);
                m_dDistance = new double[m_lCellDim];
                this.m_dSpecificLat = new double[m_lCellDim];
                this.m_dSpecificLon = new double[m_lCellDim];
                for (long lLp = 0; lLp < m_lCellDim; lLp++)
                {
                    m_dDistance[lLp] = csOrgData.m_dDistance[lLp];
                    m_dSpecificLat[lLp] = csOrgData.m_dSpecificLat[lLp];
                    m_dSpecificLon[lLp] = csOrgData.m_dSpecificLon[lLp];
                }
                m_dCellLat = new double[m_lCellDim + 1];
                m_dCellLon = new double[m_lCellDim + 1];
                for (long lLp = 0; lLp < m_lCellDim + 1; lLp++)
                {
                    m_dCellLat[lLp] = csOrgData.m_dCellLat[lLp];
                    m_dCellLon[lLp] = csOrgData.m_dCellLon[lLp];
                }
            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataMeaning(lDimItemNo, csMeaningKind) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <param name="csMeaning">データの意味</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataMeaning(long lDimItemNo, HySObjectKind csMeaning)
        {
            if (lDimItemNo >= 0 && lDimItemNo < m_csCellDataKind.m_lDim)
            {
                m_csCellDataKind.m_csDataKind[lDimItemNo] = csMeaning.Clone();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtMeaning = GetDataMeaning(lDimItemNo) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <returns>HySObjectKind データの意味</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataMeaning(long lDimItemNo)
        {
            HySObjectKind csRtn = null;
            if (lDimItemNo >= 0 && lDimItemNo < m_csCellDataKind.m_lDim)
            {
                csRtn = m_csCellDataKind.m_csDataKind[lDimItemNo];
            }

            return csRtn;
        }
        */
        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData) </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別管理データ</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCellIDMngData(HySCellIDManageData csCellIDMngData)
        {
            m_csCellIDMngData = csCellIDMngData;
        }
        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMngDt = GetCellIDMngData( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>HySCellIDManageData セル識別管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCellIDManageData GetCellIDMngData()
        {
            return m_csCellIDMngData;
        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim1SerialData csGeoDim1SerialData = CreateInstance() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySGeoDim1SerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分自身の同一の型のインスタンスを生成する</para>
        /// </remarks>
        protected virtual HySGeoDim1SerialData CreateInstance()
        {
            // 自身と同じ形のインスタンスを生成する
            return new HySGeoDim1SerialData(m_lCellDim, m_csCellDataKind.m_lDim);
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public new void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
