﻿// <summary>ソースコード：２次元地理メッシュ情報　時系列 データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>２次元地理メッシュ情報時系列 データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>２次元地理メッシュ情報（HySGeoDim2MeshData）を時系列情報として保持できる</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySGeoDim2MeshSerialData : HySGeoMeshSerial, HySVersionManagement
    {

        /// <summary>標高（m単位）m_lMeshKind = PATTARN_DATA_HOLD の場合に有効</summary>
        public double m_dDispAltitude = 0.0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        private HySGeoDim2MeshSerialData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshSerial csData = new HySGeoDim2MeshData(lKind,lLonDim,lLatDim,lCellDataDim); </para>
        /// </example>
        /// <param name="lKind">保持するデータの形</param>
        /// <param name="lLonDim">経度方向のメッシュ分割数</param>
        /// <param name="lLatDim">緯度方向のメッシュ分割数</param>
        /// <param name="lCellDataDim">１メッシュ内のデータ配列数</param>
        /// <returns> HySGeoDim2MeshData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim2MeshSerialData(HySGeoMesh.MESH_DATA_KIND lKind, long lLonDim, long lLatDim, long lCellDataDim) 
            :base(lKind, lLonDim, lLatDim, 1, lCellDataDim)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshSerial csData = new HySGeoDim2MeshSerialData(csMeshData); </para>
        /// </example>
        /// <param name="csMeshData">地理メッシュ情報</param>
        /// <returns> HySGeoDim2MeshSerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim2MeshSerialData(HySGeoDim2MeshData csMeshData)
            : base((HySGeoMesh)csMeshData)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim2MeshSerialData csData = new HySGeoDim2MeshSerialData(csOrgData); </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> HySGeoDim2MeshSerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim2MeshSerialData(HySGeoDim2MeshSerialData csOrgData)
        {
            CopyData(csOrgData);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ（Ｋｍｌ用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim2MeshSerialData csData = new HySGeoDim2MeshSerialData(csKmlFile); </para>
        /// </example>
        /// <param name="csKmlFile">ファイル名（フルパス）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim2MeshSerialData(HySString csKmlFile)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            return m_csCellDataKind.m_lDim;
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();
        ///    csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellDataKind; }
        */

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTimeRecordIF 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return new HySGeoDim2MeshData(this.m_lMeshKind, this.m_lLonDim, this.m_lLatDim, m_csCellDataKind.m_lDim, false);
        }  
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgTimeSeriesData) </para>
        /// </example>
        /// <param name="csOrgTimeSeriesData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySTimeSeriesBase csOrgTimeSeriesData)
        {
            
            HySGeoDim2MeshSerialData csOrgData = csOrgTimeSeriesData as HySGeoDim2MeshSerialData;
            HySGeoDim2MeshData csRecordData = null;
            if (csOrgData != null)
            {
                // 共通情報のコピー
                CopyCommonInfo(csOrgData);

                // 時系列情報のコピー
                m_csLastTime = csOrgData.m_csLastTime.Clone();
                this.m_csDataList.Clear();

                long lDataNum = csOrgData.GetCount();
                csOrgData.SetCursorFirst();
                for (long lLp = 0; lLp < lDataNum; lLp++)
                {
                    csRecordData = csOrgData.GetCursorData() as HySGeoDim2MeshData;
                    this.AddData(new HySGeoDim2MeshData(csRecordData));
                    csOrgData.MoveCursorNext();
                }
                
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>共通情報をコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyCommonInfo(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyCommonInfo(HySGeoMeshSerial csOrgData)
        {
            base.CopyCommonInfo(csOrgData);

            HySGeoDim2MeshSerialData csOrgD2Data = csOrgData as HySGeoDim2MeshSerialData;
            m_dDispAltitude = csOrgD2Data.m_dDispAltitude;
        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshSerial csMeshSerial = CreateInstance() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySGeoMeshSerial 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分自身の同一の型のインスタンスを生成する</para>
        /// </remarks>
        protected override HySGeoMeshSerial CreateInstance()
        {
            // 自身と同じ形のインスタンスを生成する
            return new HySGeoDim2MeshSerialData(m_lMeshKind, m_lLonDim, m_lLatDim, m_csCellDataKind.m_lDim);
        }


// ver1.1 start of 追加
                
        /// <summary><para>method outline:</para>
        /// <para>ヘッダーデータ読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = CSVHeaderWrite(csFile) </para>
        /// </example>
        /// <param name="csFile">CSVファイル</param>
        /// <returns> long =0:正常、=-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long CSVHeaderWrite(HySFile csFile)
        {
            long lRtn = 0;

            csFile.WriteText("HySGeoDim2MeshSerialData,Ver1.0");  // ヘッダー
            csFile.WriteText("データタイプ,double");  // ヘッダー
            String sWString = "配列数,";
            sWString += this.GetLonDimension().ToString() + ",×," + this.GetLatDimension().ToString();
            csFile.WriteText(sWString);
            double dSWLat=0.0;double dSWLon=0.0;double dNELat=0.0;double dNELon=0.0;
            this.GetLocation(ref dSWLat, ref dSWLon, ref dNELat, ref dNELon);
            sWString = "SW位置（経度＿緯度）（度）," + dSWLon.ToString() + "," + dSWLat.ToString();
            csFile.WriteText(sWString);
            sWString = "NE位置（経度＿緯度）（度）," + dNELon.ToString() + "," + dNELat.ToString();
            csFile.WriteText(sWString);
            double dUpAlt = 0.0; double dLwAlt = 0.0;
            this.GetAltitude(ref dUpAlt, ref dLwAlt);
            sWString = "高度（ｍ）," + dUpAlt.ToString() + "," + dLwAlt.ToString();
            csFile.WriteText(sWString);
            HySDataCharacteristicInCell csCharaDt = this.GetCellDataCharacteristic();
            sWString = "セル内データ配列," + csCharaDt.m_lDim.ToString();
            csFile.WriteText(sWString);
            for (long lLp = 0; lLp < csCharaDt.m_lDim; lLp++)
            {
                sWString = "セル内データ," + csCharaDt.m_csLabel[lLp] + "," + csCharaDt.m_csDataKind[lLp].ToString()+","+csCharaDt.m_csUnit[lLp];
                csFile.WriteText(sWString);
            }
            csFile.WriteText("Time, Data");
            return lRtn;
        }
               
        /// <summary><para>method outline:</para>
        /// <para>１ヘッダーデータ読み込み新しいデータを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim2MeshSerialData csRtnObj= CSVHeaderRead(csFile) </para>
        /// </example>
        /// <param name="csFile">CSVファイル</param>
        /// <returns> HySGeoDim2MeshSerialData 生成インスタンス： =null:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySGeoDim2MeshSerialData CSVHeaderRead(HySFile csFile)
        {
            HySGeoDim2MeshSerialData csRtnObj = null;

            HySString sOut = new HySString();
            string[] sInWk;
            // 表の種別の読み込み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (sInWk[0].Equals("HySGeoDim2MeshSerialData") == false)
                    { return csRtnObj; }
                    // バージョンを調べるのは将来
                }
                catch
                {
                    return csRtnObj;
                }
            }
            // データのタイプの読み込み
            HySGeoMesh.MESH_DATA_KIND lMeshKind = HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD;
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    if (sInWk[1].Equals("double") == true)
                    {
                        lMeshKind = HySGeoMesh.MESH_DATA_KIND.DOUBLE_DATA_HOLD;
                    }
                    else
                    {
                        // 他の形式に対応するのは将来
                    }
                }
                catch
                {
                    return csRtnObj;
                }
            }
            // 配列数読み込み
            long lLonDim = 0; long lLatDim = 0;
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    lLonDim = Convert.ToInt32(sInWk[1]);
                    lLatDim = Convert.ToInt32(sInWk[3]);
                }
                catch
                {
                    return csRtnObj;
                }
            }
            // 緯度経度読み込み
            double dSWLat = 0.0; double dSWLon = 0.0; double dNELat = 0.0; double dNELon = 0.0;
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    dSWLon = Convert.ToDouble(sInWk[1]);
                    dSWLat = Convert.ToDouble(sInWk[2]);
                }
                catch
                {
                    return csRtnObj;
                }
            }
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    dNELon = Convert.ToDouble(sInWk[1]);
                    dNELat = Convert.ToDouble(sInWk[2]);
                }
                catch
                {
                    return csRtnObj;
                }
            }
            //this.SetLocation(dSWLat, dSWLon, dNELat, dNELon);

            // 高度読み込み
            double dUpAlt = 0.0; double dLwAlt = 0.0;
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    dUpAlt = Convert.ToDouble(sInWk[1]);
                    dLwAlt = Convert.ToDouble(sInWk[2]);
                }
                catch
                {
                    return csRtnObj;
                }
            }
            //this.SetAltitude(dUpAlt, dLwAlt);

            // セル内のデータ配列読み込み
            long lDtDm = 0;
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                try
                {
                    // ','区切りで展開する
                    sInWk = sOut.ToString().Split(',');
                    lDtDm = Convert.ToInt32(sInWk[1]);
                }
                catch
                {
                    return csRtnObj;
                }
            }
            // セル内のデータ読み込み
            HySDataCharacteristicInCell csDtCr = new HySDataCharacteristicInCell(lDtDm);
            for (int iLp = 0; iLp < lDtDm; iLp++)
            {
                if (csFile.ReadText(ref sOut) > 0)
                {   // データ有り
                    try
                    {
                        // ','区切りで展開する
                        sInWk = sOut.ToString().Split(',');
                        csDtCr.m_csLabel[iLp] = sInWk[1];
                        csDtCr.m_csDataKind[iLp] = new HySObjectKind(sInWk[2]);
                        csDtCr.m_csUnit[iLp] = sInWk[3];
                    }
                    catch
                    {
                        return csRtnObj;
                    }
                }
            }
            //this.SetCellDataCharacteristic(csDtCr);

            // 最後の空読み
            if (csFile.ReadText(ref sOut) > 0)
            {   // データ有り
                // Do Nothing
            }

            csRtnObj = new HySGeoDim2MeshSerialData(lMeshKind, lLonDim, lLatDim, lDtDm);
            csRtnObj.SetLocation(dSWLat, dSWLon, dNELat, dNELon);
            csRtnObj.SetAltitude(dUpAlt, dLwAlt);
            csRtnObj.SetCellDataCharacteristic(csDtCr);
            return csRtnObj;
        }
            
        /// <summary><para>method outline:</para>
        /// <para>１行分のデータ読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double[] csDt= ReadCSVFile() </para>
        /// </example>
        /// <param name="csFile">CSVファイル</param>
        /// <param name="csAppendData">追加データ</param>
        /// <returns> long =1:データ有り、 =0:データ無し、=-1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long CSVDataAppend(HySFile csFile,HySGeoDim2MeshData csAppendData)
        {
            long lRtn = 0;
            csAppendData.CSVDataAppendWrite(csFile, this.GetCellDataCharacteristic());
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadCSVFile(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常(読み込んだレコード数), -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long ReadCSVFile(HySFile csFile)
        {
            long lRtn = -1;    // ヘッダーの空読み
            if (HySGeoDim2MeshSerialData.CSVHeaderRead(csFile) == null)
            {
                return lRtn;
            }
            
            // データを読む
            lRtn = this.ReadCSVFileDataOnly(csFile);

            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルのデータ部分だけを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadCSVFileDataOnly(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常(読み込んだレコード数), -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long ReadCSVFileDataOnly(HySFile csFile)
        {
            long lRtn = 0;

            m_csDataList.Clear();
            m_csLastTime = HySTime.DEFAULT_TIME.Clone();

            HySDataCharacteristicInCell csCellChara = this.GetCellDataCharacteristic();

            // データを追加してゆく
            HySGeoDim2MeshData csAddRecord = null;
            for (; ; )
            {
                csAddRecord = this.CreateNewRecord() as HySGeoDim2MeshData;
                if (csAddRecord.CSVRecordDataRead(csFile, csCellChara) < 1)
                {
                    break;
                }
                this.AddData(csAddRecord);
                lRtn += 1;
            }

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＣＳＶ形式ファイルを読み込む</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadCSVFile(csFile) </para>
        /// </example>
        /// <param name="csFile">入力ファイル</param>
        /// <returns>long  >0:=正常(読み込んだレコード数), -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long WriteCSVFile(HySFile csFile)
        {
            long lRtn = this.CSVHeaderWrite(csFile);
            if (lRtn < 0)
            {
                return lRtn;
            }
            long lDtNum = this.GetCount();
            m_csDataList.SetCursorFirst();
            HySGeoDim2MeshData csMshDt = null;
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                csMshDt = m_csDataList.GetCursorData() as HySGeoDim2MeshData;
                if (csMshDt != null)
                {
                    if (this.CSVDataAppend(csFile, csMshDt) < 0)
                    {
                        lRtn = -1;
                        break;
                    }
                }
                m_csDataList.MoveCursorNext();
            }
            return lRtn;
        }
// ver1.1 end   of 追加


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
