﻿// <summary>ソースコード：ＨＹＳＳＯＰ３次元地理メッシュ情報　時系列 データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>３次元地理メッシュ情報時系列 データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>３次元地理メッシュ情報（HySGeoDim3MeshData）を時系列情報として保持できる</para>
    /// <para>Remarks</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySGeoDim3MeshSerialData : HySGeoMeshSerial, HySVersionManagement
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> 使用禁止 </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoMesh 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> 使用禁止</para>
        /// </remarks>
        private HySGeoDim3MeshSerialData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshSerial csData = new HySGeoDim3MeshSerialData(lKind, lLonDim, lLatDim, lAltDim, lCellDataDim); </para>
        /// </example>
        /// <param name="lKind">保持するデータの形</param>
        /// <param name="lLonDim">経度方向のメッシュ分割数</param>
        /// <param name="lLatDim">緯度方向のメッシュ分割数</param>
        /// <param name="lAltDim">高度方向のメッシュ分割数</param>
        /// <param name="lCellDataDim">１メッシュ内のデータ配列数</param>
        /// <returns> HySGeoDim3MeshSerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim3MeshSerialData(HySGeoMesh.MESH_DATA_KIND lKind, long lLonDim, long lLatDim, long lAltDim, long lCellDataDim)
            : base(lKind, lLonDim, lLatDim, lAltDim, lCellDataDim)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshSerial csData = new HySGeoDim3MeshSerialData(csMeshData); </para>
        /// </example>
        /// <param name="csMeshData">地理メッシュ情報</param>
        /// <returns> HySGeoDim3MeshSerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim3MeshSerialData(HySGeoDim3MeshData csMeshData)
            : base((HySGeoMesh)csMeshData)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim3MeshSerialData csData = new HySGeoDim3MeshSerialData(csOrgData); </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> HySGeoDim3MeshSerialData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim3MeshSerialData(HySGeoDim3MeshSerialData csOrgData)
        {
            CopyData(csOrgData);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ（Ｋｍｌ用）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoDim3MeshSerialData csData = new HySGeoDim3MeshSerialData(csKmlFile); </para>
        /// </example>
        /// <param name="csKmlFile">ファイル名（フルパス）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoDim3MeshSerialData(HySString csKmlFile)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            return m_csCellDataKind.m_lDim;
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();
        ///    csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellDataKind; }
        */

        /// <summary><para>method outline:</para>
        /// <para>新しいレコードを生成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTimeRecordIF csNewRecord = CreateNewRecord( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTimeRecordIF 新レコード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>時系列として保持すべき情報を新規に生成する</para>
        /// </remarks>
        public override HySTimeRecordIF CreateNewRecord()
        {
            return new HySGeoDim3MeshData(this.m_lMeshKind, this.m_lLonDim, this.m_lLatDim, this.m_lAltDim, m_csCellDataKind.m_lDim, false);
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CopyData(csOrgTimeSeriesData) </para>
        /// </example>
        /// <param name="csOrgTimeSeriesData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void CopyData(HySTimeSeriesBase csOrgTimeSeriesData)
        {
            HySGeoDim3MeshSerialData csOrgData = csOrgTimeSeriesData as HySGeoDim3MeshSerialData;
            HySGeoDim3MeshData csRecordData = null;
            if (csOrgData != null)
            {
                // 共通情報のコピー
                CopyCommonInfo(csOrgData);

                // 時系列情報のコピー
                m_csLastTime = csOrgData.m_csLastTime.Clone();
                this.m_csDataList.Clear();

                long lDataNum = csOrgData.GetCount();
                csOrgData.SetCursorFirst();
                for (long lLp = 0; lLp < lDataNum; lLp++)
                {
                    csRecordData = csOrgData.GetCursorData() as HySGeoDim3MeshData;
                    this.AddData(new HySGeoDim3MeshData(csRecordData));
                    csOrgData.MoveCursorNext();
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshSerial csMeshSerial = CreateInstance() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySGeoMeshSerial 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自分自身の同一の型のインスタンスを生成する</para>
        /// </remarks>
        protected override HySGeoMeshSerial CreateInstance()
        {
            // 自身と同じ形のインスタンスを生成する
            return new HySGeoDim3MeshSerialData(m_lMeshKind, m_lLonDim, m_lLatDim, m_lAltDim, m_csCellDataKind.m_lDim);
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================

        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
