﻿// <summary>ソースコード：水理／水門関係の印　地図上表示情報 データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>水理／水門関係の印　地図上表示情報 データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>水理／水門関係の印を地図上に表示する為の情報</para>
    /// <para>河川単位に表示／非表示の設定を行う</para>
    /// </remarks>
    [Serializable]
    public class HySGeoHydrlgclMarkData : HySDataRoot, HySVersionManagement
    {
        // ======================================
        // GIS 水理／水文関連オブジェクトの種別定義
        // ======================================
        /// <summary> 河心線 </summary>
        static public readonly HySObjectKind KIND_RIVER_LINE = new HySObjectKind("GIS_KIND_RiverLine");
        /// <summary> キロポスト </summary>
        static public readonly HySObjectKind KIND_KILO_POST = new HySObjectKind("GIS_KIND_KiloPost");
        /// <summary> 横断面測量地点 </summary>
        static public readonly HySObjectKind KIND_CROSS_SECTION = new HySObjectKind("GIS_KIND_CrossSection");
        /// <summary> ＨＱ観測点 </summary>
        static public readonly HySObjectKind KIND_HQ_OBSERVATION_POINT = new HySObjectKind("GIS_KIND_HQ_Observation");
        /// <summary> 水理／水文関係観測地点 </summary>
        static public readonly HySObjectKind KIND_OBSERVATION_POINT = new HySObjectKind("GIS_KIND_ObservationPoint");
        /// <summary> 水理／水文関係計算地点 </summary>
        static public readonly HySObjectKind KIND_CALCULATION_POINT = new HySObjectKind("GIS_KIND_CalculationPoint");

        /// <summary> オブジェクトの種別 　（HySGeoHydrlgclMarkDataに定義）</summary>
        protected HySObjectKind m_csObjKind=null;

        /// <summary> 河川を識別する為のＩＤ </summary>
        protected HySID m_csRiverID=null;

        /// <summary>水理／水文関連オブジェクトの図形データリスト:例）HQ観測点ならばシンボル、河心線ならばポリライン等、横断面なら線分等</summary>
        protected HySDataLinkedList m_csGeometryList = new HySDataLinkedList();

        /// <summary>選択した個々の印のIDリスト</summary>
        protected HySDataLinkedList m_csSelectedObjIDList = new HySDataLinkedList();

        /// <summary>選択オブジェクトの通常／強調表示定義</summary>
        public enum HighlightMode
        {
            /// <summary>通常</summary>
            Normal = 1,
            /// <summary>強調</summary>
            Highlight
        }
        /// <summary>選択オブジェクトの通常／強調表示区分</summary>
        protected HighlightMode m_eHighlight = HighlightMode.Highlight;

        /// <summary>補足情報 (必要時に使用する) </summary>
        protected HySDataRoot m_csSuppData=null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoHydrlgclMarkData csMarkData = new HySGeoHydrlgclMarkData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoHydrlgclMarkData</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySGeoHydrlgclMarkData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクトの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetObjectKind(csObjKind)</para>
        /// </example>
        /// <param name="csObjKind">オブジェクトの種別（実際のオブジェクト種別はHySGeoHydrlgclMarkDataに定義）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetObjectKind(HySObjectKind csObjKind)
        { m_csObjKind = csObjKind; }
        /// <summary><para>method outline:</para>
        /// <para>オブジェクトの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySObjectKind eObjKind = GetObjectKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>オブジェクトの種別（実際のオブジェクト種別はHySGeoHydrlgclMarkDataに定義）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetObjectKind()
        { return m_csObjKind; }

        /// <summary><para>method outline:</para>
        /// <para>河川識別ＩＤ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRiverID(csObjID)</para>
        /// </example>
        /// <param name="csObjID">河川識別ＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRiverID(HySID csObjID)
        { m_csRiverID = csObjID; }
        /// <summary><para>method outline:</para>
        /// <para>河川識別ＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySID csID = GetRiverID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>河川識別ＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetRiverID()
        { return m_csRiverID; }

        /// <summary><para>method outline:</para>
        /// <para>補足情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetSuppData(csSuppData)</para>
        /// </example>
        /// <param name="csSuppData">補足情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetSuppData(HySDataRoot csSuppData)
        { m_csSuppData = csSuppData; }
        /// <summary><para>method outline:</para>
        /// <para>補足情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDataRoot csDt = GetSuppData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>補足情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot GetSuppData()
        { return m_csSuppData; }

        /// <summary><para>method outline:</para>
        /// <para>強調表示モード設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetHighlightMode(eHighlight)</para>
        /// </example>
        /// <param name="eHighlight">強調表示モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetHighlightMode(HighlightMode eHighlight)
        { m_eHighlight = eHighlight; }
        /// <summary><para>method outline:</para>
        /// <para>強調表示モード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HighlightMode eMode = GetHighlightMode()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>強調表示モード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HighlightMode GetHighlightMode()
        { return m_eHighlight; }

        /// <summary><para>method outline:</para>
        /// <para>選択オブジェクトの解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ClearSelectedObjectID()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearSelectedObjectID()
        {
            m_csSelectedObjIDList.Clear();
        }

        // =======================
        // 残りの　Getter,Setter メソッドは後で作成する
        /// <summary><para>method outline:</para>
        /// <para>図形データの追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddGeometry( csGeometry ) </para>
        /// </example>
        /// <param name="csGeometry">図形データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddGeometry(HySGeometry csGeometry)
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>図形データの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetGeometry(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>図形データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeometry GetGeometry()
        {
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>選択した個々の印のIDの追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddSelectedObjID( csSelectedObjID ) </para>
        /// </example>
        /// <param name="csSelectedObjID">ID</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddSelectedObjID(HySID csSelectedObjID)
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>選択した個々の印のIDの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetSelectedObjID(  ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetSelectedObjID()
        {
            return null;
        }

        /// <summary><para>method outline:</para>
        /// <para>図形データのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearWaterLevelData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearGeometry()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>選択した個々の印のIDのクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ClearWaterLevelData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ClearSelectedObjID()
        {

        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
