﻿// <summary>ソースコード：ＧＩＳ－表示用　凡例情報<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ－表示用　凡例情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2010/12/22][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    [Serializable]
    public class HySGeoLegendInf : HySDataRoot, HySVersionManagement
    {
        /// <summary>凡例内レコードのリスト</summary>
        protected HySDataLinkedList m_csLabelList = new HySDataLinkedList();
        /// <summary>透明度：０～２５５、 ０の時完全透明、２５５の時完全不透明</summary>
        protected short m_sAlpha = 120;
        /// <summary>２次元メッシュ表示モード</summary>
        protected G2DMeshDispMode m_lG2DMeshDispMode = G2DMeshDispMode.clampToGround;
        /// <summary>表示時の高さ方向拡大率</summary>
        protected double m_dAltMagnitude = 1.0;
        /// <summary>データ種別 </summary>
        protected HySObjectKind m_csDataKind = new HySObjectKind();
        /// <summary>単位（表示用）</summary>
        public String m_csUnit = null;
        /// <summary>ラベル（表示用）</summary>
        public String m_csLabel = null;

        /// <summary>２次元メッシュ表示モード定義</summary>
        public enum G2DMeshDispMode
        {
            /// <summary>地面張り付きモード</summary>
            clampToGround = 0,
            /// <summary>地面からの高さで表すモード </summary>
            relativeToGround,
            /// <summary>海抜からの高さで表すモード</summary>
            absolute
        }


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoLegendInf() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoLegendInf()
        {
            this.SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例内レコード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lLblCnt = GetRecordCount() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>long  ラベル数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetRecordCount()
        { return m_csLabelList.GetCount(); }

        /// <summary><para>method outline:</para>
        /// <para>凡例１レコード分の情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AddDispInf(csLabel) </para>
        /// </example>
        /// <param name="csLabel">凡例１レコード分の情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AddDispInf(HySGeoLegendRecord csLabel)
        {
            m_csLabelList.AddLast(csLabel);
        }
        /// <summary><para>method outline:</para>
        /// <para>凡例１レコード分の情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDispInf(dVal) </para>
        /// </example>
        /// <param name="dVal">表示する値</param>
        /// <returns>HySGeoLegendRecord 表示に必要な凡例１レコード分の情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoLegendRecord GetDispInf(double dVal)
        {
            HySGeoLegendRecord csRtn = null;
            HySGeoLegendRecord csWork = null;
            long lNum = m_csLabelList.GetCount();
            m_csLabelList.SetCursorFirst();
            for (long lLP = 0; lLP < lNum; lLP++)
            {
                csWork = m_csLabelList.GetCursorData() as HySGeoLegendRecord;
                if (csWork.Inside(dVal) == true)
                {
                    csRtn = csWork;
                    break;
                }
                m_csLabelList.MoveCursorNext();
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>凡例１レコード分の情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDispInf(dVal,uiR,uiG,uiB) </para>
        /// </example>
        /// <param name="dVal">表示する値</param>
        /// <param name="uiR">表示色：R値</param>
        /// <param name="uiG">表示色：G値</param>
        /// <param name="uiB">表示色：B値</param>
        /// <returns>HySGeoLegendRecord 表示に必要な凡例１レコード分の情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoLegendRecord GetDispInf(double dVal, ref short uiR, ref short uiG, ref short uiB)
        {
            HySGeoLegendRecord csRtn = null;
            HySGeoLegendRecord csWork = null;
            long lNum = m_csLabelList.GetCount();
            m_csLabelList.SetCursorFirst();
            for (long lLP = 0; lLP < lNum; lLP++)
            {
                csWork = m_csLabelList.GetCursorData() as HySGeoLegendRecord;
                if (csWork.Inside(dVal) == true)
                {
                    csRtn = csWork;
                    uiR = csRtn.m_uiR;
                    uiG = csRtn.m_uiG;
                    uiB = csRtn.m_uiB;
                    break;
                }
                m_csLabelList.MoveCursorNext();
            }
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>凡例１レコード分の情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDispInf(lOrdr) </para>
        /// </example>
        /// <param name="lOrdr">ラベルの順番</param>
        /// <returns>HySGeoLegendRecord 表示に必要な凡例１レコード分の情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoLegendRecord GetDispInf(long lOrdr)
        {
            return m_csLabelList.GetData(lOrdr) as HySGeoLegendRecord;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示透明度設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAlpha(sAlpha) </para>
        /// </example>
        /// <param name="sAlpha">表示透明度</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAlpha(short sAlpha)
        { m_sAlpha = sAlpha; }
        /// <summary><para>method outline:</para>
        /// <para>表示透明度取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> short sAlpha = GetAlpha() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>short  表示透明度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public short GetAlpha()
        { return m_sAlpha; }

        /// <summary><para>method outline:</para>
        /// <para>表示モード設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetG2DMeshDispMode(lMode) </para>
        /// </example>
        /// <param name="lMode">表示モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetG2DMeshDispMode(HySGeoLegendInf.G2DMeshDispMode lMode)
        { m_lG2DMeshDispMode = lMode; }
        /// <summary><para>method outline:</para>
        /// <para>表示モード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoLegendInf.G2DMeshDispMode lMode = GetG2DMeshDispMode() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>HySGeoLegendInf.G2DMeshDispMode  表示モード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoLegendInf.G2DMeshDispMode GetG2DMeshDispMode()
        { return m_lG2DMeshDispMode; }

        /// <summary><para>method outline:</para>
        /// <para>高さ方向表示拡大率設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAltMagnitude(dMgn) </para>
        /// </example>
        /// <param name="dMgn">高さ方向表示用拡大率</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAltMagnitude(double dMgn)
        { m_dAltMagnitude = dMgn; }
        /// <summary><para>method outline:</para>
        /// <para>高さ方向表示拡大率取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double dMg = GetAltMagnitude() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>double  高さ方向表示用拡大率</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetAltMagnitude()
        { return m_dAltMagnitude; }

        /// <summary><para>method outline:</para>
        /// <para>データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataKind(csDataKind) </para>
        /// </example>
        /// <param name="csDataKind">データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataKind(HySObjectKind csDataKind)
        { m_csDataKind = csDataKind; }
        /// <summary><para>method outline:</para>
        /// <para>データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csKind = GetDataKind() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>HySObjectKind  データの種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataKind()
        { return m_csDataKind; }

        /// <summary><para>method outline:</para>
        /// <para>XMLファイル出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = WriteXMLFile( sFileName )</para>
        /// </example>
        /// <param name="sFileName">XMLファイル名</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool WriteXMLFile(string sFileName)
        {
            bool bRtn = false;
            HySXmlWriter csXmlWriter = new HySXmlWriter(sFileName);
            if (csXmlWriter != null)
            {
                HySXmlNode csRootNode = csXmlWriter.CreateRoot(HySGeoLegendInf.xml_Legend);
                csRootNode.SetAttribute(HySGeoLegendInf.xml_Alpha, m_sAlpha.ToString());
                csRootNode.SetAttribute(HySGeoLegendInf.xml_G2DMeshDispMode, m_lG2DMeshDispMode.ToString());
                csRootNode.SetAttribute(HySGeoLegendInf.xml_AltMagnitude, m_dAltMagnitude.ToString());
                csRootNode.SetAttribute(HySGeoLegendInf.xml_DataKind, m_csDataKind.ToString());

                long lNum = this.GetRecordCount();
                HySGeoLegendRecord csRecord;
                HySXmlNode csNode;
                for (long lLP = 0; lLP < lNum; lLP++)
                {
                    csRecord = this.GetDispInf(lLP);
                    csNode = csRecord.WriteXML(ref csXmlWriter);
                    csRootNode.AppendChild(csNode);
                }
                csXmlWriter.Save();

                bRtn = true;
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>XMLファイル入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadXMLFile( sFileName )</para>
        /// </example>
        /// <param name="sFileName">XMLファイル名</param>
        /// <returns>==true:正常、==false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool ReadXMLFile(string sFileName)
        {
            bool bRtn = false;
            HySFile csFile = new HySFile(sFileName);
            if (csFile.Exist() == true)
            {
                m_csLabelList.Clear();

                HySXmlReader csXmlReader = new HySXmlReader(sFileName);
                HySXmlNode csRootNode = csXmlReader.GetRootNode();
                if (csRootNode != null)
                {
                    string sWork = csXmlReader.GetAttribute(HySGeoLegendInf.xml_Alpha);
                    m_sAlpha = short.Parse(sWork);
                    sWork = csXmlReader.GetAttribute(HySGeoLegendInf.xml_G2DMeshDispMode);
                    if (sWork == "clampToGround") { m_lG2DMeshDispMode = G2DMeshDispMode.clampToGround; }
                    else if (sWork == "relativeToGround") { m_lG2DMeshDispMode = G2DMeshDispMode.relativeToGround; }
                    else { m_lG2DMeshDispMode = G2DMeshDispMode.absolute; }
                    sWork = csXmlReader.GetAttribute(HySGeoLegendInf.xml_AltMagnitude);
                    m_dAltMagnitude = double.Parse(sWork);
                    sWork = csXmlReader.GetAttribute(HySGeoLegendInf.xml_DataKind);
                    m_csDataKind = new HySObjectKind(sWork);

                    HySXmlNode csXmlRecordNode;
                    HySXmlNodeList csXmlRecordList = csRootNode.GetChildNodeListByTagName(HySGeoLegendRecord.xml_Rcd);

                    long lRcrdNum = csXmlRecordList.GetCount();
                    for (long lLp = 0; lLp < lRcrdNum; lLp++)
                    {
                        csXmlRecordNode = csXmlRecordList.GetNode(lLp);
                        // ノード読み出し

                        HySGeoLegendRecord csRcrd = new HySGeoLegendRecord(128, 128, 128);
                        csRcrd.ReadXML(csXmlRecordNode);
                        this.AddDispInf(csRcrd);
                    }
                    bRtn = true;
                }
            }
            return bRtn;
        }

        /// <summary>XMLラベル:ルート</summary>
        static string xml_Legend = "Legend";
        /// <summary>XMLラベル:透過率</summary>
        static string xml_Alpha = "Alpha";
        /// <summary>XMLラベル:２次元メッシュ表示モード</summary>
        static string xml_G2DMeshDispMode = "G2DMeshDispMode";
        /// <summary>XMLラベル:表示時の高さ方向拡大率</summary>
        static string xml_AltMagnitude = "AltMagnitude";
        /// <summary>XMLラベル:表示時の高さ方向拡大率</summary>
        static string xml_DataKind = "DataKind";

        /// <summary><para>class outline:</para>
        /// <para>凡例１レコード分の情報クラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2011/05/01][新規作成]</para>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        [Serializable]
        public class HySGeoLegendRecord : HySDataRoot, HySVersionManagement
        {
            /// <summary>ラベル</summary>
            internal string m_sLabel = "";
            /// <summary>表示色：R</summary>
            internal short m_uiR = 125;
            /// <summary>表示色：G</summary>
            internal short m_uiG = 125;
            /// <summary>表示色：B</summary>
            internal short m_uiB = 125;
            /// <summary>下限値：以上</summary>
            internal double m_dLowerLimit = -1.0E30;
            /// <summary>上限値：未満</summary>
            internal double m_dUpperLimit = +1.0E30;

            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySGeoLegendRecord(uiR,uiG,uiB) </para>
            /// </example>
            /// <param name="uiR">表示色：R値</param>
            /// <param name="uiG">表示色：G値</param>
            /// <param name="uiB">表示色：B値</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySGeoLegendRecord(short uiR, short uiG, short uiB)
            {
                this.SetNowVersion();
                m_uiR = uiR;
                m_uiG = uiG;
                m_uiB = uiB;
            }
            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> HySGeoLegendRecord(sLabel,uiR,uiG,uiB) </para>
            /// </example>
            /// <param name="sLabel">ラベル</param>
            /// <param name="uiR">表示色：R値</param>
            /// <param name="uiG">表示色：G値</param>
            /// <param name="uiB">表示色：B値</param>
            /// <returns>生成されたインスタンス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public HySGeoLegendRecord(string sLabel, short uiR, short uiG, short uiB)
            {
                this.SetNowVersion();
                m_sLabel = sLabel;
                m_uiR = uiR;
                m_uiG = uiG;
                m_uiB = uiB;
            }
            
            /// <summary><para>method outline:</para>
            /// <para>上下限値設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetLimit(dLowerLimit,dUpperLimit) </para>
            /// </example>
            /// <param name="dLowerLimit">下限値</param>
            /// <param name="dUpperLimit">上限値</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void SetLimit(double dLowerLimit, double dUpperLimit)
            {
                m_dLowerLimit = dLowerLimit;
                m_dUpperLimit = dUpperLimit;
                if (m_sLabel == "")
                {
                    m_sLabel = dLowerLimit.ToString() + "-" + dUpperLimit.ToString();
                }
            }

            /// <summary><para>method outline:</para>
            /// <para>引数で与えれられた値が、上下限値内にあるかを判断する</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> Inside(dVal) </para>
            /// </example>
            /// <param name="dVal">表示する値</param>
            /// <returns>bool true:範囲内、false:範囲外</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public bool Inside(double dVal)
            {
                bool bRtn = false;
                if (m_dLowerLimit <= dVal)
                {
                    if (m_dUpperLimit > dVal)
                    {
                        bRtn = true;
                    }
                }
                return bRtn;
            }
            /// <summary><para>method outline:</para>
            /// <para>表示情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> GetDispInf(sLabel,uiR,uiG,uiB) </para>
            /// </example>
            /// <param name="sLabel">ラベル</param>
            /// <param name="uiR">表示色：R値</param>
            /// <param name="uiG">表示色：G値</param>
            /// <param name="uiB">表示色：B値</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public void GetDispInf(ref string sLabel, ref short uiR, ref short uiG, ref short uiB)
            {
                sLabel = m_sLabel;
                uiR = m_uiR;
                uiG = m_uiG;
                uiB = m_uiB;
            }

            /// <summary><para>method outline:</para>
            /// <para>XML出力</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>HySXmlNode csNode = WriteXML( ref csXmlWriter )</para>
            /// </example>
            /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
            /// <returns>XMLノードクラス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            internal virtual HySXmlNode WriteXML(ref HySXmlWriter csXmlWriter)
            {
                HySXmlNode csRtnNode = HySXmlNode.CreateElement(HySGeoLegendRecord.xml_Rcd, csXmlWriter);
                csRtnNode.SetAttribute(HySGeoLegendRecord.xml_Lower, m_dLowerLimit.ToString());
                csRtnNode.SetAttribute(HySGeoLegendRecord.xml_Upper, m_dUpperLimit.ToString());
                csRtnNode.SetAttribute(HySGeoLegendRecord.xml_R, m_uiR.ToString());
                csRtnNode.SetAttribute(HySGeoLegendRecord.xml_G, m_uiG.ToString());
                csRtnNode.SetAttribute(HySGeoLegendRecord.xml_B, m_uiB.ToString());
                csRtnNode.SetAttribute(HySGeoLegendRecord.xml_Name, m_sLabel);
                return csRtnNode;
            }
            /// <summary><para>method outline:</para>
            /// <para>XML入力</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>bool bRtn = ReadXML( csXmlReader )</para>
            /// </example>
            /// <param name="csXmlReader">入力ＸＭＬ</param>
            /// <returns>==true:正常、==false:異常</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            internal virtual bool ReadXML(HySXmlNode csXmlReader)
            {
                bool bRtn = true;
                string sWork = csXmlReader.GetAttribute(HySGeoLegendRecord.xml_Name);
                m_sLabel = sWork;

                sWork = csXmlReader.GetAttribute(HySGeoLegendRecord.xml_R);
                m_uiR = short.Parse(sWork);
                sWork = csXmlReader.GetAttribute(HySGeoLegendRecord.xml_G);
                m_uiG = short.Parse(sWork);
                sWork = csXmlReader.GetAttribute(HySGeoLegendRecord.xml_B);
                m_uiB = short.Parse(sWork);
                sWork = csXmlReader.GetAttribute(HySGeoLegendRecord.xml_Lower);
                
                m_dLowerLimit = double.Parse(sWork);
                sWork = csXmlReader.GetAttribute(HySGeoLegendRecord.xml_Upper);
                m_dUpperLimit = double.Parse(sWork);

                return bRtn;
            }

            /// <summary>XMLラベル:レコード</summary>
            static internal string xml_Rcd = "rank";
            /// <summary>XMLラベル:名称</summary>
            static internal string xml_Name = "name";
            /// <summary>XMLラベル:R</summary>
            static internal string xml_R = "R";
            /// <summary>XMLラベル:G</summary>
            static internal string xml_G = "G";
            /// <summary>XMLラベル:B</summary>
            static internal string xml_B = "B";
            /// <summary>XMLラベル:下限</summary>
            static internal string xml_Lower = "lower";
            /// <summary>XMLラベル:上限</summary>
            static internal string xml_Upper = "upper";

            // ================================================
            //   バージョンアップ時の下位互換性を保つ為の処理
            // ================================================
            /// <summary>保存バージョン情報</summary>
            private string m_sDecodedVersion;
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sDecodedVersion = GetDecodedVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 保存バージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>メンバー変数に設定されているバージョン情報を返す</para>
            /// </remarks>
            public string GetDecodedVersion()
            {
                return m_sDecodedVersion;
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報取得</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> string sVersion = GetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>string 現在のバージョン情報</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public string GetNowVersion()
            {
                return "1.00";
            }
            /// <summary><para>method outline:</para>
            /// <para>バージョン情報設定</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> SetNowVersion()</para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>現在のバージョン情報をメンバー変数に設定する</para>
            /// </remarks>
            public void SetNowVersion()
            {
                m_sDecodedVersion = GetNowVersion();
            }
            /// <summary><para>method outline:</para>
            /// <para>復元後の整合性確保処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> PostDeserialize( ) </para>
            /// </example>
            /// <param name="">無し</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
            /// バージョンによって変数等追加がない場合には、実装の必要がない
            /// </para>
            /// </remarks>
            public virtual void PostDeserialize()
            {
                if (GetDecodedVersion() != GetNowVersion())
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            break;
                    }
                    SetNowVersion();
                }
            }
            /// <summary><para>method outline:</para>
            /// <para>逆シリアル化時追加処理</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
            /// </example>
            /// <param name="csObj">ダミー</param>
            /// <returns>無し</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>予約処理</para>
            /// </remarks>
            void IDeserializationCallback.OnDeserialization(Object csObj)
            {
                PostDeserialize();
            }
        }
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
