﻿// <summary>ソースコード：自由図形表示データクラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>自由図形表示データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>地図上に表示する自由図形情報を格納</para>
    /// <para>Remarks</para>
    /// <para>なし</para>
    /// </remarks>
    [Serializable]
    public class HySGeoMapFigureData : HySTimeRecordIF, HySVersionManagement
    {
        /// <summary>時刻</summary>
        protected HySTime m_csTime = HySTime.DEFAULT_TIME.Clone();
        /// <summary>幾何図形のリスト</summary>
        protected HySDataLinkedList m_csGeometryList = new HySDataLinkedList();

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMapFigureData csFigureData = new HySGeoMapFigureData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoMapFigureData</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoMapFigureData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>データ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = GetCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  データ数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetCount()
        {
            return m_csGeometryList.GetCount();
        }
        /// <summary><para>method outline:</para>
        /// <para>全データクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clear() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Clear()
        {
            m_csGeometryList.Clear();
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクト追加(リストの最初に追加される)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = AddFirst(csData) </para>
        /// </example>
        /// <param name="csData">オブジェクト</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddFirst(HySGeometry csData)
        {
            return m_csGeometryList.AddFirst(csData);
        }
        /// <summary><para>method outline:</para>
        /// <para>オブジェクト追加(リストの最後に追加される)</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCount = AddLast(csData) </para>
        /// </example>
        /// <param name="csData">オブジェクト</param>
        /// <returns>long  データの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long AddLast(HySGeometry csData)
        {
            return m_csGeometryList.AddLast(csData);
        }

        /// <summary><para>method outline:</para>
        /// <para>指定データ取り外し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeometry csData = RemoveData(csData) </para>
        /// </example>
        /// <param name="csData">指定データ</param>
        /// <returns>HySGeometry　取り外されたデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定のデータをリストから取り外す</para>
        /// <para>戻り値は　取り外したデータ</para>
        /// </remarks>
        public HySGeometry RemoveData(HySGeometry csData)
        {
            return m_csGeometryList.RemoveData(csData) as HySGeometry;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定した識別子を持つデータを取り外す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeometry csData = GetData(csID) </para>
        /// </example>
        /// <param name="csID">指定識別子</param>
        /// <returns>HySGeometry　取り外したデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeometry RemoveData(HySID csID)
        {
            HySGeometry csRtnDt = this.GetData(csID);
            if (csRtnDt != null)
            {
                csRtnDt = this.RemoveData(csRtnDt);
            }
            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を最初に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCursorFirst() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorFirst()
        {
            m_csGeometryList.SetCursorFirst();
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を最後に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCursorLast() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCursorLast()
        {
            m_csGeometryList.SetCursorLast();
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を次の位置に持ってくる</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoveCursorNext() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorNext()
        {
            m_csGeometryList.MoveCursorNext();
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置を一つ前に戻す</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MoveCursorPrev() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void MoveCursorPrev()
        {
            m_csGeometryList.MoveCursorPrev();
        }
        /// <summary><para>method outline:</para>
        /// <para>カーソル位置のデータを取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeometry csData = GetCursorData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>
        /// HySGeometry  データ
        /// カーソル位置不定の場合には　null が返る
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeometry GetCursorData()
        {
            return m_csGeometryList.GetCursorData() as HySGeometry;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定した識別子を持つデータ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeometry csData = GetData(csID) </para>
        /// </example>
        /// <param name="csID">指定識別子</param>
        /// <returns>HySGeometry　データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeometry GetData(HySID csID)
        {
            HySGeometry csRtnDt = null;
            HySGeometry csDt = null;
            long lDtNum = m_csGeometryList.GetCount();
            m_csGeometryList.SetCursorFirst();
            for (long lLp = 0; lLp < lDtNum; lLp++)
            {
                csDt = m_csGeometryList.GetCursorData() as HySGeometry;
                if (csDt != null)
                {
                    if (csDt.GetID().Equals(csID) == true)
                    {
                        csRtnDt = csDt;
                        break;
                    }
                }
                m_csGeometryList.MoveCursorNext();
            }
            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetTime(HySTime csTime)
        {
            m_csTime.SetTime(csTime);
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetLastTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime 時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTime GetLastTime()
        {
            return m_csTime;
        }

        /// <summary><para>method outline:</para>
        /// <para>日付時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool　判定結果</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date と同じ場合は true、そうでない場合は false</para>
        /// </remarks>
        public bool EqualTime(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Equals(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool　判定結果</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false </para>
        /// </remarks>
        public bool After(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.After(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool　判定結果</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻より前の場合は true、そうでない場合は false</para>
        /// </remarks>
        public bool Before(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csTime != null)
            {
                bRtn = m_csTime.Before(csTime);
            }
            return bRtn;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
