﻿// <summary>ソースコード：ＨＹＳＳＯＰ地理メッシュ情報 データ 基底抽象化クラス<</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
//using CommonMP.HYSSOP.CoreImpl.HSData.CommonData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>地理メッシュ情報 データ 基底抽象化クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>地理空間上に　メッシュ状の情報を保持できる（但し直交座標）</para>
    /// </remarks>
    [Serializable]
    public abstract class HySGeoMesh : HySTimeRecordIF, HySVersionManagement //HySGeometry, HySTimeRecordIF
    {
        /// <summary>配列データ本体  m_lMeshKind = DOUBLE_DATA_HOLD or BOTH_DATA_HOLD の場合に有効</summary>
        protected HySCellArray m_csCellArray = new HySD1CellArrayData(1, 1, false);

        //============　境界情報　================
        /// <summary>南西頂点緯度（度単位）</summary>
        protected double m_dSWLatitude;
        /// <summary>南西頂点経度度（度単位）</summary>
        protected double m_dSWLongitude;
        /// <summary>北東頂点緯度（度単位）</summary>
        protected double m_dNELatitude;
        /// <summary>北東頂点経度度（度単位）</summary>
        protected double m_dNELongitude;

        /// <summary>標高上限（m単位）</summary>
        protected double m_dUpperAltitude = 0.0;
        /// <summary>標高下限（m単位）</summary>
        protected double m_dLowerAltitude = 0.0;

        //============　保持データの種別　================
        /// <summary>メッシュデータの種別定義</summary>
        public enum MESH_DATA_KIND
        {
            /// <summary>単純doubleデータ保持型(double型データ配列で持つ)</summary>
            DOUBLE_DATA_HOLD = 1,
            /// <summary>パターン分類データ保持型(メッシュセルを各パターンに分類する)</summary>
            PATTARN_DATA_HOLD,
            /// <summary>両方のデータ保持型</summary>
            BOTH_DATA_HOLD
        }
        /// <summary>メッシュデータの種別</summary>
        protected MESH_DATA_KIND m_lMeshKind = MESH_DATA_KIND.DOUBLE_DATA_HOLD;

        //============　保持データ　================
        /// <summary>緯度方向分割数</summary>
        protected long m_lLatDim = 1;
        /// <summary>経度方向分割数</summary>
        protected long m_lLonDim = 1;
        /// <summary>高度方向分割数</summary>
        protected long m_lAltDim = 1;


        //============　パターン情報　================
        /// <summary>メッシュセルパターン数</summary>
        protected long m_lPatternNum = 0;
        /// <summary>メッシュセル表示パターン情報</summary>
        protected HySGeoMeshDispPattern[] m_csPatternInf = null;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csGeoMesh = new HySGeoMesh( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected HySGeoMesh()
        {
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMesh csGeoMesh = new HySGeoMesh(lKind, lLonDim, lLatDim, lAltDim) </para>
        /// </example>
        /// <param name="lKind">保持するデータの形</param>
        /// <param name="lLatDim">緯度方向のメッシュ分割数</param>
        /// <param name="lLonDim">経度方向のメッシュ分割数</param>
        /// <param name="lAltDim">高度方向のメッシュ分割数</param>
        /// <returns> HySGeoMesh 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para> 抽象化クラスであるため、派生側で　:base(lKind, lLonDim, lLatDim, lAltDim) として使用する </para>
        /// </remarks>
        public HySGeoMesh(MESH_DATA_KIND lKind, long lLonDim, long lLatDim, long lAltDim)
        {
            //m_lMeshKind = lKind;
            //m_lLatDim = lLatDim;
            //m_lLonDim = lLonDim;
            //m_lAltDim = lAltDim;

            Init(lKind, lLonDim, lLatDim, lAltDim);
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(lKind, lLatDim, lLonDim) </para>
        /// </example>
        /// <param name="lKind">保持するデータの形</param>
        /// <param name="lLonDim">経度方向のメッシュ分割数</param>
        /// <param name="lLatDim">緯度方向のメッシュ分割数</param>
        /// <param name="lAltDim">高度方向のメッシュ分割数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>コンストラクターから呼ばれる</para>
        /// </remarks>
        protected virtual void Init(MESH_DATA_KIND lKind, long lLonDim, long lLatDim, long lAltDim)
        {
            m_lMeshKind = lKind;
            m_lLatDim = lLatDim;
            m_lLonDim = lLonDim;
            m_lAltDim = lAltDim;
        }

        /// <summary><para>method outline:</para>
        /// <para>セル内データ配列数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetDataDimentionInCell() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long セル内データ配列数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetDataDimentionInCell()
        {
            return m_csCellArray.GetDataDimentionInCell();
        }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellDataCharacteristic(csCellChara) </para>
        /// </example>
        /// <param name="csCellChara">１セル内の各データの種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellDataCharacteristic(HySDataCharacteristicInCell csCellChara)
        { m_csCellArray.SetCellDataCharacteristic(csCellChara); }
        /// <summary><para>method outline:</para>
        /// <para>セル内データ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySDataCharacteristicInCell csKind = GetCellDataCharacteristic();
        ///    csKind.SetDataKind( lItemNo,  csLabel,  csDataKind,  csUnit) 等の処理
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataCharacteristicInCell セル内データ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataCharacteristicInCell GetCellDataCharacteristic()
        { return m_csCellArray.GetCellDataCharacteristic(); }

        /// <summary><para>method outline:</para>
        /// <para>メッシュデータ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MESH_DATA_KIND lKind = GetDataKind() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>MESH_DATA_KIND メッシュデータ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual MESH_DATA_KIND GetDataMeshKind()
        {
            return m_lMeshKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>緯度方向のメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetLatDimension() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 緯度方向のメッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetLatDimension()
        {
            return m_lLatDim;
        }
        /// <summary><para>method outline:</para>
        /// <para>経度方向のメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetLonDimension() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 経度方向のメッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetLonDimension()
        {
            return m_lLonDim;
        }
        /// <summary><para>method outline:</para>
        /// <para>高度方向のメッシュ分割数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lDim = GetAltDimension() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 高度方向のメッシュ分割数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetAltDimension()
        {
            return m_lAltDim;
        }

        /// <summary><para>method outline:</para>
        /// <para>地理的位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLocation(dSWLat, dSWLon, dNELat, dNELon) </para>
        /// </example>
        /// <param name="dSWLat">南西頂点緯度（度単位）</param>
        /// <param name="dSWLon">南西頂点経度（度単位）</param>
        /// <param name="dNELat">北東頂点緯度（度単位）</param>
        /// <param name="dNELon">北東頂点経度（度単位）</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetLocation(double dSWLat, double dSWLon, double dNELat, double dNELon)
        {
            m_dSWLatitude = dSWLat;
            m_dSWLongitude = dSWLon;
            m_dNELatitude = dNELat;
            m_dNELongitude = dNELon;
        }
        /// <summary><para>method outline:</para>
        /// <para>地理的位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetLocation(ref dSWLat,ref dSWLon,ref dNELat,ref dNELon) </para>
        /// </example>
        /// <param name="dSWLat">南西頂点緯度（度単位）</param>
        /// <param name="dSWLon">南西頂点経度（度単位）</param>
        /// <param name="dNELat">北東頂点緯度（度単位）</param>
        /// <param name="dNELon">北東頂点経度（度単位）</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetLocation(ref double dSWLat, ref double dSWLon, ref double dNELat, ref double dNELon)
        {
            dSWLat = m_dSWLatitude;
            dSWLon = m_dSWLongitude;
            dNELat = m_dNELatitude;
            dNELon = m_dNELongitude;
        }
        /// <summary><para>method outline:</para>
        /// <para>高度位置設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAltitude(dUpAlt, dLwAlt) </para>
        /// </example>
        /// <param name="dUpAlt">上限高度（ｍ単位）</param>
        /// <param name="dLwAlt">下限高度（ｍ単位）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetAltitude(double dUpAlt, double dLwAlt)
        {
            m_dUpperAltitude = dUpAlt;
            m_dLowerAltitude = dLwAlt;
        }
        /// <summary><para>method outline:</para>
        /// <para>高度位置取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HGetAltitude(ref dUpAlt, ref dLwAlt) </para>
        /// </example>
        /// <param name="dUpAlt">上限高度（ｍ単位）</param>
        /// <param name="dLwAlt">下限高度（ｍ単位）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetAltitude(ref double dUpAlt, ref double dLwAlt)
        {
            dUpAlt = m_dUpperAltitude;
            dLwAlt = m_dLowerAltitude;
        }

        /// <summary><para>method outline:</para>
        /// <para>表示パターン数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPatternNumber(lPatternNum) </para>
        /// </example>
        /// <param name="lPatternNum">表示パターン数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetPatternNumber(long lPatternNum )
        {
            m_lPatternNum = lPatternNum;
            m_csPatternInf = new HySGeoMeshDispPattern[lPatternNum];
            for (long lLp = 0; lLp < lPatternNum; lLp++)
            {
                m_csPatternInf[lLp] = new HySGeoMeshDispPattern("");
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>表示パターン数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lPtn = GetPatternNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long 表示パターン数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetPatternNumber()
        {
            return m_lPatternNum;
        }
        /// <summary><para>method outline:</para>
        /// <para>パターン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPatternNumber(lOrderNo, csPatternInf) </para>
        /// </example>
        /// <param name="lOrderNo">パターン位置(０相対)</param>
        /// <param name="csPatternInf">パターン情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetPattern(long lOrderNo, HySGeoMeshDispPattern csPatternInf)
        {
            if (lOrderNo >= 0 && lOrderNo < m_lPatternNum)
            {
                //m_csPatternInf[lOrderNo] = csPatternInf;
                m_csPatternInf[lOrderNo].DataCopy(csPatternInf);

            }
        }
        /// <summary><para>method outline:</para>
        /// <para>表示パターン取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMeshDispPattern csPtnInf = GetPattern(lOrderNo) </para>
        /// </example>
        /// <param name="lOrderNo">パターン位置（０相対）</param>
        /// <returns>HySGeoMeshDispPattern 表示パターン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoMeshDispPattern GetPattern(long lOrderNo)
        {
            HySGeoMeshDispPattern csRtn = null;
            if (lOrderNo >= 0 && lOrderNo < m_lPatternNum)
            {
                csRtn = m_csPatternInf[lOrderNo];
            }
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTime(csTime) </para>
        /// </example>
        /// <param name="csTime">時刻</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetTime(HySTime csTime)
        {
            m_csCellArray.SetTime(csTime);
        }
        /// <summary><para>method outline:</para>
        /// <para>時刻取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csTime = GetTime() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime 時刻</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetLastTime()
        {
            return m_csCellArray.GetLastTime();
        }

        /// <summary><para>method outline:</para>
        /// <para>日付時刻比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = EqualTime(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date と同じ場合は true、そうでない場合は false
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool EqualTime(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csCellArray != null)
            {
                bRtn = m_csCellArray.EqualTime(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも後か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = After(csTime) </para>
        /// </example>
        /// <param name="csTime">
        /// 比較用日付管理クラスオブジェクト(HySTime)
        /// </param>
        /// <returns>bool  =HySTime の現在時刻が 引数：Date の時刻よりあとの場合は true、そうでない場合は false </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual bool After(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csCellArray != null)
            {
                bRtn = m_csCellArray.After(csTime);
            }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>指定時刻よりも前か</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Before(csTime) </para>
        /// </example>
        /// <param name="csTime">比較用日付管理クラスオブジェクト(HySTime)</param>
        /// <returns>
        /// bool　判定結果
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>bool  =HySTime の現在時刻が 引数：Date の時刻より前の場合は true、そうでない場合は false</para>
        /// </remarks>
        public virtual bool Before(HySTime csTime)
        {
            bool bRtn = false;
            if (m_csCellArray != null)
            {
                bRtn = m_csCellArray.Before(csTime);
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられたデータを自分にコピーする</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyData(csOrgData) </para>
        /// </example>
        /// <param name="csOrgData">コピー元情報</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void CopyData(HySGeoMesh csOrgData)
        {
            //if (m_csCellArray != null)
            //{
            //    m_csCellArray.CopyData(csOrgData.m_csCellArray);
            //}
            m_dSWLatitude = csOrgData.m_dSWLatitude;
            m_dSWLongitude = csOrgData.m_dSWLongitude;
            m_dNELatitude = csOrgData.m_dNELatitude;
            m_dNELongitude = csOrgData.m_dNELongitude;
            m_dUpperAltitude = csOrgData.m_dUpperAltitude;
            m_dLowerAltitude = csOrgData.m_dLowerAltitude;
            m_lMeshKind = csOrgData.m_lMeshKind;
            m_lLatDim = csOrgData.m_lLatDim;
            m_lLonDim = csOrgData.m_lLonDim;
            m_lAltDim = csOrgData.m_lAltDim;        
            m_lPatternNum = csOrgData.m_lPatternNum;
            for( long lLp=0;lLp<m_lPatternNum;lLp++)
            {
                m_csPatternInf[lLp] = new HySGeoMeshDispPattern("");
                m_csPatternInf[lLp].DataCopy(csOrgData.m_csPatternInf[lLp]);
            }
        }

        /*
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataMeaning(lDimItemNo, csMeaningKind) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <param name="csMeaning">データの意味</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDataMeaning(long lDimItemNo, HySObjectKind csMeaning)
        {
            m_csCellArray.SetDataMeaning(lDimItemNo, csMeaning);
        }
        /// <summary><para>method outline:</para>
        /// <para>系列データの種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csDtMeaning = GetDataMeaning(lDimItemNo) </para>
        /// </example>
        /// <param name="lDimItemNo">配列の順番（０相対）</param> 
        /// <returns>HySObjectKind データの意味</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySObjectKind GetDataMeaning(long lDimItemNo)
        {
            return m_csCellArray.GetDataMeaning(lDimItemNo);
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>セル内データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>
        ///    HySCellArray csCellArry = GetCellArray();
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySCellArray セル内データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellArray GetCellArray()
        { return m_csCellArray; }

        /// <summary><para>method outline:</para>
        /// <para>セル識別子とセルの配列管理データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCellIDMngData(csCellIDMngData); </para>
        /// </example>
        /// <param name="csCellIDMngData">セル識別子とセルの配列管理データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetCellIDMngData(HySCellIDManageData csCellIDMngData)
        {
            m_csCellArray.SetCellIDMngData(csCellIDMngData);
        }
        /// <summary><para>method outline:</para>
        /// <para>セル識別管理データ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySCellIDManageData csCellIDMngDt = GetCellIDMngData( ) </para>
        /// </example>
        /// <param name=""></param> 
        /// <returns>HySCellIDManageData セル識別管理データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySCellIDManageData GetCellIDMngData()
        {
            return m_csCellArray.GetCellIDMngData();
        }
        /// <summary><para>method outline:</para>
        /// <para>単独データメッシュ情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoMesh csCellArray = CreateSingleDataMesh(lDataIndex) </para>
        /// </example>
        /// <param name="lDataIndex">セル内データIndex(0相対)</param>
        /// <returns> HySGeoMesh 単独データメッシュ情報　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>指定されたインデックスのセル内部データのみを持つメッシュ情報データを生成する</para>
        /// </remarks>
        public abstract HySGeoMesh CreateSingleDataMesh(long lDataIndex);


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
