﻿// <summary>ソースコード：>河道横断面データ検索条件クラス</summary>
// <author>CommonMP</author>

using System;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>河道横断面データ検索条件フィールド名定義</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>HySQueryEntryData.FieldNameに指定できる名前を定義する。</para>
    /// <para>本クラスに含まれる名前は、河道横断面データ固有のフィールドである。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/17][新規作成]</para>
    /// </remarks>
    public class HySGeoRiverCrossSectionQueryFieldNames : HySQueryFieldNames
    {
        /// <summary>
        /// 河川コード
        /// </summary>
        public static readonly HySString RIVER_CODE = new HySString("RIVER_CODE");

        /// <summary>
        /// 補助河川コード
        /// </summary>
        public static readonly HySString AUX_RIVER_CODE = new HySString("AUX_RIVER_CODE");

        /// <summary>
        /// 距離標
        /// </summary>
        public static readonly HySString DISTANCE_POST = new HySString("DISTANCE_POST");

        /// <summary>
        /// 断面ID
        /// </summary>
        public static readonly HySString CROSS_SEC_ID = new HySString("CROSS_SEC_ID");

    }

}
