﻿// <summary>ソースコード：>ＨＹＳＳＯＰ河川距離標クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>河川距離標クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/17][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySGeoRiverDistancePost : HySDataRoot, HySVersionManagement
    {

        /// <summary>距離</summary>
        private double m_dDistance;
        /// <summary>左岸位置情報</summary>
        private HySGeoPoint m_csLeftGeoPoint;
        /// <summary>右岸位置情報</summary>
        private HySGeoPoint m_csRightGeoPoint;


        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoRiverDistancePost csDt = new HySGeoRiverDistancePost() 
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>なし</para>
        /// </remarks>
        public HySGeoRiverDistancePost()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>距離設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDistance(csDistance) </para>
        /// </example>
        /// <param name="csDistance">距離</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDistance(double csDistance)
        {
            m_dDistance = csDistance;
        }

        /// <summary><para>method outline:</para>
        /// <para>距離取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> double csDistance = GetDistance() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>距離</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double GetDistance()
        {
            return m_dDistance;
        }

        /// <summary><para>method outline:</para>
        /// <para>左岸点設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLeftGeoPoint(csPoint) </para>
        /// </example>
        /// <param name="csPoint">左岸点位置情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLeftGeoPoint(HySGeoPoint csPoint)
        {
            m_csLeftGeoPoint = csPoint;
        }

        /// <summary><para>method outline:</para>
        /// <para>左岸点取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoPoint csPoint = GetLeftGeoPoint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>左岸点位置情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoPoint GetLeftGeoPoint()
        {
            return m_csLeftGeoPoint;
        }

        /// <summary><para>method outline:</para>
        /// <para>右岸点設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetRightGeoPoint(csPoint) </para>
        /// </example>
        /// <param name="csPoint">右岸点位置情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRightGeoPoint(HySGeoPoint csPoint)
        {
            m_csRightGeoPoint = csPoint;
        }

        /// <summary><para>method outline:</para>
        /// <para>右岸点取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoPoint csPoint = GetRightGeoPoint() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>右岸点位置情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGeoPoint GetRightGeoPoint()
        {
            return m_csRightGeoPoint;
        }
          
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
