﻿// <summary>ソースコード：ウェブプロキシクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>ウェブプロキシクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/24][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySWebProxy : HySDataRoot, HySVersionManagement
    {
        /// <summary>ウェブプロキシのURI</summary>
        private HySString m_csUri;

        /// <summary>ユーザ名</summary>
        private HySString m_csUserName;

        /// <summary>パスワード</summary>
        private HySString m_csPassword;

        /// <summary><para>method outline:</para>
        /// <para>URI設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUri(csUri) </para>
        /// </example>
        /// <param name="csUri">ウェブプロキシのURI</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUri(HySString csUri)
        {
            m_csUri = csUri;
        }

        /// <summary><para>method outline:</para>
        /// <para>URI取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csUri = GetUri() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ウェブプロキシのURI</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetUri()
        {
            return m_csUri;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザ名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetUserName(csUserName) </para>
        /// </example>
        /// <param name="csUserName">ウェブプロキシのユーザ名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetUserName(HySString csUserName)
        {
            m_csUserName = csUserName;
        }

        /// <summary><para>method outline:</para>
        /// <para>ユーザ名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csUserName = GetUserName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ウェブプロキシのユーザ名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetUserName()
        {
            return m_csUserName;
        }

        /// <summary><para>method outline:</para>
        /// <para>パスワード設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetPassword(csPassword) </para>
        /// </example>
        /// <param name="csPassword">ウェブプロキシのパスワード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetPassword(HySString csPassword)
        {
            m_csPassword = csPassword;
        }

        /// <summary><para>method outline:</para>
        /// <para>パスワード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csPassword = GetPassword() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ウェブプロキシのパスワード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetPassword()
        {
            return m_csPassword;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
