﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSDBA;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>演算結果データ検索条件フィールド名定義</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>HySQueryEntryData.FieldNameに指定できる名前を定義する。</para>
    /// <para>本クラスに含まれる名前は、演算結果データ固有のフィールドである。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/25][新規作成]</para>
    /// </remarks>
    public class HySCalResultDataQueryFieldNames : HySQueryFieldNames
    {
        /// <summary>
        /// プロジェクト名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString PROJECT_NAME = new HySString("PROJECT_NAME");

        /// <summary>
        /// 管理者名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MANAGER_NAME = new HySString("MANAGER_NAME");

        /// <summary>
        /// 種別（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_TYPE = new HySString("MODEL_TYPE");

        /// <summary>
        /// 対象（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_TARGET = new HySString("MODEL_TARGET");

        /// <summary>
        /// モデル（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_CALC_TYPE = new HySString("MODEL_CALC_TYPE");

        /// <summary>
        /// 件名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_SUBJECT = new HySString("MODEL_SUBJECT");

        /// <summary>
        /// ケース名（プロジェクト情報より）
        /// </summary>
        public static readonly HySString MODEL_SITUATION = new HySString("MODEL_SITUATION");

        /// <summary>
        /// 演算実行日時（演算ロット情報より）
        /// </summary>
        public static readonly HySString CALC_EXEC_DATE = new HySString("CALC_EXEC_DATE");

        /// <summary>
        /// データ型
        /// </summary>
        public static readonly HySString DATA_TYPE = new HySString("DATA_TYPE");

        /// <summary>
        /// データ次元1
        /// </summary>
        public static readonly HySString DATA_DIM1 = new HySString("DATA_DIM1");

        /// <summary>
        /// データ次元2
        /// </summary>
        public static readonly HySString DATA_DIM2 = new HySString("DATA_DIM2");

        /// <summary>
        /// データ次元3
        /// </summary>
        public static readonly HySString DATA_DIM3 = new HySString("DATA_DIM3");

        /// <summary>
        /// 要素名称 -- HySStockData.GetKeyInfo().GetObject()
        /// </summary>
        public static readonly HySString ELEMENT_NAME = new HySString("ELEMENT_NAME");

        /// <summary>
        /// 要素ID -- HySStockData.GetKeyInfo().GetObject()
        /// </summary>
        public static readonly HySString ELEMENT_ID = new HySString("ELEMENT_ID");

        /// <summary>
        /// 演算結果連番(登録のみ有効) -- HySStockData.GetKeyInfo().GetObject()
        /// </summary>
        public static readonly HySString CALC_RESULT_SEQNO = new HySString("CALC_RESULT_SEQNO");
    }

}
