﻿// <summary>ソースコード：>演算ロット情報管理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>演算ロット情報管理クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/22][新規作成]</para>
    /// <para>Remarks:</para>
    /// <para>演算ロットの情報を此処で管理する</para>
    /// </remarks>
    [Serializable]
    public class HySCalcLotInfo : HySDataRoot, HySVersionManagement
    {
        /// <summary> データコンテナに積む場合のキー情報</summary>
        static public readonly HySString DATA_KEY_CALC_LOT = new HySString("HySCalcLotInfo");

        /// <summary>演算ロット識別子（必須）：一貫ユニークキー自動的に　生成される</summary>
        protected HySID m_csCalcLotID = null;

        // シミュレーター種別とシミュレーターＩＤで　シミュレーターはユニークに決定される
        /// <summary>シミュレーター種別</summary>
        protected HySObjectKind m_csSimKind = null;
        /// <summary>シミュレータープロジェクトＩＤ</summary>
        protected HySID m_csSimPrjctID = null;

        /// <summary>演算実行日時：閲覧のみ</summary>
        protected HySTime  m_csCalcExecDate = null;

        /// <summary>補足情報 </summary>
        protected HySDataRoot  m_csSuppInfo=null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySDepositData csReportBase = new HySDepositData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDepositData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected HySCalcLotInfo()
        {
            this.Init();
            //バージョン情報設定
            SetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySStockData csData = new HySStockData(csSaveName)</para>
        /// </example>
        /// <param name="csSimKind">ｼﾐｭﾚｰｼｮﾝ種別</param>
        /// <param name="csSimID">ｼﾐｭﾚｰｼｮﾝＩＤ</param>
        /// <returns>HySDepositData  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySCalcLotInfo( HySKind csSimKind,  HySIdentifier csSimID) //, HySDataRoot csResistData)
        {
            this.Init();
            m_csSimKind = ((HySObjectKind)csSimKind).Clone();
            m_csSimPrjctID = ((HySID)csSimID).Clone();
            //バージョン情報設定
            SetNowVersion();

            //m_csSaveName = csSaveName;
            //m_csResistData = csResistData;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void Init()
        {
            DateTime now = DateTime.Now;
            long csLotIDUpper = (now.Year * 10000) + (now.Month * 100) + now.Day;
            long csLotIDLower = (now.Hour * 10000000) + (now.Minute * 100000) + (now.Second * 1000) + now.Millisecond;
            string csLotIDString = string.Format("{0:X7}{1:X7}", csLotIDUpper, csLotIDLower);
            m_csCalcLotID = new HySID(csLotIDString);
        }

        /// <summary><para>method outline:</para>
        /// <para>識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIdentifier csID = GetID() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySIdentifier  識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetCalcLotID()
        {
            return m_csCalcLotID;
        }
        /// <summary><para>method outline:</para>
        /// <para>識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = Equal(csID) </para>
        /// </example>
        /// <param name="csID">比較する種別識別子</param>
        /// <returns>Boolean　true:=一致, false:=不一致</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean Equal(HySID csID)
        {
            return m_csCalcLotID.Equals(csID);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySObjectKind csSimKind GetSimKind( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySObjectKind シミュレーター種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySObjectKind GetSimKind()
        {
            return m_csSimKind;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーターＩＤ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csSimID GetSimID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID シミュレーターＩＤ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySID GetSimID()
        {
            return m_csSimPrjctID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算実行日時設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetRCalcExecDate(csRegisertTime) </para>
        /// </example>
        /// <param name="csCalcExecDate">データ登録日時</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetRCalcExecDate(HySTime csCalcExecDate)
        {
            m_csCalcExecDate = csCalcExecDate.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>演算実行日時取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTime csRegisertTime GetRegisertTime( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySTime データ登録日時</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySTime GetCalcExecDate()
        {
            return m_csCalcExecDate;
        }

        /// <summary><para>method outline:</para>
        /// <para>登録データ本体設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetData(csStockData) </para>
        /// </example>
        /// <param name="csSuppInfo">登録データ本体</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>データ構造体を意識しない為、登録データ本体は複製を引き渡すこと</para>
        /// </remarks>
        public virtual void SetSuppInfo(HySDataRoot csSuppInfo)
        {
            m_csSuppInfo = csSuppInfo;
        }
        /// <summary><para>method outline:</para>
        /// <para>登録データ本体取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csStockData GetData( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot 登録データ本体</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySDataRoot GetSuppInfo()
        {
            return m_csSuppInfo;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================

        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
