﻿// <summary>ソースコード：>データ検索条件クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>データ検索条件クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/04/22][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySQueryCtlData : HySDataRoot, HySVersionManagement
    {
　      /// <summary>
        /// 「メタデータのみ取得する」を指定するフラグ。規定値はfalse
        /// </summary>
        protected Boolean m_bIsMetaDataOnly = false;

        /// <summary>
        /// 検索条件エントリテーブル
        /// </summary>
        protected HySDataHashTable m_csQueryEntryTable = new HySDataHashTable();

        /// <summary>
        /// 検索件数の上限値。-1の場合は制限なし。
        /// </summary>
        protected int m_iLimitOfSearchResults = -1;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySQueryCtlData csNewQuery = new HySQueryCtlData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySQueryCtlData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySQueryCtlData()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>コピーコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySQueryCtlData csNewQuery = new HySQueryCtlData(csQuery) </para>
        /// </example>
        /// <param name="csQuery">データ検索条件</param>
        /// <returns> HySQueryCtlData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySQueryCtlData(HySQueryCtlData csQuery)
        {
            m_bIsMetaDataOnly = csQuery.m_bIsMetaDataOnly;
            m_csQueryEntryTable = csQuery.m_csQueryEntryTable;
            m_iLimitOfSearchResults = csQuery.m_iLimitOfSearchResults;
        }

        /// <summary><para>method outline:</para>
        /// <para>メタデータのみ取得フラグ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetIsMetaDataOnly(bValue) </para>
        /// </example>
        /// <param name="bValue">データ検索条件</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetIsMetaDataOnly(Boolean bValue)
        {
            m_bIsMetaDataOnly = bValue;
        }

        /// <summary><para>method outline:</para>
        /// <para>メタデータのみ取得フラグ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Boolean bValue = GetIsMetaDataOnly()</para>
        /// </example>
        /// <param name="">なし</param>
        /// <returns>メタデータのみ取得フラグ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Boolean GetIsMetaDataOnly()
        {
            return m_bIsMetaDataOnly;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件エントリ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetQueryEntryData(csQueryEntryData)</para>
        /// </example>
        /// <param name="csQueryEntryData">検索条件エントリ。csQueryEntryData.FieldNameをキーにして複数の検索条件エントリを登録できる。</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetQueryEntryData(HySQueryEntryData csQueryEntryData)
        {
            m_csQueryEntryTable.AddObject(csQueryEntryData.GetFieldName(), csQueryEntryData);
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件エントリ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySQueryEntryData csEntryData = GetQueryEntryData(csFieldName)</para>
        /// </example>
        /// <param name="csFieldName">検索条件エントリのフィールド名</param>
        /// <returns>検索条件エントリ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySQueryEntryData GetQueryEntryData(HySString csFieldName)
        {
            return (HySQueryEntryData)m_csQueryEntryTable[csFieldName];
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件エントリ数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lCount = GetCount()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>設定されている検索条件エントリの個数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long GetCount()
        {
            HySDataLinkedList csKeyList = m_csQueryEntryTable.GetKeyList();
            if (csKeyList != null)
            {
                return csKeyList.GetCount();
            }
            else
            {
                return 0;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件エントリ削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>RemoveQueryEntryData(csFieldName)</para>
        /// </example>
        /// <param name="csFieldName">検索条件エントリのキー名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void RemoveQueryEntryData(HySString csFieldName)
        {
            m_csQueryEntryTable.DeleteData(csFieldName);
        }

        /// <summary><para>method outline:</para>
        /// <para>検索件数上限値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetLimitOfSearchResults(iNum) </para>
        /// </example>
        /// <param name="iNum">検索件数上限値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLimitOfSearchResults(int iNum)
        {
            m_iLimitOfSearchResults = iNum;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索件数上限値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> int iNum = GetLimitOfSearchResults() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>検索件数上限値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int GetLimitOfSearchResults()
        {
            return m_iLimitOfSearchResults;
        }

        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
