﻿// <summary>ソースコード：>データ検索条件クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>データ検索条件エントリクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>HySQueryCtlDataに追加する個別の検索条件を表す。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/22][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySQueryEntryData : HySDataRoot, HySVersionManagement
    {
        /// <summary>
        /// 検索対象フィールド名。規定値はnull
        /// </summary>
        protected HySString m_csFieldName = null;

        /// <summary>
        /// フィールドのデータ型
        /// </summary>
        private Type m_csDataType;

        /// <summary>
        /// 検索条件の比較モード。規定値はEQUALS
        /// </summary>
        protected HySQueryCompareMode m_csCompareMode = HySQueryCompareMode.EQUALS;

        /// <summary>
        /// 比較対象の値。比較方法はSetCompareModeで指定する
        /// </summary>
        protected object m_csValueToCompare = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySQueryEntryData csEntryData = new HySQueryEntryData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySQueryEntryData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySQueryEntryData()
        {

        }

        /// <summary><para>method outline:</para>
        /// <para>引数有コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySQueryEntryData csEntryData = new HySQueryEntryData(csFieldName, csDataType, csCompareMode, csValueToCompare</para>
        /// </example>
        /// <param name="csFieldName">>検索対象フィールド名</param>
        /// <param name="csDataType">フィールドのデータ型</param>
        /// <param name="csCompareMode">比較モード列挙体のひとつ</param>
        /// <param name="csValueToCompare">比較対象の値</param>
        /// <returns>HySQueryEntryData 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySQueryEntryData(HySString csFieldName, Type csDataType, HySQueryCompareMode csCompareMode,
                                    object csValueToCompare)
        {
            m_csFieldName = csFieldName;
            m_csDataType = csDataType;
            m_csCompareMode = csCompareMode;
            m_csValueToCompare = csValueToCompare;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索対象フィールド名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFieldName(csFieldName)</para>
        /// </example>
        /// <param name="csFieldName">>検索対象フィールド名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetFieldName(HySString csFieldName)
        {
            m_csFieldName = csFieldName;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索対象フィールド名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GetFieldName()</para>
        /// </example>
        /// <param name="">>無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetFieldName()
        {
            return m_csFieldName;
        }

        /// <summary><para>method outline:</para>
        /// <para>フィールドデータ型設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDataType(csDataType)</para>
        /// </example>
        /// <param name="csDataType">>フィールドのデータ型</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDataType(Type csDataType)
        {
            m_csDataType = csDataType;
        }

        /// <summary><para>method outline:</para>
        /// <para>フィールドデータ型取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Type csDataType = GetDataType()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>フィールドのデータ型</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Type GetDataType()
        {
            return m_csDataType;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件比較モード設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetCompareMode(csCompareMode)</para>
        /// </example>
        /// <param name="csCompareMode">比較モード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetCompareMode(HySQueryCompareMode csCompareMode)
        {
            m_csCompareMode = csCompareMode;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件比較モー取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySQueryCompareMode csCompareMode = GetCompareMode()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>比較モード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySQueryCompareMode GetCompareMode()
        {
            return m_csCompareMode;
        }

        /// <summary><para>method outline:</para>
        /// <para>比較対象の値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetValueToCompare(csValueToCompare)</para>
        /// </example>
        /// <param name="csValueToCompare">比較対象の値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetValueToCompare(object csValueToCompare)
        {
            m_csValueToCompare = csValueToCompare;
        }

        /// <summary><para>method outline:</para>
        /// <para>比較対象の値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>object csObject = GetValueToCompare()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>比較対象の値無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual object GetValueToCompare()
        {
            return m_csValueToCompare;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                if (GetDecodedVersion() == null)
                {
                    // 旧バージョンからの移行処理を入れる
                }
                else
                {
                    //旧バージョンから順にバージョンを上げて行く
                    switch (GetDecodedVersion())
                    {
                        case "1.00":
                            {
                                // 旧バージョンからの移行処理を入れる
                                break;
                            }
                        //case "2.00": << 以後バージョンアップに伴って処理追加
                        //{
                        //    break;
                        //}
                    }                    
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
