﻿// <summary>ソースコード：>データ検索条件クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections;
using System.Collections.Generic;
using System.Xml;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSData
{
    /// <summary><para>class outline:</para>
    /// <para>検索条件フィールド名定義</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>HySQueryEntryData.FieldNameに指定できる名前を定義する。</para>
    /// <para>本クラスに含まれる名前はHySStockDataの属性に対応する。
    /// 登録データ本体に含まれるメタデータやHySStockDataの派生クラスを検索条件に用いる場合、
    /// 本クラスを拡張するか、独自のフィールド名定義クラスを作成すること。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/22][新規作成]</para>
    /// </remarks>
    public class HySQueryFieldNames
    {
        /// <summary>
        /// データID -- HySStockData.GetID()
        /// </summary>
        public static readonly HySString ID = new HySString("ID");

        /// <summary>
        /// ロットID -- HySStockData.GetKeyInfo().GetObject()
        /// </summary>
        public static readonly HySString LOT_ID = new HySString("LOT_ID");

        /// <summary>
        /// データ種別 -- HySStockData.GetDataKind()
        /// </summary>
        public static readonly HySString DATA_KIND = new HySString("DATA_KIND");

        /// <summary>
        /// シミュレーター種別 -- HySStockData.GetSimKind()
        /// </summary>
        public static readonly HySString SIM_KIND = new HySString("SIM_KIND");

        /// <summary>
        /// シミュレーターＩＤ -- HySStockData.GetSimID()
        /// </summary>
        public static readonly HySString SIM_ID = new HySString("SIM_ID");

        /// <summary>
        /// データ地点ＩＤ -- GetPointID
        /// </summary>
        public static readonly HySString POINT_ID = new HySString("POINT_ID");

        /// <summary>
        /// 登録名称 -- HySStockData.GetSaveName()
        /// </summary>
        public static readonly HySString SAVE_NAME = new HySString("SAVE_NAME");

        /// <summary>
        /// 保存期限区分 -- HySStockData.GetPeservedPeriod()
        /// </summary>
        public static readonly HySString PRESERVED_PERIOD = new HySString("PRESERVED_PERIOD");

        /// <summary>
        /// 保存期限区分変更日 -- HySStockData.GetPeservedPeriodModifyTime()
        /// </summary>
        public static readonly HySString PRESERVED_PERIOD_MODIFY_TIME = new HySString("PRESERVED_PERIOD_MODIFY_TIME");
    }

}
