// <summary>ソースコード：ＧＩＳ 背景地図ビュー基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.Interface.HSData;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{    
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ関連情報Ｉ／Ｆ</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class HySGISInfoData : HySGISInfo, HySVersionManagement
    {
        /// <summary>ＧＩＳデータ種別</summary>
        protected HySString m_csGISDataKind = null;

        /// <summary>範囲等</summary>
        protected HySGeoAreaInfo m_csArea = null;

        /// <summary>メッシュサイズ（経度方向）ｍ </summary>
        protected double m_dLonSize = 50.0;
        /// <summary>メッシュサイズ（緯度方向）ｍ </summary>
        protected double m_dLatSize = 50.0;

        /// <summary>出力ファイル </summary>
        protected HySString m_csOutFileNameWithPath = new HySString("..\\ModelData\\GISDataGenerator\\GISOut.csv");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGeoAreaInfo csArea = new HySGeoAreaInfo()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGeoAreaInfo 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISInfoData()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳデータ種別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetGISDataKind(csGISDataKind) </para>
        /// </example>
        /// <param name="csGISDataKind">ＧＩＳデータ種別</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetGISDataKind(HySString csGISDataKind)
        {
            m_csGISDataKind = csGISDataKind.Clone();
        }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳデータ種別取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csGISKind = GetGISDataKind() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySObjectKind ＧＩＳデータ種別</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetGISDataKind()
        {
            return m_csGISDataKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>エリア情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetArea(csArea) </para>
        /// </example>
        /// <param name="csArea">エリア情報</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetArea(HySGeoAreaInfo csArea)
        {
            m_csArea = csArea;
        }
        /// <summary><para>method outline:</para>
        /// <para>エリア情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetArea() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySGeoAreaInfo エリア情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoAreaInfo GetArea()
        {
            return m_csArea;
        }

        /// <summary><para>method outline:</para>
        /// <para>メッシュサイズ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetMeshSize(dLonSize, dLatSize) </para>
        /// </example>
        /// <param name="dLonSize">経度方向メッシュサイズ（ｍ単位）</param>
        /// <param name="dLatSize">緯度方向メッシュサイズ（ｍ単位）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetMeshSize(double dLonSize, double dLatSize)
        {
            m_dLonSize = dLonSize;
            m_dLatSize = dLatSize;
        }
        /// <summary><para>method outline:</para>
        /// <para>メッシュサイズ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetMeshSize(ref dLonSize, ref dLatSize) </para>
        /// </example>
        /// <param name="dLonSize">経度方向メッシュサイズ（ｍ単位）</param>
        /// <param name="dLatSize">緯度方向メッシュサイズ（ｍ単位）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void GetMeshSize(ref double dLonSize, ref double dLatSize)
        {
            dLonSize = m_dLonSize;
            dLatSize = m_dLatSize;
        }

        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報書き出しファイル名（パス付き）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetOutputFile(csOutFileNameWithPath) </para>
        /// </example>
        /// <param name="csOutFileNameWithPath">ＧＩＳ情報書き出しファイル名（パス付き）</param> 
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetOutputFile(HySString csOutFileNameWithPath)
        {
            m_csOutFileNameWithPath = csOutFileNameWithPath;
        }
        /// <summary><para>method outline:</para>
        /// <para>ＧＩＳ情報書き出しファイル名（パス付き）取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetOutputFile() </para>
        /// </example>
        /// <param name="">無し</param> 
        /// <returns>HySString ＧＩＳ情報書き出しファイル名（パス付き）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySString GetOutputFile()
        {
            return m_csOutFileNameWithPath;
        }


        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
