﻿// <summary>ソースコード：ＧＩＳ 背景地図ビュー基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>背景地図ＧＩＳビュー</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public abstract class HySGISBaseMapView : HySGISViewBase
    {
        /// <summary>背景地図スクリーン</summary>
        protected HySGISBaseMapScreen m_csScreen=null;
        /// <summary>背景地図表示制御データ </summary>
        protected HySGeoBaseMapData m_csMapCtlData = null;

        /// <summary>イベントの種別定義</summary>
        public enum EventKind
        {
            /// <summary>マウスクリック位置取得</summary>
            GET_POSITION = 1
            // イベントが増えたときには、此処に追加
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISBaseMapView csBaseMapView = new HySGISBaseMapView( ) 
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISBaseMapView()
        {
            m_csGISKind=(HySObjectKind)HySDefine.DISP_FORM_GIS_BASEMAP;
        }
        
        /// <summary><para>method outline:</para>
        /// <para>背景地図上でのイベント取得モード移行指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CmndGetMapEventMode(eKind)</para>
        /// </example>
        /// <param name="eKind">イベント種別</param>
        /// <returns>モード移行成功：０　その他、モード移行失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract long CmndGetMapEventMode(HySGISBaseMapView.EventKind eKind);

        /// <summary><para>method outline:</para>
        /// <para>背景地図上でのイベント時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeMapEvent(eKind)</para>
        /// </example>
        /// <param name="eKind">イベント種別</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void NoticeMapEvent(HySGISBaseMapView.EventKind eKind);


        /// <summary><para>method outline:</para>
        /// <para>背景地図マウスクリック位置通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NoticeMapMouseEvent( dLat,dLon) 
        /// </para>
        /// </example>
        /// <param name="dLat">地図上緯度（度）</param>
        /// <param name="dLon">地図上経度（度）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void NoticeMapPoint( double dLat, double dLon )
        {
            m_csScreen.NoticeMapPoint(dLat, dLon);
        }

        /// <summary><para>method outline:</para>
        /// <para>対となるＧＩＳスクリーンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetScreen(csGISScreen)</para>
        /// </example>
        /// <param name="csGISScreen">ＧＩＳスクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetScreen(HySScreen csGISScreen)
        {
            m_csScreen = csGISScreen as HySGISBaseMapScreen;
        }
        /// <summary><para>method outline:</para>
        /// <para>背景地図表示制御データの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispMapData(csMapCtlData)</para>
        /// </example>
        /// <param name="csMapCtlData">背景地図表示制御データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispMapData(HySGeoBaseMapData csMapCtlData)
        {
            m_csMapCtlData = csMapCtlData;
        }

    }
}
