﻿// <summary>ソースコード：ＧＩＳ ２次元メッシュ情報ビュー基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ ２次元メッシュ情報ビュー</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>Remarks</para>
    /// <para>インスタンス複数存在有り（複数のメッシュ情報をオーバーレイ表示する）</para>
    /// </remarks>
    public abstract class HySGISDim2MeshView : HySGISViewBase
    {
        /// <summary>２次元メッシュ表示スクリーン</summary>
        protected HySGISDim2MeshScreen m_csScreen = null;
        /// <summary>時系列２次元メッシュ表示データ </summary>
        protected HySGeoDim2MeshSerialData m_csD2MeshSerialData = null;
        /// <summary>２次元メッシュ表示データ </summary>
        protected HySGeoDim2MeshData m_csD2MeshData = null;

        //=================================
        // 表示条件
        //=================================
        /// <summary>表示方法定義 </summary>
        public enum DispMode
        {
            /// <summary>アニメーション </summary>
            ANIMATION = 1,
            /// <summary>静止 </summary>
            STILL
        }
        /// <summary>表示方法 </summary>
        protected DispMode m_eDispMode = DispMode.STILL;

        /// <summary>表示中情報の時刻 </summary>
        protected HySTime m_csCurrentTime = null;
        /// <summary>アニメ開始時刻 </summary>
        protected HySTime m_csFirstTime = null;
        /// <summary>アニメ終了時刻：または、静止表示時の指定時刻 </summary>
        protected HySTime m_csLastTime = null;
        /// <summary>アニメーション時のコマ送り間隔（秒）</summary>
        protected HySTime m_csMotionSpan = new HySTime(1.5);


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISDim2MeshView csView = new HySGISDim2MeshView( ) 
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISDim2MeshView()
        {
            m_csGISKind = (HySObjectKind)HySDefine.DISP_FORM_GIS2D_MESH;
        }
        /// <summary><para>method outline:</para>
        /// <para>対となるＧＩＳスクリーンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetScreen(csGISScreen)</para>
        /// </example>
        /// <param name="csGISScreen">ＧＩＳスクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetScreen(HySScreen csGISScreen)
        {
            m_csScreen = csGISScreen as HySGISDim2MeshScreen;
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列２次元メッシュデータの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispMeshData(csD2MeshSerialData)</para>
        /// </example>
        /// <param name="csD2MeshSerialData">時系列２次元メッシュデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispMeshData(HySGeoDim2MeshSerialData csD2MeshSerialData)
        {
            m_csD2MeshSerialData = csD2MeshSerialData;
        }
        /// <summary><para>method outline:</para>
        /// <para>２次元メッシュデータの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispMeshData(csD2MeshData)</para>
        /// </example>
        /// <param name="csD2MeshData">２次元メッシュデータ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispMeshData(HySGeoDim2MeshData csD2MeshData)
        {
            m_csD2MeshData = csD2MeshData;
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列２次元メッシュデータの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySGeoDim2MeshSerialData csD2MeshSerialData GetDispMeshSerialData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>時系列２次元メッシュデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoDim2MeshSerialData GetDispMeshSerialData()
        {
            return m_csD2MeshSerialData;
        }
        /// <summary><para>method outline:</para>
        /// <para>２次元メッシュデータの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySGeoDim2MeshData csD2MeshData GetDispMeshData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>２次元メッシュデータ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoDim2MeshData GetDispMeshData()
        {
            return m_csD2MeshData;
        }
        /// <summary><para>method outline:</para>
        /// <para>アニメーション開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StartAnimation()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void StartAnimation();
        /// <summary><para>method outline:</para>
        /// <para>アニメーション停止</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>PauseAnimation()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void PauseAnimation();
        /// <summary><para>method outline:</para>
        /// <para>表示対象の時刻を先頭に設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ResetAnimation()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void ResetAnimation();

    }
}
