﻿// <summary>ソースコード：ＧＩＳ自由図形表示 ビュー基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSGIS;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ自由図形表示 情報ビュー</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>Remarks</para>
    /// <para>インスタンス複数存在有り（複数のメッシュ情報をオーバーレイ表示する）</para>
    /// </remarks>
    public abstract class HySGISMapFigureView : HySGISViewBase
    {
        /// <summary>ＧＩＳ自由図形表示スクリーン</summary>
        protected HySGISMapFigureScreen m_csScreen = null;
        /// <summary>時系列ＧＩＳ自由図形表示データ </summary>
        protected HySGeoMapFigureSerialData m_csMapFigureSerialData = null;
        /// <summary>ＧＩＳ自由図形表示データ </summary>
        protected HySGeoMapFigureData m_csMapFigureData = null;

        /// <summary> セレクト済みオブジェクトＩＤのリスト</summary>
        protected HySDataLinkedList m_csSelectedIDList = new HySDataLinkedList();

        /// <summary> 表示中オブジェクトのリスト</summary>
        protected HySGeoMapFigureData m_csShowObjects = new HySGeoMapFigureData();
        /// <summary> 非表示となる表示中オブジェクトのリスト</summary>
        protected HySGeoMapFigureData m_csHideObjects = new HySGeoMapFigureData();

        //=================================
        // 表示条件
        //=================================
        /// <summary>表示方法定義 </summary>
        public enum DispMode
        {
            /// <summary>アニメーション </summary>
            ANIMATION = 1,
            /// <summary>静止 </summary>
            STILL
        }
        /// <summary>表示方法 </summary>
        protected DispMode m_eDispMode = DispMode.STILL;

        /// <summary>表示中情報の時刻 </summary>
        protected HySTime m_csCurrentTime = new HySTime(-20000*365,0,0,0);
        /// <summary>アニメ開始時刻 </summary>
        protected HySTime m_csFirstTime = null;
        /// <summary>アニメ終了時刻：または、静止表示時の指定時刻 </summary>
        protected HySTime m_csLastTime = null;

        /// <summary>アニメーション時のコマ送り間隔（秒）</summary>
        protected HySTime m_csMotionSpan = new HySTime(1.0);

        //=================================
        // イベント関連
        //=================================
        /// <summary>イベントの種別定義</summary>
        public enum EventKind
        {      
            /// <summary>セレクトモードＯＦＦ</summary>
            SELECT_OFF = 1,
            /// <summary>セレクトモードＯＮ</summary>
            SELECT_ON 
            // イベントが増えたときには、此処に追加
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISDim2MeshView csView = new HySGISDim2MeshView( ) 
        /// </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISMapFigureView()
        {
            m_csGISKind = (HySObjectKind)HySDefine.DISP_FORM_GIS_FIGURE;
        }
        /// <summary><para>method outline:</para>
        /// <para>対となるＧＩＳスクリーンの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetScreen(csGISScreen)</para>
        /// </example>
        /// <param name="csGISScreen">ＧＩＳスクリーン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void SetScreen(HySScreen csGISScreen)
        {
            m_csScreen = csGISScreen as HySGISMapFigureScreen;
        }
        /// <summary><para>method outline:</para>
        /// <para>時系列自由図形データの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispFigureData(csFigureSerialData)</para>
        /// </example>
        /// <param name="csFigureSerialData">時系列自由図形データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispFigureData(HySGeoMapFigureSerialData csFigureSerialData)
        {
            m_csMapFigureSerialData = csFigureSerialData;
        }
        /// <summary><para>method outline:</para>
        /// <para>自由図形データの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetDispFigureData(csFigureData)</para>
        /// </example>
        /// <param name="csFigureData">自由図形データ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetDispFigureData(HySGeoMapFigureData csFigureData)
        {
            m_csMapFigureData = csFigureData;
        }
        /// <summary><para>method outline:</para>
        /// <para>自由図形データの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySGeoMapFigureData csFigureData = GetDispFigureData()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>自由図形データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySGeoMapFigureData GetDispFigureData()
        {
            return m_csMapFigureData;
        }

        // ========================================
        //  地図上イベント取得
        // ========================================
        /// <summary><para>method outline:</para>
        /// <para>地図上でのイベント取得モード移行指示</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CmndGetMapEventMode(eKind)</para>
        /// </example>
        /// <param name="eKind">イベント種別</param>
        /// <returns>モード移行成功：０　その他、モード移行失敗</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract long CmndGetMapEventMode(HySGISMapFigureView.EventKind eKind);

        /// <summary><para>method outline:</para>
        /// <para>イベント時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeMapEvent()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract void NoticeMapEvent( );
        /// <summary><para>method outline:</para>
        /// <para>オブジェクトセレクト時処理（単数セレクト）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSelectON(csID)</para>
        /// </example>
        /// <param name="csID">セレクト対象オブジェクトのＩＤ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>既にセレクトされているオブジェクトのセレクト状態は解除される</para>
        /// </remarks>
        protected virtual void NoticeSelectON(HySID csID)
        {
            this.NoticeSelectOFF(); // 既にセレクトされているオブジェクトのセレクト状態は解除される
            this.m_csSelectedIDList.AddLast(csID);
            m_csScreen.NoticeObjectSelect(true, m_csSelectedIDList); // Screen に対してセレクト化を通知する
        }
        /// <summary><para>method outline:</para>
        /// <para>オブジェクトセレクト時処理（複数セレクト）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSelectON(csIDList)</para>
        /// </example>
        /// <param name="csIDList">セレクト対象オブジェクトＩＤのリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>既にセレクトされているオブジェクトのセレクト状態は解除される</para>
        /// </remarks>
        protected virtual void NoticeSelectON(HySDataLinkedList csIDList)
        {
            this.NoticeSelectOFF(); // 既にセレクトされているオブジェクトのセレクト状態は解除される
            // セレクト情報を保持しておく
            long lNum = csIDList.GetCount();
            csIDList.SetCursorFirst();
            for (long lLp = 0; lLp < lNum; lLp++)
            {
                this.m_csSelectedIDList.AddLast(csIDList.GetCursorData());
                csIDList.MoveCursorNext();
            }
            m_csScreen.NoticeObjectSelect(true, m_csSelectedIDList); // Screen に対してセレクト化を通知する
        }
        /// <summary><para>method outline:</para>
        /// <para>オブジェクトセレクト解除時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>NoticeSelectOFF()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void NoticeSelectOFF()
        {
            m_csScreen.NoticeObjectSelect(false, m_csSelectedIDList); // Screen に対して非セレクト化を通知する
            m_csSelectedIDList.Clear(); //セレクト済み解除
        }

        // ======================================
        //  表示・非表示制御
        // ======================================
        /// <summary><para>method outline:</para>
        /// <para>オブジェクト表示時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ShowObject(csShowObjects)</para>
        /// </example>
        /// <param name="csShowObjects">表示するオブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected abstract void ShowObject(HySGeoMapFigureData csShowObjects);
        /// <summary><para>method outline:</para>
        /// <para>オブジェクト非表示時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HideObject(csHideObjects)</para>
        /// </example>
        /// <param name="csHideObjects">非表示化するオブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected abstract void HideObject(HySGeoMapFigureData csHideObjects);
        /// <summary><para>method outline:</para>
        /// <para>オブジェクト表示更新処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>RenewObject(csHideObjects)</para>
        /// </example>
        /// <param name="csDispTime">表示時間</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected virtual void RenewObject(HySTime csDispTime)
        {
            // 表示時間設定
            m_csCurrentTime = csDispTime;
            // 表示情報取得
            m_csMapFigureSerialData.SetCursor(m_csCurrentTime);
            HySGeoMapFigureData csDispFig = m_csMapFigureSerialData.GetCursorData() as HySGeoMapFigureData;
            if (csDispFig != null)
            {
                /*
                // 現在表示中のオブジェクトを　非表示側に持っていく
                HySGeoMapFigureData csTempFigDt = m_csHideObjects;
                m_csHideObjects = m_csShowObjects;
                m_csShowObjects = csTempFigDt;
                // 現在表示側は、クリアされている

                // クリアされた表示中リストへ　表示すべき情報を設定する
                long lDt = csDispFig.GetCount();
                csDispFig.SetCursorFirst();
                for (long lLp = 0; lLp < lDt; lLp++)
                {
                    m_csShowObjects.AddLast(csDispFig.GetCursorData());
                    csDispFig.MoveCursorNext();
                }

                this.HideObject(m_csHideObjects);// 表示中情報を全て非表示化する
                this.ShowObject(m_csShowObjects);// 新情報情報を全て表示化する
                m_csHideObjects.Clear(); // 表示中情報をクリアする
                */

                this.HideObject(m_csShowObjects);// 表示中情報を全て非表示化する
                this.ShowObject(csDispFig);// 新情報情報を全て表示化する
                m_csShowObjects.Clear(); // クリア
                // 表示中情報を設定して、保持しておく
                long lDt = csDispFig.GetCount();
                csDispFig.SetCursorFirst();
                for (long lLp = 0; lLp < lDt; lLp++)
                {
                    m_csShowObjects.AddLast(csDispFig.GetCursorData());
                    csDispFig.MoveCursorNext();
                }
                // 上記方式では　一度表示している情報を非表示化して再表示しているため処理が遅くなる可能セがある。
                // COTS によっては、変更のあったものをのみを再描画する方式が良い場合もある
            }
            else
            {
                this.HideObject(m_csShowObjects);
                m_csShowObjects.Clear();
            }

        }

    }
}
