// <summary>ソースコード：ＧＩＳデータの種別定義</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳデータの種別定義</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public static class HySGISDataKindDefine
    {
        // =============================
        //// <summary> ＧＩＳ一般情報 (データ種別文字列)：特に規定しないときには　この値を使用する</summary>
        //static public HySString GIS_GENERAL_DATA = new HySString("GISGeneralData");
        /// <summary> ＧＩＳ一般情報 (データ種別)：特に規定しないときには　この値を使用する</summary>
        static public HySObjectKind KIND_GIS_GENERAL_DATA = new HySObjectKind("GISGeneralData");
        /// <summary> ＧＩＳ一般情報 (データ名称)：特に規定しないときには　この値を使用する</summary>
        static public HySString NAME_GIS_GENERAL_DATA = new HySString("ＧＩＳ一般情報");

        //// <summary>落水線情報取得　Drainage Direction Matrix Receiving Water </summary>
        //static public HySString GIS_DRAINAGE_DIRECTION_MATRIX = new HySString("GISDrainageDirectionMatrix");
        /// <summary>落水線情報取得(データ種別)　Drainage Direction Matrix Receiving Water </summary>
        static public HySObjectKind KIND_GIS_DRAINAGE_DIRECTION_MATRIX = new HySObjectKind("GISDrainageDirectionMatrix");
        /// <summary>落水線情報取得(データ名称)　Drainage Direction Matrix Receiving Water </summary>
        static public HySString NAME_GIS_DRAINAGE_DIRECTION_MATRIX = new HySString("落水線情報");

        //// <summary>ＧＩＳ標高値取得</summary>
        //static public HySString GIS_SEA_LEVEL = new HySString("GISMdlGenSeaLevel");
        /// <summary>ＧＩＳ標高値取得(データ種別) </summary>
        static public HySObjectKind KIND_GIS_SEA_LEVEL = new HySObjectKind("GISMdlGenSeaLevel");
        /// <summary>ＧＩＳ標高値取得(データ名称) </summary>
        static public HySString NAME_GIS_SEA_LEVLE = new HySString("GIS標高値");

        //// <summary>河川横断データ取得</summary>
        //static public HySString GIS_RIVER_CROSS_SECTION = new HySString("GISMdlGenCrossSection");
        /// <summary>河川横断データ(データ種別)</summary>
        static public HySObjectKind KIND_GIS_RIVER_CROSS_SECTION = new HySObjectKind("GISMdlGenCrossSection");
        /// <summary>河川横断データ(データ名称)</summary>
        static public HySString NAME_GIS_RIVER_CROSS_SECTION = new HySString("河川横断データ");


        //// <summary>河川縦断データ取得</summary>
        //static public HySString GIS_RIVER_LONGITUDINAL_SECTION = new HySString("GISMdlGenLongitudinalSection");
        /// <summary>河川縦断データ(データ種別)</summary>
        static public HySObjectKind KIND_GIS_LONGITUDINAL_SECTION = new HySObjectKind("GISMdlGenLongitudinalSection");
        /// <summary>河川縦断データ(データ名称)</summary>
        static public HySString NAME_GIS_RIVER_LONGITUDINAL_SECTION = new HySString("河川縦断データ");

        //// <summary>河川距離標データ取得</summary>
        //static public HySString GIS_RIVER_DISTANCE_MARK = new HySString("GISMdlGenDistanceMark");
        /// <summary>河川距離標データ(データ種別)</summary>
        static public HySObjectKind KIND_GIS_RIVER_DISTANCE_MARK = new HySObjectKind("GISMdlGenDistanceMark");
        /// <summary>河川距離標データ(データ名称)</summary>
        static public HySString NAME_GIS_RIVER_DISTANCE_MARK = new HySString("河川距離標");

        //// <summary>作画情報取得</summary>
        //static public HySString GIS_MDL_DRAWING_FIGURE = new HySString("GISMdlGenDrawingFigure");
        /// <summary>作画情報取得(データ種別)</summary>
        static public HySObjectKind KIND_GIS_MDL_DRAWING_FIGURE = new HySObjectKind("GISMdlGenDrawingFigure");
        /// <summary>作画情報取得(データ名称)</summary>
        static public HySString NAME_GIS_MDL_DRAWING_FIGURE = new HySString("作画情報");

        ////////  以下　河道利用計画ツールが必要とする情報に従って　今後追加予定  //////////////////////////
    }
}
