﻿// <summary>ソースコード：ＧＩＳ関連常数定義</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ関連常数定義</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public static class HySGISDefine
    {


        // ============================
        // GIS関連、サブイベント番号定義
        // ============================
        /// <summary>（別プロセスの場合）GIS_COTS_起動指示</summary>
        static public readonly long GIS_COTS_WAKEUP = 10001;
        /// <summary>（別プロセスの場合）GIS_COTS_終了指示</summary>
        static public readonly long GIS_COTS_TERMINATE = 10002;

        /// <summary>地図上位置取得</summary>
        static public readonly long MAP_POSITION_GET = 10011;
        /// <summary>地図上オブジェクトセレクトイベント取得</summary>
        static public readonly long OBJECT_SELECT_ON = 10012;
        /// <summary>地図上オブジェクトセレクト解除イベント取得</summary>
        static public readonly long OBJECT_SELECT_OFF = 10013;

        /// <summary>
        /// GIS関連情報取得
        /// メインイベント番号：HySEventObject.CMND_GIS_COMMON
        /// サブイベント番号：HySGISDefine.GET_GIS_INFO
        /// 作成条件等は：HySGISInfoData area = HySEventObject.GetData() as HySGISInfoData; にて取得する
        /// </summary>
        static public readonly long GET_GIS_INFO = 10021;
        /// <summary>GIS関連情報取得処理正常終了</summary>
        static public readonly long GET_GIS_INFO_OK = 10022;
        /// <summary>GIS関連情報取得処理正常終了</summary>
        static public readonly long GET_GIS_INFO_NG = 10023;
      

        // =============================
        // 横断面データ一覧ファイル関連
        // =============================
        /// <summary>河道横断面データファイル名称</summary>
        static public HySString CROSS_SEC_LISTNAME = new HySString("RiverCrossSectionList.xml");
        /// <summary>ホームディレクトリからのパス</summary>
        static public HySString CROSS_SEC_LISTDIR = new HySString("\\temp\\");

        /// <summary> XMLタグ　横断面データ要素 </summary>
        static public readonly string xml_CROSS_SEC_SECTIONS = "crossSections";
        /// <summary> XMLタグ　個別横断面データ要素 </summary>
        static public readonly string xml_CROSS_SEC_SECTION = "crossSection";
        /// <summary> XMLタグ　距離標要素 </summary>
        static public readonly string xml_CROSS_SEC_DISTANCE_POST_ELE = "distancePost";
        /// <summary> XMLタグ　左岸点要素 </summary>
        static public readonly string xml_CROSS_SEC_LEFT_DISTANCE_POST = "leftDistancePost";
        /// <summary> XMLタグ　右岸点要素 </summary>
        static public readonly string xml_CROSS_SEC_RIGHT_DISTANCE_POST = "rightDistancePost";
        /// <summary> XMLタグ　地理座標要素</summary>
        static public readonly string xml_CROSS_SEC_COORDINATES = "geographicCoordinates";

        /// <summary> XML属性　横断面ID属性 </summary>
        static public readonly string xml_CROSS_SEC_ID = "id";
        /// <summary> XML属性　河川番号属性 </summary>
        static public readonly string xml_CROSS_SEC_RIVERCODE = "riverCode";
        /// <summary> XML属性　本川フラグ属性 </summary>
        static public readonly string xml_CROSS_SEC_AUX_RIVER_FLAG = "auxRiverCode";
        /// <summary> XML属性　距離標属性 </summary>
        static public readonly string xml_CROSS_SEC_DISTANCE_POST_ATT = "distancePost";
        /// <summary> XML属性　横断面x座標最小値属性 </summary>
        static public readonly string xml_CROSS_SEC_MIN = "minXCoordinate";
        /// <summary> XML属性　横断面x座標最大値属性 </summary>
        static public readonly string xml_CROSS_SEC_MAX = "maxXCoordinate";
        /// <summary> XML属性　距離属性 </summary>
        static public readonly string xml_CROSS_SEC_DISTANCE = "distance";
        /// <summary> XML属性　緯度属性 </summary>
        static public readonly string xml_CROSS_SEC_LATITUDE = "latitude";
        /// <summary> XML属性　経度属性 </summary>
        static public readonly string xml_CROSS_SEC_LONGITUDE = "longitude";
    }
}
