﻿// <summary>ソースコード：ＧＩＳ ＧＩＳ関連表示属性クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSGIS;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳ関連表示属性</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    /// <remarks><para>remarks:</para>
    /// <para>属性は外部ファイルから変更可能とする</para>
    /// </remarks>
    [Serializable]
    public class HySGISDispAttribution : HySDataRoot, HySVersionManagement
    {

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySGISDispAttribution csAttribution = new HySGISDispAttribution()  </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySGISDispAttribution 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGISDispAttribution()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        // == 河心線表示情報 ==
        /// <summary>河心線表示色（Ｒ） </summary>
        static public short m_sRiverR=0;
        /// <summary>河心線表示色（Ｇ） </summary>
        static public short m_sRiverG = 0;
        /// <summary>河心線表示色（Ｂ） </summary>
        static public short m_sRiverB = 128;
        /// <summary>河心線強調表示色（Ｒ） </summary>
        static public short m_sHighlightRiverR = 0;
        /// <summary>河心線強調表示色（Ｇ） </summary>
        static public short m_sHighlightRiverG = 100;
        /// <summary>河心線強調表示色（Ｂ） </summary>
        static public short m_sHighlightRiverB = 254;
        /// <summary>横断面表示線幅 </summary>
        static public short m_sRiverWidth = 4;

        // == キロポスト表示情報 ==
        /// <summary>キロポスト表示色（Ｒ） </summary>
        static public short m_sKiloPostR = 0;
        /// <summary>キロポスト表示色（Ｇ） </summary>
        static public short m_sKiloPostG = 128;
        /// <summary>キロポスト表示色（Ｂ） </summary>
        static public short m_sKiloPostB = 128;
        /// <summary>キロポスト強調表示色（Ｒ） </summary>
        static public short m_sHighlightKiloPostR = 0;
        /// <summary>キロポスト強調表示色（Ｇ） </summary>
        static public short m_sHighlightKiloPostG = 200;
        /// <summary>キロポスト強調表示色（Ｂ） </summary>
        static public short m_sHighlightKiloPostB = 100;
        
        // == 横断面表示情報 ==
        /// <summary>横断面表示色（Ｒ） </summary>
        static public short m_sCrossSectionR = 120;
        /// <summary>横断面表示色（Ｇ） </summary>
        static public short m_sCrossSectionG = 150;
        /// <summary>横断面表示色（Ｂ） </summary>
        static public short m_sCrossSectionB = 0;
        /// <summary>横断面強調表示色（Ｒ） </summary>
        static public short m_sHighlightCrossSectionR = 254;
        /// <summary>横断面強調表示色（Ｇ） </summary>
        static public short m_sHighlightCrossSectionG = 100;
        /// <summary>横断面強調表示色（Ｂ） </summary>
        static public short m_sHighlightCrossSectionB = 0;
        /// <summary>横断面表示線幅 </summary>
        static public short m_sCrossSectionWidth = 3;

        // == その他表示情報 ??? ==
        // 以下の部分は必要／不要もふくめて　後でじっくり考える
        /// <summary>ハイドログラフ計算位置　目印　表示アイコン ????? </summary>
        static public String m_cQGrphPosition = "a.ico";

 
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public virtual void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
    }
}
