﻿// <summary>ソースコード：ＧＩＳビューファクトリ基底クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSController;


namespace CommonMP.HYSSOP.CoreImpl.HSGIS
{
    /// <summary><para>class outline:</para>
    /// <para>ＧＩＳビューファクトリ基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/05/01][新規作成]</para>
    /// </remarks>
    public abstract class HySGISViewFactoryBase : HySFactoryMono, HySViewFormFactory
    {
        /// <summary> 業務種別識別子  </summary>
        HySKind m_csSimKind = HySDefine.COMMON_DISP_BUSIPROCEDURE;

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetSimKind(HySKind csSimKindID)
        {
            m_csSimKind = csSimKindID;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>業務種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public HySKind GetSimKind()
        {
            return m_csSimKind;
        }

        /// <summary><para>method outline:</para>
        /// <para>業務種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">業務種別識別子</param>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public Boolean EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKind.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>画面フォームクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySViewForm csViewFrom = CreateViewForm( csSimulatorKind,csID,csFormKind ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <param name="csFormKind">画面種別</param>
        /// <returns>HySViewForm 画面フォームクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        abstract public HySViewForm CreateViewForm(HySKind csSimulatorKind, HySIdentifier csID, HySKind csFormKind);
    }
}
