﻿// <summary>ソースコード：ＨＹＳＳＯＰライブラリ管理ファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSLibraryMng.FileBase
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＳＳＯＰライブラリ管理ファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/13][新規作成]</para>
    /// </remarks>
    public class HySFileLibraryManagerFactory : HySFactoryMono,  HySLibraryMngFactory
    {
        /// <summary>シミュレーター種別識別子</summary>
        protected HySObjectKind m_csSimKindID = HySDefine.SIMULATOR_KIND;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySFileLibraryManagerFactory csFactory = new HySFileLibraryManagerFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySFileLibraryManagerFactory 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFileLibraryManagerFactory()
        {
            SetFactoryID(HySDefine.FACTORY_ID_LIBRARY_MNG);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = csFactory.GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySKind GetSimKind()
        {
            return m_csSimKindID;
        }
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bVar = csFactory.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// true  : 同一種別 false : 異なる種別
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool EqualSimKind(HySKind csSimKindID)
        {
            return m_csSimKindID.Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>ライブラリ管理クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySLibraryMng csLibraryManager = csFactory.CreateLibraryManager( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ライブラリ管理クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySLibraryMng CreateLibraryManager()
        {
            HySLibraryMng csLibraryManager = null;
            HySObjectKind csKind = m_csSimKindID.Clone();
            csLibraryManager = new HySFileLibraryManager();
            csLibraryManager.SetSimKind(csKind);
            return csLibraryManager;
        }
    }
}
