﻿// <summary>ソースコード：部分更新指定パラメータクラス</summary>
// <author>CommonMP</author>

using System;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.Interface.HSLibraryMng;
using CommonMP.HYSSOP.CoreImpl.HSDBA;

namespace CommonMP.HYSSOP.CoreImpl.HSLibraryMng
{
    /// <summary><para>class outline:</para>
    /// <para>部分更新指定パラメータクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/27][新規作成]</para>
    /// </remarks>
    public class HySDBPartialUpdateSpec: HySDataRoot
    {
        /// <summary>
        /// 更新データテーブル
        /// </summary>
        protected HySDataHashTable m_csModifyData = new HySDataHashTable();

        /// <summary>
        /// 検索条件
        /// </summary>
        protected HySQueryCtlData m_csQueryCtlData = new HySQueryCtlData();

        /// <summary><para>method outline:</para>
        /// <para>更新データテーブル取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataHashTable csModifyData = csPartialUpdateSpec.GetModifyData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>更新データテーブル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataHashTable GetModifyData()
        {
            return m_csModifyData;
        }

        /// <summary><para>method outline:</para>
        /// <para>検索条件取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySQueryCtlData csQueryCtlData = csPartialUpdateSpec.GetQueryCtlData() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>更新データテーブル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySQueryCtlData GetQueryCtlData()
        {
            return m_csQueryCtlData;
        }
    }
}
