﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSDBA;

namespace CommonMP.HYSSOP.CoreImpl.HSLibraryMng
{
    /// <summary><para>class outline:</para>
    /// <para>ライブラリ管理定数定義クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>ライブラリ管理の共通定数を定義する。</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/08][新規作成]</para>
    /// </remarks>
    public static class HySLibraryMngDefine
    {
        // ===============================
        // イベント関係（付属識別子）
        // ===============================

        ///<summary>DB種別：プロジェクトデータ</summary>
        public static readonly HySID DB_KIND_PROJECT_DATA = new HySID("PROJECT_DATA");

        ///<summary>DB種別：河川横断面データ</summary>
        public static readonly HySID DB_KIND_RIVER_CROSS_SECTION_DATA = new HySID("RIVER_CROSS_SECTION_DATA");
        
        ///<summary>DB種別：統一河川情報ＴＭデータ</summary>
        public static readonly HySID DB_KIND_TM_DATA = new HySID("TM_DATA");
        
        ///<summary>DB種別：統一河川情報ＲＤデータ</summary>
        public static readonly HySID DB_KIND_RD_DATA = new HySID("RD_DATA");
        
        ///<summary>DB種別：演算結果データ</summary>
        public static readonly HySID DB_KIND_CALC_RESULT_DATA = new HySID("CALC_RESULT_DATA");
        
        ///<summary>DB種別：演算ロット情報</summary>
        public static readonly HySID DB_KIND_CALC_LOT_INFO = new HySID("CALC_LOT_INFO");

        // ===============================
        // イベント関係（サブイベント番号）
        // ===============================

        ///<summary>データ一覧検索（検索条件指定）</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_QUERY"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.SearchList"/></para>
        ///</remarks>
        public static readonly long DB_QUERY_DATA_LIST = 0x30000001;

        ///<summary>複数データ一括取得（ID配列指定）</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_QUERY"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.GetDataList"/></para>
        ///</remarks>
        public static readonly long DB_QUERY_DATA_LIST_BY_ID = 0x30000002;
        
        ///<summary>個別データ取得（ID指定）</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_QUERY"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.GetData"/></para>
        ///</remarks>
        public static readonly long DB_QUERY_DATA = 0x30000003;

        ///<summary>個別データ新規登録</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_REGISTER"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.RegisterNew(HySStockData)"/></para>
        ///</remarks>
        public static readonly long DB_REGISTER_DATA_NEW = 0x30000004;

        ///<summary>複数データ一括新規登録</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_REGISTER"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.RegisterNew(HySStockDataList)"/></para>
        ///</remarks>
        public static readonly long DB_REGISTER_DATA_NEW_LIST = 0x30000005;
        
        ///<summary>既存データ更新</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_REGISTER"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.Update"/></para>
        ///</remarks>
        public static readonly long DB_REGISTER_DATA_UPDATE = 0x30000006;
        
        ///<summary>複数データ削除（検索条件指定）</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_DELETE"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.Delete(HySQueryCtlData)"/></para>
        ///</remarks>
        public static readonly long DB_DELETE_DATA_LIST = 0x30000007;
        
        ///<summary>複数データ削除（ID配列指定）</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_DELETE"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.Delete(HySIdentifier[])"/></para>
        ///</remarks>
        public static readonly long DB_DELETE_DATA_LIST_BY_ID = 0x30000008;

        ///<summary>個別データ削除（ID指定）</summary>
        ///<remarks>
        ///<para>対応イベント番号：<see cref="HySEventObject.CMND_DB_DELETE"/></para>
        ///<para>対応DBAメソッド：<see cref="HySCommonDBA.Delete(HySIdentifier)"/></para>
        ///</remarks>
        public static readonly long DB_DELETE_DATA = 0x30000009;

        /// <summary>
        /// 部分更新
        /// </summary>
        /// <remarks>
        /// <para>対応イベント番号：<see cref="HySEventObject.CMND_DB_REGISTER"/></para>
        /// <para>対応DBAメソッド：<see cref="HySCommonDBA.UpdatePartial(HySQueryCtlData,HySDataHashTable)"/></para>
        /// </remarks>
        public static readonly long DB_REGISTER_DATA_UPDATE_PARTIAL = 0x3000000A;

        /// <summary>
        /// 更新または新規登録
        /// </summary>
        /// <remarks>
        /// <para>対応イベント番号：<see cref="HySEventObject.CMND_DB_REGISTER"/></para>
        /// <para>対応DBAメソッド：<see cref="HySCommonDBA.Update(HySStockData)"/>または<see cref="HySCommonDBA.RegisterNew(HySStockData)"/></para>
        /// </remarks>
        public static readonly long DB_REGISTER_DATA_UPDATE_OR_NEW = 0x3000000B;
    }
}
