﻿
using System;
using System.Collections.Generic;

using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSSimulator;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;


namespace CommonMP.HYSSOP.CoreImpl.HSSimulator
{
    /// <summary><para>class outline:</para>
    /// <para>シミュレーターファクトリ基底クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/10/01][新規作成]</para>
    /// </remarks>
    public abstract class HySSimulatorFactoryBase : HySFactoryMono, HySSimulatorFactory
    {
        /*
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySSimulatorFactoryBase csFactory = new HySSimulatorFactoryBase()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySSimulatorFactoryBase()
        {
            SetFactoryID(HySDefine.COMPONENT_ID_SIMULATION);
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySKind csKind = GetSimKind()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>シミュレーター種別識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySKind GetSimKind();
        /// <summary><para>method outline:</para>
        /// <para>シミュレーター種別識別子比較</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bRtn = HySSimulator.EqualSimKind(csSimKindID)</para>
        /// </example>
        /// <param name="csSimKindID">シミュレーター種別識別子</param>
        /// <returns>
        /// <returns>true  : 同じ、false : 異なる</returns>
        /// </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual Boolean EqualSimKind(HySKind csSimKindID)
        {
            return this.GetSimKind().Equals(csSimKindID);
        }

        /// <summary><para>method outline:</para>
        /// <para>シミュレータークラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulator csSimulator = CreateSimulator( csSimulatorKind,csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>シミュレータークラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySSimulatorRoot CreateSimulator(HySKind csSimulatorKind, HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>データコンテナクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySContainer csDataCont = CreateDataContainer( csSimulatorKind, csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>データコンテナクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public abstract HySContainer CreateDataContainer(HySKind csSimulatorKind, HySIdentifier csID);

        /// <summary><para>method outline:</para>
        /// <para>シミュレーション用情報生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySSimulationDataGenerator csDataGenerator = CreateSimulationDataGenerator( csSimulatorKind,csID ) </para>
        /// </example>
        /// <param name="csSimulatorKind">シミュレーター種別識別子</param>
        /// <param name="csID">識別子</param>
        /// <returns>シミュレーション用データ生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// :通常は何もしない:
        /// 地図の情報等から、シミュレーション情報を自動生成する場合等に使用する
        /// </para>
        /// </remarks>
        virtual public HySSimulationDataGenerator CreateSimulationDataGenerator(HySKind csSimulatorKind, HySIdentifier csID)
        {
            // Do Nothing
            return null;
        }
    }
}
