﻿// <summary>ソースコード：定期河川縦横断データ管理システムアダプタクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.Interface.HSBusiProc;
using CommonMP.HYSSOP.Interface.HSDBAProc;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSBusiProc;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSLibraryMng;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>システムアダプタクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/24][新規作成]</para>
    /// </remarks>
    public class HySServiceAccessAdaptorBase : HySAdaptorIF
    {
        
        /// <summary>クラス名文字列</summary>
        private static readonly string CLASS_NAME = "HySServiceAccessAdaptorBase";

        /// <summary>データ取得処理関連戻り値：正常（処理完了）</summary>
        public static readonly long SUCCESS_COMPLETE = 0;
        /// <summary>データ取得処理関連戻り値：正常（処理継続）</summary>
        public static readonly long SUCCESS_CONTINUE = 1;
        /// <summary>データ取得処理関連戻り値：異常</summary>
        public static readonly long FAILED = -1;

        /// <summary>アクセスクラス</summary>
        private HySWebAccess m_csAccess = null;

        /// <summary>アダプタID</summary>
        private HySID m_csAdaptorID = null;

        /// <summary>DBアクセス処理業務</summary>
        private HySDBAProcedure m_csDBAProc = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySServiceAccessAdaptorBase csAdaptor = new HySServiceAccessAdaptorBase( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>RsdServiceAccessAdaptor 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySServiceAccessAdaptorBase( )
        {
            m_csAdaptorID = new HySID(CLASS_NAME);
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySServiceAccessAdaptorBase csAdaptor = new HySServiceAccessAdaptorBase(csAccess)</para>
        /// </example>
        /// <param name="csAccess">システムアクセスクラス</param>
        /// <returns>HySServiceAccessAdaptorBase 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySServiceAccessAdaptorBase(HySWebAccess csAccess)
        {
            m_csAccess = csAccess;
            m_csAdaptorID = new HySID(CLASS_NAME);
        }

        /// <summary><para>method outline:</para>
        /// <para>DBアクセス処理設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDBAProcedure(csDBAProc) </para>
        /// </example>
        /// <param name="csDBAProc">DBアクセス処理</param>
        /// <returns>なし</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDBAProcedure(HySDBAProcedure csDBAProc)
        {
            m_csDBAProc = csDBAProc;
        }

        /// <summary><para>method outline:</para>
        /// <para>アダプタID取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csID = GetID(); </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySID アダプタID</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySID GetID()
        {
            return m_csAdaptorID;
        }
    }
}
