﻿// <summary>ソースコード：>デバッガの代理人</summary>
// <author>CommonMP</author>

using System;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>デバッガの代理人</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/28][新規作成]</para>
    /// <para>CommonMPからデバッガに情報を送信するためのエージェント。</para>
    /// <para>本クラスは静的クラスであり、任意の箇所からインスタンス化することなく呼び出せる。</para>
    /// <para>実際に通信処理を行う<see cref="HySDebugAgentIF"/>を実装するオブジェクトはあらかじめ<see cref="SetDebugAgent"/>で設定しておく必要がある。</para>
    /// <para>デフォルトは何もしない(<see cref="HySDebugNullAgent"/>)。</para>
    /// </remarks>
    public static class HySDebugAgent
    {
        /// <summary>
        /// デバッガ代理人オブジェクト
        /// </summary>
        private static HySDebugAgentIF m_csAgent;

        /// <summary><para>method outline:</para>
        /// <para>クラスロード時の初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDebugAgent()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static HySDebugAgent()
        {
            m_csAgent = new HySDebugNullAgent();
        }

        /// <summary><para>method outline:</para>
        /// <para>デバッガ代理人オブジェクトの設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDebugAgent(csAgent)</para>
        /// </example>
        /// <param name="csAgent">デバッガ代理人インターフェースの実装オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>CommonMPから外部デバッガに情報を送信するオブジェクトを設定する。</para>
        /// </remarks>
        public static void SetDebugAgent(HySDebugAgentIF csAgent)
        {
            if (csAgent != null)
            {
                m_csAgent = csAgent;
            }
            else
            {
                m_csAgent = new HySDebugNullAgent();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>デバッグ環境のセットアップ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Startup()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>代理人オブジェクトにデバッグ開始処理を依頼する。</para>
        /// </remarks>
        public static void Startup()
        {
            try
            {
                m_csAgent.Startup();
            }
            catch { }
        }

        /// <summary><para>method outline:</para>
        /// <para>環境情報通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EnvironmentInfoNotify(csEnvironmentInfo)</para>
        /// </example>
        /// <param name="csEnvironmentInfo">環境情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>代理人オブジェクトに環境情報通知を依頼する。</para>
        /// </remarks>
        public static void EnvironmentInfoNotify(object csEnvironmentInfo)
        {
            try
            {
                m_csAgent.EnvironmentInfoNotify(csEnvironmentInfo);
            }
            catch { }
        }

        /// <summary><para>method outline:</para>
        /// <para>モニター表示データ通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MonitorDataNotify(csDataContainer)</para>
        /// </example>
        /// <param name="csDataContainer">データコンテナ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>代理人オブジェクトにモニター表示データ通知を依頼する。</para>
        /// </remarks>
        public static void MonitorDataNotify(object csDataContainer)
        {
            try
            {
                m_csAgent.MonitorDataNotify(csDataContainer);
            }
            catch { }
        }

        /// <summary><para>method outline:</para>
        /// <para>デバッグの終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>代理人オブジェクトにデバッグ終了処理を依頼する。</para>
        /// </remarks>
        public static void Terminate()
        {
            try
            {
                m_csAgent.Terminate();
            }
            catch { }
        }
    }
}
