﻿// <summary>ソースコード：>ＨＹＳＳＯＰデバッガ代理人インターフェース</summary>
// <author>CommonMP</author>

using System;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>デバッガ代理人インターフェース</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/28][新規作成]</para>
    /// <para>このインターフェースの実装クラスを<see cref="HySDebugAgent.SetDebugAgent"/>で
    /// 登録することにより、外部デバッガプロセスとの通信処理を可能とする。</para>
    /// </remarks>
    public interface HySDebugAgentIF
    {
        /// <summary><para>method outline:</para>
        /// <para>デバッグ開始</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Startup()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Startup();

        /// <summary><para>method outline:</para>
        /// <para>デバッグ終了</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Terminate()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void Terminate();


        /// <summary><para>method outline:</para>
        /// <para>環境情報通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> EnvironmentInfoNotify(csEnvironmentInfo)</para>
        /// </example>
        /// <param name="csEnvironmentInfo">環境情報。実際の型は<see cref="CommonMP.HYSSOP.CoreImpl.HSData.HySDataHashTable"/></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void EnvironmentInfoNotify(object csEnvironmentInfo);

        /// <summary><para>method outline:</para>
        /// <para>モニター表示データ通知</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MonitorDataNotify(csDataContainer)</para>
        /// </example>
        /// <param name="csDataContainer">モニター表示データコンテナ。実際の型は<see cref="CommonMP.HYSSOP.CoreImpl.HSData.HySDataContainer"/></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void MonitorDataNotify(object csDataContainer);
    }
}
