﻿// <summary>ソースコード：>ＨＹＳＳＯＰデータ複製クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;


using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>データ複製クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/01][新規作成]</para>
    /// </remarks>
    public class HySDataDuplicate : HySRoot
    {
        /*
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFile csFile = new HySFile() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySFile  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataDuplicate()
        {
        }
        */

        /// <summary><para>method outline:</para>
        /// <para>データの複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csRtn = DupliCateData(csData) </para>
        /// </example>
        /// <param name="csData">データクラス</param>
        /// <returns>複製データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public static HySDataRoot DupliCateData(HySDataRoot csData)
        {
            HySDataRoot csRtn = null;

            if (csData != null)
            {
                MemoryStream csMemStream = new MemoryStream();
                // シリアライズするフィールド生成
                BinaryFormatter csBinf = new BinaryFormatter();
                // オブジェクトをシリア化して書き込む
                csBinf.Serialize(csMemStream, csData);
                // 先頭にシーク
                csMemStream.Seek(0, SeekOrigin.Begin);
                // 読み込んで逆シリアル化する
                csRtn = (HySDataRoot)csBinf.Deserialize(csMemStream);
                csMemStream = null;
                csBinf = null;
            }
            return csRtn;
        }

    }
}
