﻿// <summary>ソースコード：CSVファイル取り扱い用共通データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSTools.HSExecutor
{
    /// <summary><para>class outline:</para>
    /// <para>起動プログラム設定スートクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/１2/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>
    /// HySExcecutorクラス内に設定される一連の起動プログラム情報を格納するクラス
    /// </para>
    /// </remarks>
    [Serializable]
    public class HySExecSuite : HySDataRoot
    {
        /// <summary>起動の遅延時間（mSec） </summary>
        long m_lDelayTime = 0;
        /// <summary>起動時の、前設定プロセスの終了待ち(true:待ち有り、false:待ち無し) </summary>
        bool m_bWaitFlg = true;
        /// <summary>終了待ちを行うプロセス名 </summary>
        string m_sAfterPrcName = "";
        /// <summary>起動プログラムファイル（.exeファイル） </summary>
        string m_sProcName = "";
        /// <summary>起動パラメーター </summary>
        string m_sProcParam = "";

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySExecSuite csObj = new HySExecSuite()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySExecSuite()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySExecSuite csObj = new HySExecSuite(bWaitFlg,  sAName,  sPName,  sPara)</para>
        /// </example>
        /// <param name="bWaitFlg">起動時の、前設定プロセスの終了待ち(true:待ち有り、false:待ち無し)フラグ</param>
        /// <param name="sAName">終了待ちを行うプロセス名</param>
        /// <param name="sPName">起動プログラムファイル（.exeファイル）</param>
        /// <param name="sPara">起動パラメーター</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySExecSuite(bool bWaitFlg, string sAName, string sPName, string sPara)
        {
            m_bWaitFlg = bWaitFlg;
            m_sAfterPrcName = sAName;
            m_sProcName = sPName;
            m_sProcParam = sPara;
        }

        // Setter , Getter
        /// <summary><para>method outline:</para>
        /// <para>遅延時間設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetDelayTime(milSec)</para>
        /// </example>
        /// <param name="milSec">起動の遅延時間（mSec）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetDelayTime(long milSec)
        { m_lDelayTime = milSec; }

        /// <summary><para>method outline:</para>
        /// <para>遅延時間取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetDelayTime()</para>
        /// </example>
        /// <returns>起動の遅延時間（mSec）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public long GetDelayTime()
        { return m_lDelayTime; }

        /// <summary><para>method outline:</para>
        /// <para>プロセス終了待ちフラグ設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetWaitFlg(bFlg)</para>
        /// </example>
        /// <param name="bFlg">フラグ(true:待ち有り、false:待ち無し)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetWaitFlg(bool bFlg)
        { m_bWaitFlg = bFlg; }

        /// <summary><para>method outline:</para>
        /// <para>プロセス終了待ちフラグ取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetWaitFlg()</para>
        /// </example>
        /// <returns>bool true:待ち有り、false:待ち無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public bool GetWaitFlg()
        { return m_bWaitFlg; }

        /// <summary><para>method outline:</para>
        /// <para>終了待ちを行うプロセス名設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetAfterPrcName(sAName)</para>
        /// </example>
        /// <param name="sAName">終了待ちを行うプロセス名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetAfterPrcName(string sAName)
        { m_sAfterPrcName = sAName; }

        /// <summary><para>method outline:</para>
        /// <para>起動プログラムファイル設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetDelayTime(sPName)</para>
        /// </example>
        /// <param name="sPName">起動プログラムファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetProcName(string sPName)
        { m_sProcName = sPName; }

        /// <summary><para>method outline:</para>
        /// <para>起動パラメーター設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetProcParam(sPara)</para>
        /// </example>
        /// <param name="sPara">起動パラメーター</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public void SetProcParam(string sPara)
        { m_sProcParam = sPara; }

        /// <summary><para>method outline:</para>
        /// <para>終了待ちを行うプロセス名取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetAfterPrcName()</para>
        /// </example>
        /// <returns>終了待ちを行うプロセス名</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public string GetAfterPrcName()
        { return m_sAfterPrcName; }

        /// <summary><para>method outline:</para>
        /// <para>起動プログラムファイル取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetProcName()</para>
        /// </example>
        /// <returns>起動プログラムファイル名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public string GetProcName()
        { return m_sProcName; }

        /// <summary><para>method outline:</para>
        /// <para>起動パラメーター取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>GetProcParam()</para>
        /// </example>
        /// <returns>起動パラメーター</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        virtual public string GetProcParam()
        { return m_sProcParam; }


        // XML_入出力関連メソッド
        /// <summary><para>method outline:</para>
        /// <para>XML出力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySXmlNode csNode = WriteXML( ref csXmlWriter )</para>
        /// </example>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <param name="lOrderNo">起動の順番（０相対）</param>
        /// <returns>XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySXmlNode WriteXML(ref HySXmlWriter csXmlWriter,long lOrderNo)
        {
            // CalElementタグ
            HySXmlNode csRtnNode = HySXmlNode.CreateElement("HySExecSuite", csXmlWriter);
            csRtnNode.SetAttribute("Order", lOrderNo.ToString());
            csRtnNode.SetAttribute("DelayTime", m_lDelayTime.ToString());
            csRtnNode.SetAttribute("WaitFlg", m_bWaitFlg.ToString());
            csRtnNode.SetAttribute("AfterPrcName", m_sAfterPrcName);
            csRtnNode.SetAttribute("ProcName", m_sProcName);
            csRtnNode.SetAttribute("ProcParam", m_sProcParam);
            return csRtnNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>XML入力</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = ReadXML( csXml )</para>
        /// </example>
        /// <param name="csXml">Xmlノード</param>
        /// <returns>起動の順番（０相対）</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual long ReadXML(HySXmlNode csXml )
        {
            long lOrderNo = -1;
            string sWorkAttr;
            // 順番
            sWorkAttr = csXml.GetAttribute("Order");
            if (sWorkAttr != "")
            {
                lOrderNo = long.Parse(sWorkAttr);
            }
            // 起動の遅延時間
            sWorkAttr = csXml.GetAttribute("DelayTime");
            if (sWorkAttr != "")
            {
                m_lDelayTime = long.Parse(sWorkAttr);
            }
            // 種別
            sWorkAttr = csXml.GetAttribute("WaitFlg");
            if (sWorkAttr == "False")
            {
                m_bWaitFlg = false;
            }
            else
            {
                m_bWaitFlg = true;
            }

            m_sAfterPrcName = csXml.GetAttribute("AfterPrcName");
            m_sProcName = csXml.GetAttribute("ProcName");
            m_sProcParam = csXml.GetAttribute("ProcParam");

            return lOrderNo;
        }
    }
}
