﻿// <summary>ソースコード：直後データ取得処理クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>直後データ取得クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>
    /// 指定時刻より一つ先（一致時刻あるばあいはその時刻）のデータを取得する
    /// 指定時刻より未来の情報が無い場合にはNULLを返す
    /// </para>
    /// </remarks>
    [Serializable]
    public class HySGetNextTimeInterpolator : HySIdleInterpolator, HySVersionManagement
    {
               
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySGetNextTimeInterplator csObj = new HySGetNextTimeInterplator()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySGetNextTimeInterpolator()
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>対象レコード取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCurrentRecord() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> 無し　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>対象時刻に一致または直後のレコードを取得する</para>
        /// </remarks>
        protected override void GetCurrentRecord()
        {
            if (m_csSeriesData != null)
            {
                m_csCurrentD1Data = null;
                m_csCurrentD2Data = null;
                m_csCurrentD3Data = null;
                /*
                long lRtn = m_csSeriesData.SetCursorPlus(this.m_csCurrentTime);   // カーソル位置を指定時刻t直後に設定
                if (lRtn == 0)
                {   // 直後のデータがなければ
                    lRtn = m_csSeriesData.SetCursor(this.m_csCurrentTime);   // カーソル位置を指定時刻tと同一に設定
                }
                */
                long lRtn = m_csSeriesData.SetCursor(this.m_csCurrentTime);   // カーソル位置を指定時刻tと同一に設定
                if (lRtn == 0)
                {   // 一致時刻のデータがなければ
                    lRtn = m_csSeriesData.SetCursorPlus(this.m_csCurrentTime);   // カーソル位置を指定時刻t直後に設定
                }
                if (lRtn > 0)
                {   // 一致または、直後のデータあり
                    HySTimeRecordIF csRcd = m_csSeriesData.GetCursorData();
                    m_csCurrentD1Data = csRcd as HySD1CellArrayData;
                    HySGeoDim1Data csGeo1D = csRcd as HySGeoDim1Data;
                    if (csGeo1D != null)
                    {
                        m_csCurrentD1Data = csGeo1D.GetCellArray() as HySD1CellArrayData;
                    }
                    m_csCurrentD2Data = csRcd as HySD2CellArrayData;
                    HySGeoDim2MeshData csGeo2D = csRcd as HySGeoDim2MeshData;
                    if (csGeo2D != null)
                    {
                        m_csCurrentD2Data = csGeo2D.GetCellArray() as HySD2CellArrayData;
                    }
                    m_csCurrentD3Data = csRcd as HySD3CellArrayData;
                    HySGeoDim3MeshData csGeo3D = csRcd as HySGeoDim3MeshData;
                    if (csGeo3D != null)
                    {
                        m_csCurrentD3Data = csGeo3D.GetCellArray() as HySD3CellArrayData;
                    }
                }
            } //end of if(m_csSeriesData)
        }
     
        // ================================================
        //   バージョンアップ時の下位互換性を保つ為の処理
        // ================================================
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sVersion = GetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }
        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetNowVersion()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }
        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                    {
                            // Do Nothing
                            break;
                    }
                    //case "2.00": << 以後バージョンアップに伴って処理追加
                    //{
                    //    break;
                    //}
                }
                SetNowVersion();

            }
        }
        /*
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            PostDeserialize();
        }
        */
    }
}
