// <summary>ソースコード：内挿ツール作成クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.CoreImpl.HSData;
//using CommonMP.HYSSOP.CoreImpl.HSData.CommonData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>内挿ツール作成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>時系列情報の内挿処理を行う為のツールクラス</para>
    /// </remarks>
    public class HySInterpolatorFactory : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>内挿ツール作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateInterpolator(eInterpolateType) </para>
        /// </example>
        /// <param name="eInterpolateType">内挿ツール種別</param>
        /// <returns> HySInterpolatorIF 内挿ツール　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public HySInterpolatorIF CreateInterpolator(HySDefine.InterpolateType eInterpolateType)
        {
            HySInterpolatorIF csRtnObj = null;
            if (eInterpolateType == HySDefine.InterpolateType.NO_INTERPOLATE)
            {   // なにもしない
                csRtnObj = new HySIdleInterpolator();
            }
            else if (eInterpolateType == HySDefine.InterpolateType.LINEAR)
            {   // 線形補間
                csRtnObj = new HySLinearInterpolator();
            }
            else if (eInterpolateType == HySDefine.InterpolateType.GET_NEXT_DATA)
            {   // 直後値取得
                csRtnObj = new HySGetNextTimeInterpolator();
            }
            //else if (eInterpolateType == HySDefine.InterpolateType.POLYNOMIAL)
            //{
            //    // Do Nothing
            //}
            else
            {
                // Do Nothing
            }
            return csRtnObj;
        }
    }
}
