// <summary>ソースコード：内挿処理基底インターフェース</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>内挿処理基底インターフェース</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/08/01][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>
    /// 時系列情報の内挿処理を行う為のツールクラス
    ///   HySInterpolatorIF csInp = new HySInterXXXX();
    ///   csInp.SetTimeSeriesData(csTimeSeriesData);
    ///   csInp.SetDataIndex( csCellDataGetter );
    ///   csInp.SetCurrentTime(csTime);
    ///   csInp.GetCellArrayD1() or .GetCellArrayD2() or .GetCellArrayD3();
    ///     or
    ///   csInp.GetInterpolatedCell(lIdx1) or GetInterpolatedCell(lIdx1,lIdx2) or GetInterpolatedCell(lIdx1,lIdx2,lIdx3);
    /// </para>
    /// </remarks>
    //[Serializable]
    public interface HySInterpolatorIF : HySRoot
    {
        /// <summary><para>method outline:</para>
        /// <para>内挿処理対象伝送データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTimeSeriesData(csTimeSeriesData) </para>
        /// </example>
        /// <param name="csTimeSeriesData">対象時系列データ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetTimeSeriesData(HySTimeSeriesBase csTimeSeriesData);
        /// <summary><para>method outline:</para>
        /// <para>内挿処理対象データ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetTimeRecordData(csTimeSeriesData) </para>
        /// </example>
        /// <param name="csTimeRecordData">対象データ</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 瞬時値データ(HySTimeRecordIF)の場合でも　外部からは、
        /// 内挿したかの様に振舞わせたい場合に使用する</para>
        /// </remarks>
        void SetTimeRecordData(HySTimeRecordIF csTimeRecordData);

        /// <summary><para>method outline:</para>
        /// <para>内挿処理を行うべきセル内データ配列のインデックス設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDataIndex(csIdxDt) </para>
        /// </example>
        /// <param name="csIdxDt">内挿処理を行うべきセル内データ配列のインデックス設定クラス</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void SetDataIndex(HySCellDataGetter csIdxDt);

        /// <summary><para>method outline:</para>
        /// <para>内挿時刻設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetCurrentTime(csTime) </para>
        /// </example>
        /// <param name="csTime">内挿すべき時刻</param>
        /// <returns> 無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>設定した時刻に内挿する</para>
        /// </remarks>
        void SetCurrentTime(HySTime csTime);

        //==========================================
        //  個別セルについて内挿処理を行う場合
        //==========================================

        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCell(bWithoutDataCheck) </para>
        /// </example>
        /// <param name="bWithoutDataCheck">=true:データチェック無し</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// bWithoutDataCheck=true の場合には、既にデータチェックが他の場所で行われている場合に使用する
        /// （データ整合性チェックによる演算速度減少を防ぐため）
        /// </para>
        /// </remarks>
        HySCellData GetCell( bool bWithoutDataCheck);
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCell(lDataIdx,bWithoutDataCheck) </para>
        /// </example>
        /// <param name="lDataIdx">セル内のデータインデックス（０相対）</param>
        /// <param name="bWithoutDataCheck">=true:データチェック無し</param>
        /// <returns> double 内挿された指定インデックス情報　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// bWithoutDataCheck=true の場合には、既にデータチェックが他の場所で行われている場合に使用する
        /// （データ整合性チェックによる演算速度減少を防ぐため）
        /// </para>
        /// </remarks>
        double GetData(long lDataIdx, bool bWithoutDataCheck);


        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellD1(lIdx1) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData GetCell(long lIdx1);
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellD1(lIdx1,lIdx2) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <param name="lIdx2">第２配列のセル位置</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData GetCell(long lIdx1,long lIdx2);
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellD1(lIdx1,lIdx2,lIdx3) </para>
        /// </example>
        /// <param name="lIdx1">第１配列のセル位置</param>
        /// <param name="lIdx2">第２配列のセル位置</param>
        /// <param name="lIdx3">第３配列のセル位置</param>
        /// <returns> HySCellData 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData GetCell(long lIdx1, long lIdx2,long lIdx3);

        //==========================================
        //  セルの配列全体について内挿処理を行う場合
        //==========================================


        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellArrayD1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySD1CellArrayData 内挿された情報を格納したセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        HySD1CellArrayData GetCellArrayD1();
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellD1() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[] 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData[] GetCellD1();
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDataD1(lDataIdx) </para>
        /// </example>
        /// <param name="lDataIdx">セル内のデータインデックス（０相対）</param>
        /// <returns> double[] 内挿された指定インデックス情報　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD1CellArrayDataの時に使用
        /// </para>
        /// </remarks>
        double[] GetDataD1(long lDataIdx);

        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellArrayD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySD2CellArrayData 内挿された情報を格納したセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD2CellArrayData,HySGeoDim2MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        HySD2CellArrayData GetCellArrayD2();
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellD2() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[] 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD2CellArrayData,HySGeoDim2MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData[,] GetCellD2();
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDataD2(lDataIdx) </para>
        /// </example>
        /// <param name="lDataIdx">セル内のデータインデックス（０相対）</param>
        /// <returns> double[,]内挿された指定インデックス情報　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD2CellArrayData,HySGeoDim2MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        double[,] GetDataD2(long lDataIdx);

        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellArrayD3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySD3CellArrayData 内挿された情報を格納したセル配列　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD3CellArrayData,HySGeoDim3MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        HySD3CellArrayData GetCellArrayD3();
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetCellD3() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns> HySCellData[] 内挿された情報を格納したセル　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD3CellArrayData,HySGeoDim3MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        HySCellData[, ,] GetCellD3();
        /// <summary><para>method outline:</para>
        /// <para>内挿結果取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetDataD3(lDataIdx) </para>
        /// </example>
        /// <param name="lDataIdx">セル内のデータインデックス（０相対）</param>
        /// <returns> double[,,] 内挿された指定インデックス情報　</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 内挿対象データが HySTimeSeriesD3CellArrayData,HySGeoDim3MeshSerialDataの時に使用
        /// </para>
        /// </remarks>
        double[, ,] GetDataD3(long lDataIdx);

    }
}
