﻿// <summary>ソースコード：>ＨＹＳＳＯＰ外部ＤＬＬインポートクラス</summary>
// <author>CommonMP</author>

using System;
using System.Text;

using System.Runtime.InteropServices;

using System.Reflection;
using System.IO;


namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>外部ＤＬＬインポートクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.1.0][2011/01/01][新規作成]</para>
    /// </remarks>
    public class HySNativeDLLImport
    {
        /// <summary><para>method outline:</para>
        /// <para>指定したＤＬＬをインポートし、そのハンドル値を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IntPtr iModuleHandle = LoadLibrary(sDLLFileName) </para>
        /// </example>
        /// <param name="sDLLFileName">DLL名（ﾌﾙﾊﾟｽ）</param>
        /// <returns>IntPtr　ハンドル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        [DllImport("kernel32")]
        public static extern IntPtr LoadLibrary(string sDLLFileName);

        /// <summary><para>method outline:</para>
        /// <para>ＤＬＬのエントリーポイントのハンドル値を取得する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IntPtr iFuncHandle = GetProcAddress(iModule,sProcName) </para>
        /// </example>
        /// <param name="iModule">インポートされたＤＬＬのハンドル</param>
        /// <param name="sProcName">Exportされたファンクション名</param>
        /// <returns>IntPtr　ハンドル</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        [DllImport("kernel32")]
        public static extern IntPtr GetProcAddress(IntPtr iModule, string sProcName);

        /// <summary><para>method outline:</para>
        /// <para>インポートされたＤＬＬを開放する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = FreeLibrary(iModule) </para>
        /// </example>
        /// <param name="iModule">インポートされたＤＬＬのハンドル</param>
        /// <returns>bool :true:正常、false=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks> 
        [DllImport("kernel32")]
        public static extern bool FreeLibrary(IntPtr iModule);
    }
}
