﻿// <summary>ソースコード：>ＨＹＳＳＯＰファイルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>ファイルクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2008/10/01][新規作成]
    /// [CommonMP][ver 1.4.0][2013/12/10][メソッド追加]
    /// </para>
    /// </remarks>
    public class HySFile : HySIOStream, IDisposable
    {

        /// <summary>ストリームリーダ</summary>
        private StreamReader m_csStreamReader;
        /// <summary>ストリームライタ</summary>
        private StreamWriter m_csStreamWriter;

        /// <summary>ファイルストリーム</summary>
        protected FileStream m_csFile;

        /// <summary>ファイル名称</summary>
        private String m_csFileName;

        /// <summary>ファイルモードオープンモード</summary>
        public enum OPEN_MODE
        {
            /// <summary>ファイルモード:CreateNew</summary>
            CREATE_NEW = 1,
            /// <summary>ファイルモード:Create</summary>
            CREATE,
            /// <summary>ファイルモード:Open</summary>
            OPEN,
            /// <summary>ファイルモード:OpenOrCreate</summary>
            OPEN_OR_CREAT,
            /// <summary>ファイルモード:Truncate</summary>
            TRANCATE,
            /// <summary>ファイルモード:Append</summary>
            APPEND
        }
        /// <summary>ファイルアクセス(Read/Write)モード</summary>
        public enum READ_WRITE_MODE
        {
            /// <summary>アクセスモード:Read</summary>
            READ = 1,
            /// <summary>アクセスモード:Write</summary>
            WRITE,
            /// <summary>アクセスモード:ReadWrite</summary>
            READ_WRITE,
        }
        /// <summary>ディレクトリ作成モード</summary>
        public enum DIRECTORY_MODE
        {
            /// <summary>ディレクトリ作成モード:ディレクトリ未作成</summary>
            NOT_MK_DIR = 0,
            /// <summary>ディレクトリ作成モード:ディレクトリ作成</summary>
            MK_DIR
        }

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFile csFile = new HySFile() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySFile  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFile()
        {
            Init();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFile csFile = new HySFile(csFileName) </para>
        /// </example>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>HySFile  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFile(HySString csFileName)
        {
            Init(csFileName);
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySFile csFile = new HySFile(csFileName) </para>
        /// </example>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>HySFile  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySFile(String csFileName)
        {
            Init(new HySString(csFileName));
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init() </para>
        /// </example>
        /// <param name=""></param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void Init()
        {
            m_csFile = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>初期化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFileName) </para>
        /// </example>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void Init(HySString csFileName)
        {
            m_csFile = null;
            m_csFileName = csFileName.ToString(); // メンバ変数にファイル名をコピー
        }
        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Term() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Term()
        {
            if (m_csFile != null)
            {
                m_csFile = null;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>ファイルオープン処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = Open(lFiMode, lAcMode, lDirMode) </para>
        /// </example>
        /// <param name="lFiMode">ファイルモード</param>
        /// <param name="lAcMode">アクセスモード</param>
        /// <param name="lDirMode">ディレクトリ作成モード</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long Open(OPEN_MODE lFiMode, READ_WRITE_MODE lAcMode, DIRECTORY_MODE lDirMode)
        {
            long lRtn = 0;

            if(m_csFileName == null)
            {
                return -1;
            }
            else if (m_csFileName.Length == 0)
            {
                return -1;
            }
            try
            {
                if (lDirMode == HySFile.DIRECTORY_MODE.MK_DIR)
                {
                    // 最下層ディレクトリ有無を確認する
                    if (File.Exists(Path.GetDirectoryName(m_csFileName)) != true)
                    {
                        // ファイル名称から最下層ディレクトリ名を切り出し、
                        // フォルダ (ディレクトリ) を作成する
                        HySString csFileName = new HySString(m_csFileName);
                        string[] sInWk;
                        sInWk = csFileName.ToString().Split('\\'); // 名称単体時のチェック
                        if (sInWk.LongLength > 1)
                        {
                            Directory.CreateDirectory(Path.GetDirectoryName(m_csFileName));
                        }
                    }
                }
                else if (lDirMode != HySFile.DIRECTORY_MODE.NOT_MK_DIR)
                {
                    return -1;
                }
                if (lFiMode== HySFile.OPEN_MODE.CREATE_NEW && (this.Exist() == true))
                {
                   lRtn = this.Delete();
                   if (lRtn == -1)
                   {
                       return -1;
                   }
                }
                // 指定ファイルをオープンする
                m_csFile = new FileStream(m_csFileName, (FileMode)lFiMode, (FileAccess)lAcMode, FileShare.Read);

                if (m_csFile == null)
                {
                    return -1;
                }
            }
            catch(Exception ex)
            {
                //Console.WriteLine(m_csFileName + "==>" + ex.ToString());
                HySLog.LogOut(HySLog.TRIAL_RUN, m_csFileName + "==>" + ex.ToString());
                return -1;
            }
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ファイルクローズ処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = Close() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long Close()
        {
            long lRtn = -1;

            if (m_csFile != null)
            {
                lRtn = 0;
                // 読み込み実行時はクローズ
                if (m_csStreamReader != null)
                {
                    m_csStreamReader.Close();
                    m_csStreamReader = null;
                }
                // 書き込み実行時はクローズ
                if(m_csStreamWriter != null)
                {
                    m_csStreamWriter.Close();
                    m_csStreamWriter = null;
                }
                m_csFile.Close();
                m_csFile = null;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル削除処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = Delete() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long Delete()
        {
            long lRtn = -1;

            if(Exist() == true)
            {
                Close();
                try
                {
                    File.Delete(m_csFileName);
                    lRtn = 0;
                }
                catch (IOException e)
                {
                    Console.WriteLine("{0}:ファイル使用中",e.GetType().Name);
                }
            }
            return lRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>ファイル存在確認</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Exist() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool　true:=有り, false:=無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Exist()
        {
            return File.Exists(m_csFileName);
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルサイズ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRetSize = GetFileSize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  ファイルサイズ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetFileSize()
        {
            long lRetSize = -1;

            if (Exist() == true)
            {
                FileInfo csFileInfo = new FileInfo(m_csFileName);
                lRetSize = csFileInfo.Length;
            }
            return lRetSize;
        }

        /// <summary><para>method outline:</para>
        /// <para>データの書き込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = DataWrite(csData) </para>
        /// </example>
        /// <param name="csData">データクラス</param>
        /// <returns>bool  =true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool DataWrite(HySDataRoot csData)
        {
            bool bRtn = true;
            long lLclRtn = SerializeAndSave(csData);
            if (lLclRtn < 0) { bRtn = false; }
            return bRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>データの読み出し</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csDataRoot = DataRead() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot  読み出したデータクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataRoot DataRead()
        {
            HySDataRoot csRtn = this.LoadAndDeserialize() as HySDataRoot;
            HySVersionManagement csVerMngData = csRtn as HySVersionManagement;
            if (csVerMngData != null)
            {
                csVerMngData.PostDeserialize();
            }
            //csRtn.PostDeserialize();
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>テキスト書き込み処理（１行）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = WriteText(csString) </para>
        /// </example>
        /// <param name="csString">文字列</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long WriteText(HySString csString)
        {
            if ((object)csString == null || m_csFile == null)
            { return -1; }
            try
            {
                // 最初の書き込み時、リーダを生成
                if (m_csStreamWriter == null)
                {
                    m_csStreamWriter = new StreamWriter(m_csFile, Encoding.Default);
                }
                m_csStreamWriter.WriteLine(csString.ToString());
                m_csStreamWriter.Flush();
            }
            catch(Exception csExp)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, csExp.Message.ToString());
                return -1;
            }
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>テキスト読み込み処理（１行）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadText(ref csString) </para>
        /// </example>
        /// <param name="csString">文字列</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long ReadText(ref HySString csString)
        {
            // データ有り初期設定
            long lRtn = 1;
            csString.SetChar("");
            String csStr = null;
            //if (!File.Exists(m_csFileName))
            //{
            //    Console.WriteLine("{0} does not exist.", m_csFileName);
            //    return -1;
            //}

            String csInput;
            try
            {
                // 最初の読み込み時、リーダ生成
                if (m_csStreamReader == null)
                {
                    if (!File.Exists(m_csFileName))
                    {
                        //Console.WriteLine("{0} does not exist.", m_csFileName);
                        return -1;
                    }
                    m_csStreamReader = new StreamReader(m_csFile, Encoding.Default);
                }
                csInput = m_csStreamReader.ReadLine();
                if (csInput != null)
                {
                    csStr = csInput;
                }
                else
                {
                    // データ終了
                    lRtn = 0;
                }
                csString.SetChar(csStr);
            }
            catch(Exception csExp)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, m_csFileName + "==>" + csExp.Message.ToString());
                return -1;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>テキスト書き込み処理（１行）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = WriteText(csString) </para>
        /// </example>
        /// <param name="csString">文字列</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long WriteText(String csString)
        {
            try
            {
                // 最初の書き込み時、リーダを生成
                if (m_csStreamWriter == null)
                {
                    if (m_csFile != null)
                    {
                        m_csStreamWriter = new StreamWriter(m_csFile, Encoding.Default);
                    }
                    else
                    {
                        return -1;
                    }
                }
                m_csStreamWriter.WriteLine(csString);
                m_csStreamWriter.Flush();
            }
            catch (Exception csExp)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, csExp.Message.ToString());
                return -1;
            }
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>テキスト読み込み処理（１行）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadText(ref csString) </para>
        /// </example>
        /// <param name="csString">読み出した文字列</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long ReadText(ref String csString)
        {
            // データ有り初期設定
            long lRtn = 1;
            csString="";
            String csStr = null;
            //if (!File.Exists(m_csFileName))
            //{
            //    Console.WriteLine("{0} does not exist.", m_csFileName);
            //    return -1;
            //}

            String csInput;
            try
            {
                // 最初の読み込み時、リーダ生成
                if (m_csStreamReader == null)
                {
                    if (!File.Exists(m_csFileName))
                    {
                        //Console.WriteLine("{0} does not exist.", m_csFileName);
                        return -1;
                    }
                    m_csStreamReader = new StreamReader(m_csFile, Encoding.Default);
                }
                csInput = m_csStreamReader.ReadLine();
                if (csInput != null)
                {
                    csStr = csInput;
                }
                else
                {
                    // データ終了
                    lRtn = 0;
                }
                csString = csStr;
            }
            catch (Exception csExp)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, m_csFileName + "==>" + csExp.Message.ToString());
                return -1;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル終了検査処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = FEof() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long  0:=終了, -1:=継続</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long FEof()
        {
            long lRtn = -1;
            String csInput;

            // 最初の読み込み時、リーダ生成
            if (m_csStreamReader == null)
            {
                m_csStreamReader = new StreamReader(m_csFile, Encoding.Default);
            }
            csInput = m_csStreamReader.ReadLine();
            if (csInput == null)
            {
                // データ終了
                lRtn = 0;
            }
            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>バイナリ書き込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = WriteBinary(pvWrite, lSize, lCount) </para>
        /// </example>
        /// <param name="pvWrite">項目</param>
        /// <param name="lSize">項目のサイズ</param>
        /// <param name="lCount">書き込む項目の個数</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long WriteBinary(byte[] pvWrite, long lSize, long lCount)
        {
            try
            {
                // ファイルへ格納する
                m_csFile.Write(pvWrite, (int)0, (int)(lCount * lSize));
                m_csFile.Flush();
            }
            catch (Exception csExp)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, m_csFileName + "==>" + csExp.Message.ToString());
                return -1;
            }
            return 0;
        }
        /// <summary><para>method outline:</para>
        /// <para>バイナリ読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = ReadBinary(pvRead, lSize, lCount) </para>
        /// </example>
        /// <param name="pvRead">項目</param>
        /// <param name="lSize">項目のサイズ</param>
        /// <param name="lCount">読み込む項目の個数</param>
        /// <returns>long  0:=正常, -1:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long ReadBinary( ref byte[] pvRead, long lSize, long lCount)
        {
            try
            {
                // ファイルから読み出す
                m_csFile.Read(pvRead, (int)0, (int)(lSize * lCount));
            }
            catch (Exception csExp)
            {
                HySLog.LogOut(HySLog.TRIAL_RUN, csExp.Message.ToString());
                return -1;
            }
            return 0;
        }

        // バイナリファイルのシーク位置設定
        /// <summary><para>method outline:</para>
        /// <para>バイナリ読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = SeekBinary(lOrigin, lOffset) </para>
        /// </example>
        /// <param name="lOrigin">基準位置</param>
        /// <param name="lOffset">読み込み位置からのオフセット</param>
        /// <returns>long  0:=正常, -1:=格納ファイル無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long SeekBinary(long lOrigin, long lOffset)
        {
            if (m_csFile != null)
            {
                if (lOrigin == 0)    // 先頭位置から移動
                {
                    m_csFile.Seek(lOffset, SeekOrigin.Begin);
                }
                if (lOrigin == 1)    // 現在位置から移動
                {
                    m_csFile.Seek(lOffset, SeekOrigin.Current);
                }
                if (lOrigin == 2)    // 最後尾位置から移動
                {
                    m_csFile.Seek(lOffset, SeekOrigin.End);
                }
                return 0;
            }
            else
            {
                return -1;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>オブジェクトの内容をシリアライズ化してファイルに保存する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = SerializeAndSave(csObj) </para>
        /// </example>
        /// <param name="csObj">保存するオブジェクト</param>
        /// <returns>long  0:=正常, -1:=格納ファイル無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long SerializeAndSave(object csObj)
        {
            // 格納ファイルは有効か？
            if (m_csFile != null)
            {
                // シリアライズするフィールド生成
                BinaryFormatter csBinf = new BinaryFormatter();
                // オブジェクトをシリア化して書き込む
                csBinf.Serialize(m_csFile, csObj);
                return 0;
            }
            else
            {
                return -1;
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>オブジェクトの内容をファイルから読み込み復元（Deserialize）する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> object obj = LoadAndDeserialize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>object  復元されたオブジェクト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public object LoadAndDeserialize()
        {
            object csObj = null;

            // 格納ファイルは有効か？
            if (m_csFile != null)
            {
                // シリアライズするフィールド生成
                BinaryFormatter csBinf = new BinaryFormatter();
                // 読み込んで逆シリアル化する
                csObj = csBinf.Deserialize(m_csFile);
            }
            // 復元したオブジェクトを返す 
            return csObj;
        }

        /// <summary><para>method outline:</para>
        /// <para>指定されているディレクトリから全てのファイルを削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AllFileDelleteInDirectory() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AllFileDelleteInDirectory()
        {
            if (Directory.Exists(m_csFileName))
            {
                // ファイル削除
                string[] sFiles = Directory.GetFiles(m_csFileName);
                foreach (string sFileName in sFiles)
                {
                    File.Delete(sFileName);
                }
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>指定されているディレクトリから指定された検索パターンの全てのファイルを削除する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AllFileDelleteInDirectory(SeachPattern) </para>
        /// </example>
        /// <param name="SeachPattern">検索パターン</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AllFileDelleteInDirectory(HySString SeachPattern)
        {
            if (Directory.Exists(m_csFileName))
            {
                // ファイル削除
                string[] sFiles = Directory.GetFiles(m_csFileName, SeachPattern.ToString());
                foreach (string sFileName in sFiles)
                {
                    File.Delete(sFileName);
                }
            }
        }

        //★★★★★★★★★★★★★★★★
        // Ver1.4で追加(一時ファイル作成)
        //★★★★★★★★★★★★★★★★
        /// <summary><para>method outline:</para>
        /// <para>アンマネージリソース等の解放</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Dispose() </para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Dispose()
        {
            if (m_csStreamReader != null)
            {
                m_csStreamReader.Dispose();
                m_csStreamReader = null;
            }
            if (m_csStreamWriter != null)
            {
                m_csStreamWriter.Dispose();
                m_csStreamWriter = null;
            }
            if (m_csFile != null)
            {
                m_csFile.Dispose();
                m_csFile = null;
            }
            m_csFileName = null;
        }
    }
}
