﻿// <summary>ソースコード：>ＨＹＳＳＯＰ環境情報編集クラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.Interface.HSTools;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>環境情報編集クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP]
    /// [ver 1.1.0][2010/12/10] 環境情報編集クラス
    /// </para>
    /// </remarks>
    public class HySIniFile : HySRoot
    {
        /// <summary>ファイル名称</summary>
        private String m_csFileName;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySIniFile csIniFile = new HySIniFile(csFileName) </para>
        /// </example>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>HySFile  生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySIniFile(HySString csFileName)
        {
            m_csFileName = csFileName.ToString(); // メンバ変数にファイル名をコピー
        }

        /// <summary><para>method outline:</para>
        /// <para>終了処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Term() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Term()
        {
            if (m_csFileName != null)
            {
                m_csFileName = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイル名設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetFileName(csFileName) </para>
        /// </example>
        /// <param name="csFileName">ファイル名称</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetFileName(HySString csFileName)
        {
            m_csFileName = csFileName.ToString(); // メンバ変数にファイル名をコピー
        }

        /// <summary><para>method outline:</para>
        /// <para>値読込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csValue = GetValue(csKeyCode) </para>
        /// </example>
        /// <param name="csKeyCode">検索キー</param>
        /// <returns>HySString 読取値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetValue(HySString csKeyCode)
        {
            HySString csGetData = null;     // 取得データ
            HySString csReadStr;            // 読み取りデータ
            String csVarName;               // 変数名
            String csValName;               // 変数値
            long lFirstTabPos = 0;          // 最初のタブ文字位置
            long lSecondTabPos = 0;         // 二番目のタブ文字位置
            long lEqualPos = 0;             // イコール文字位置

            HySFile csFile = new HySFile(m_csFileName);

            if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)  // 環境設定ファイルが開けない
            {
                csFile = null;
                return csGetData;
            }

            csReadStr = new HySString("");
            while (csFile.ReadText(ref csReadStr) != 0)       // ファイルの最後まで
            {
                // 前項情報の初期化
                lFirstTabPos = 0;
                lSecondTabPos = 0;
                lEqualPos = 0;

                if (csReadStr.ToString().IndexOf("#") == 0 || csReadStr.ToString() == String.Empty) // コメント文、空行読み飛ばし
                {
                    continue;
                }

                // 二つのタブ、イコール文字の位置を探す
                lFirstTabPos = csReadStr.ToString().IndexOf("\t");
                lSecondTabPos = csReadStr.ToString().IndexOf("\t", (int)lFirstTabPos + 1);
                lEqualPos = csReadStr.IndexOf("=");

                if (lFirstTabPos == 0 || lSecondTabPos == 0)    // 書式エラー読み飛ばし
                {
                    continue;
                }

                if (lFirstTabPos > lEqualPos || lSecondTabPos < lEqualPos)  // 書式エラー読み飛ばし
                {
                    continue;
                }

                // 変数名読み取り
                csVarName = csReadStr.ToString().Substring(0, (int)lFirstTabPos);
                if (csKeyCode.Equal(new HySString(csVarName)) == true)
                {
                    // 変数値読み取り
                    csValName = csReadStr.ToString().Substring((int)lSecondTabPos + 1);

                    if (csVarName.Length > 0 && csValName.Length > 0)   // 変数取得確認
                    {
                        csGetData = new HySString(csValName);
                        break;
                    }
                }

            }
            csFile.Close();
            csFile = null;

            return csGetData;

        }

        /// <summary><para>method outline:</para>
        /// <para>値書込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lRtn = SetValue(csKeyCode, csVal, bMode) </para>
        /// </example>
        /// <param name="csKeyCode">検索キー</param>
        /// <param name="csVal">書込み値</param>
        /// <param name="bMode">追加判定区分</param>
        /// <returns>long　=0:正常、=-1,-2,-3:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long SetValue(HySString csKeyCode, HySString csVal, bool bMode)
        {
            long lRtn = -1L;                // リターンコード
            HySString csReadStr;            // 読み取りデータ
            String csVarName;               // 変数名
            long lFirstTabPos = 0;          // 最初のタブ文字位置
            long lSecondTabPos = 0;         // 二番目のタブ文字位置
            long lEqualPos = 0;             // イコール文字位置
            bool bReNewFlg = false;         // 更新有無フラグ
            HySDataLinkedList csIniData = new HySDataLinkedList(); // 変数データ

            HySFile csFile = new HySFile(m_csFileName);

            if (csFile.Exist() == true)
            {
                // ##### 定義ファイル読み込み #####
                if (csFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR) != 0)
                {// 環境設定ファイルが開けない
                    csFile = null;
                    return (-2L);
                }

                csReadStr = new HySString("");
                while (csFile.ReadText(ref csReadStr) != 0)       // ファイルの最後まで
                {
                    // 前項情報の初期化
                    lFirstTabPos = 0;
                    lSecondTabPos = 0;
                    lEqualPos = 0;


                    if (csReadStr.ToString().IndexOf("#") == 0 || csReadStr.ToString() == String.Empty) // コメント文、空行読み飛ばし
                    {
                        csIniData.AddLast(csReadStr.Clone());
                        continue;
                    }

                    // 二つのタブ、イコール文字の位置を探す
                    lFirstTabPos = csReadStr.ToString().IndexOf("\t");
                    lSecondTabPos = csReadStr.ToString().IndexOf("\t", (int)lFirstTabPos + 1);
                    lEqualPos = csReadStr.IndexOf("=");

                    if (lFirstTabPos == 0 || lSecondTabPos == 0)    // 書式エラー読み飛ばし
                    {
                        csIniData.AddLast(csReadStr.Clone());
                        continue;
                    }

                    if (lFirstTabPos > lEqualPos || lSecondTabPos < lEqualPos)  // 書式エラー読み飛ばし
                    {
                        csIniData.AddLast(csReadStr.Clone());
                        continue;
                    }

                    // 変数名読み取り
                    csVarName = csReadStr.ToString().Substring(0, (int)lFirstTabPos);
                    if (csKeyCode.Equal(new HySString(csVarName)) == true)
                    {// 一致した場合置き換え
                        csIniData.AddLast(new HySString(csVarName) + new HySString("\t=\t") + csVal);
                        bReNewFlg = true;
                    }
                    else
                    {
                        csIniData.AddLast(csReadStr.Clone());
                    }
                }
                csFile.Close();
            }

            // ##### 定義の追加 #####
            if (bReNewFlg == false && bMode == true)
            {// 追加モードならファイルを作成し値を追加
                csIniData.AddLast(csKeyCode + new HySString("\t=\t") + csVal);
                bReNewFlg = true;
            }

            // ##### 定義ファイル更新 #####
            if (bReNewFlg == true)
            {
                if (csFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR) == 0)
                {// オープン成功
                    long lDtNum = csIniData.GetCount();

                    csIniData.SetCursorFirst();
                    for (long lLp = 0; lLp < lDtNum; lLp++)
                    {
                        csFile.WriteText((HySString)csIniData.GetCursorData());
                        csIniData.MoveCursorNext();
                    }

                    csFile.Close();
                    lRtn = 0L;
                }
                else
                {// 環境設定ファイルが開けない
                    lRtn = -3L;
                }
            }

            csFile = null;
            return (lRtn);
        }

    }
}
