﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>ネットワーク関連設定情報管理クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/02][新規作成]</para>
    /// </remarks>
    public class HySNetworkConfigManager
    {
        /// <summary>ログ出力用クラス名</summary>
        private static readonly string CLASS_NAME = "HySNetworkConfigManager";

        /// <summary>ネットワーク関連設定情報ファイル名</summary>
        private static readonly string CONFIG_FILE_NAME = "Network.xml";

        //-------------------------
        //xml関連定義
        //-------------------------
        /// <summary>proxy要素</summary>
        private static readonly string xml_ELEMENT_PROXY = "proxy";
        /// <summary>uri属性</summary>
        private static readonly string xml_ATTRIBUTE_URI = "uri";
        /// <summary>userName属性</summary>
        private static readonly string xml_ATTRIBUTE_USER_NAME = "userName";
        /// <summary>passWord属性</summary>
        private static readonly string xml_ATTRIBUTE_PASSWORD = "password";

        /// <summary>Webプロキシ</summary>
        private HySWebProxy m_csProxy = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySNetworkConfigManager csNetworkConf = new HySNetworkConfigManager() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySNetworkConfigManager 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySNetworkConfigManager()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = Initialize() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true:正常 false:異常 </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>ネットワーク設定情報ファイルを読み込み、内部の情報を自身のデータ管理先に設定する。</para>
        /// </remarks>
        public bool Initialize()
        {
            string strMethodName = "Initialize";

            // 設定情報ファイル読み込み
            HySString csFilePath = HySEnvInf.GetHomeDirectory() + @"\conf\" + CONFIG_FILE_NAME;
            HySFile csFile = new HySFile(csFilePath);

            if (!csFile.Exist())
            {
                // ログ出力
                // ver1.5 エラートレース日本語対応
                HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, strMethodName, Properties.HysMsgResources.STATEMENT_NETCONF_NOT_FOUND);
               // HySLog.LogOut(HySLog.ONLINE, CLASS_NAME, strMethodName, "ネットワーク設定ファイルが見つかりません。");
                return false;
            }

            HySXmlReader csReader = new HySXmlReader(csFilePath);

            // プロキシ情報の読み込み
            ReadProxy(csReader);

            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>プロキシ情報読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> ReadProxy() </para>
        /// </example>
        /// <param name="csReader">ネットワーク設定ファイルxmlリーダ</param>
        /// <returns>無し </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 設定ファイルからプロキシ情報を読み込み、自身のメンバに格納する。
        /// 必要な情報が設定されてない場合は格納しない。
        /// </para>
        /// </remarks>
        protected void ReadProxy(HySXmlReader csReader)
        {
            // 格納先初期化
            m_csProxy = null;

            HySXmlNodeList csWkNodeList = csReader.GetChildNodeListByTagName(xml_ELEMENT_PROXY);
            if (csWkNodeList.GetCount() != 0)
            {
                HySXmlNode csProxyNode = csWkNodeList.GetNode(0);
                string strUri = csProxyNode.GetAttribute(xml_ATTRIBUTE_URI);
                string strUserName = csProxyNode.GetAttribute(xml_ATTRIBUTE_USER_NAME);
                string strPassword = csProxyNode.GetAttribute(xml_ATTRIBUTE_PASSWORD);

                // uriが設定されているorユーザ名とPassが両方設定されている
                // 上記の場合プロキシ情報を生成

                if((strUri != string.Empty) ||
                   ((strUserName != string.Empty) && (strPassword != string.Empty)))
                {
                    //----------------------------------------------
                    // Webプロキシクラス作成後、自身のメンバにて管理
                    //----------------------------------------------
                    m_csProxy = new HySWebProxy();
                    if ((strUri != string.Empty))
                    {
                        m_csProxy.SetUri(new HySString(strUri));
                    }
                    if ((strUserName != string.Empty) && (strPassword != string.Empty))
                    {
                        m_csProxy.SetUserName(new HySString(strUserName));
                        m_csProxy.SetPassword(new HySString(strPassword));
                    }
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>プロキシ情報取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySWebProxy csProxy = GetProxy() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySWebProxy ウェブプロキシクラス </returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySWebProxy GetProxy()
        {
            return m_csProxy;
        }
    }
}
