﻿// <summary>ソースコード：ウェブアクセスクラス</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>ウェブアクセスクラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/09/24][新規作成]</para>
    /// </remarks>
    public class HySWebAccess : HySAccessIF
    {
        /// <summary>ウェブプロキシ</summary>
        private HySWebProxy m_csProxy;

        /// <summary><para>method outline:</para>
        /// <para>ウェブプロキシ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetProxy(csProxy) </para>
        /// </example>
        /// <param name="csProxy">ウェブプロキシ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual void SetProxy(HySWebProxy csProxy)
        {
            m_csProxy = csProxy;
        }

        /// <summary><para>method outline:</para>
        /// <para>ウェブプロキシ取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySWebProxy = GetProxy() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ウェブプロキシ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual HySWebProxy GetProxy()
        {
            return m_csProxy;
        }
    }
}
