﻿// <summary>ソースコード：>ＨＹＳＳＯＰミューテックスクラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>ミューテックスクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>各言語の文法の違いを隠蔽</para>
    /// <para>共有リソースへの排他アクセス権を 1 つのスレッドにだけ付与する同期機構</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySMutex
    {
        /// <summary>セマフォクラス</summary>
        protected Semaphore m_csSemaphore;

        /// <summary><para>method outline:</para>
        /// <para>デストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>無し</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メモリーリーク防止の為　内部変数は必ず null にセットする</para>
        /// </remarks>
        ~HySMutex()
        {
            //m_csSemaphore = null;  // <-- m_csSemaphoreをNULL化すると動作がおかしくなる（なぜか？）
        }
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySMutex csMutex = new HySMutex() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySMutex  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
         public HySMutex()
        {
            m_csSemaphore = new Semaphore(1, 1);
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySMutex csMutex = new HySMutex(csName) </para>
        /// </example>
        /// <param name="csName">システムセマフォオブジェトの名前</param>
        /// <returns>HySMutex  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システムセマフォオブジェクトの名前を指定してプロセス境界をまたがってリソース使用を調整</para>
        /// </remarks>
        public HySMutex(HySString csName)
        {
            m_csSemaphore = new Semaphore(1, 1, csName.ToString());
        }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySMutex csMutex = new HySMutex(sName) </para>
        /// </example>
        /// <param name="csName">システムセマフォオブジェトの名前</param>
        /// <returns>HySMutex  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>システムセマフォオブジェクトの名前を指定してプロセス境界をまたがってリソース使用を調整</para>
        /// </remarks>
        internal HySMutex(String csName)
        {
            m_csSemaphore = new Semaphore(1, 1, csName);
        }

        /// <summary><para>method outline:</para>
        /// <para>ミューテックス所有権の要求</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Wait() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Wait()
        {
            m_csSemaphore.WaitOne();
        }

        /// <summary><para>method outline:</para>
        /// <para>ミューテックス所有権の解放</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Release() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Release()
        {
            m_csSemaphore.Release();
        }
    }
}
