﻿// <summary>ソースコード：>ＨＹＳＳＯＰキュークラス</summary>
// <author>CommonMP</author>

using System;
using System.Threading;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>キュークラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySTryQueue
    {
        /// <summary>
        /// オブジェクト名称
        /// </summary>
        protected HySString m_csName;   // ユニーク名称

        /// <summary>
        /// 最大キュー数
        /// </summary>
        protected long m_lMaxQueue = 0;

        /// <summary>
        /// 書き込み位置
        /// </summary>
        protected long m_lWritePnt = 0;

        /// <summary>
        /// 読み出し位置
        /// </summary>
        protected long m_lReadPnt = 0;

        /// <summary>
        /// 同時書き込み排他ミューテックス
        /// </summary>
        private HySMutex m_csPushPull = null;

        /// <summary>
        /// データ
        /// </summary>
        HySQueueNode[] m_csNode;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySTryQueue csTryQueue = new HySTryQueue(lMaxLength) </para>
        /// </example>
        /// <param name="lMaxLength">最大キュー数</param>
        /// <returns>HySTryQueue  生成したインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySTryQueue(long lMaxLength)
        {
            m_csName = new HySString();
            m_lMaxQueue = lMaxLength + 1;
            m_csPushPull = new HySMutex();
            m_csNode = new HySQueueNode[m_lMaxQueue];
            for (long lLoop = 0; lLoop < m_lMaxQueue; lLoop++)
            {
                m_csNode[lLoop] = new HySQueueNode();
            }
        }

        //---将来拡張用----------------------------------------------------------------------------------------------------
        ///// <summary><para>method outline:</para>
        ///// <para>コンストラクタ</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para> HySTryQueue csHySTryQueue = new HySTryQueue(csName, lMaxLength) </para>
        ///// </example>
        ///// <param name="csName">オブジェクト名称</param>
        ///// <param name="lMaxLength">最大キュー数</param>
        ///// <returns>無し</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>注意：他のHySTryQueueインスタンスとcsNameがかぶらないようにすること</para>
        ///// <para>　　　（システム全体でcsNameがユニークになること）</para>
        ///// </remarks>
        //public HySTryQueue(HySString csName, long lMaxLength)
        //{
        //    m_csName = csName;
        //    m_lMaxQueue = lMaxLength + 1;
        //    m_csPushPull = new HySMutex(m_csName.GetString() + "_Mtx");
        //    m_csNode = new HySQueueNode[m_lMaxQueue];
        //    for (long lLoop = 0; lLoop < m_lMaxQueue; lLoop++)
        //    {
        //        m_csNode[lLoop] = new HySQueueNode();
        //    }
        //}
        //---将来拡張用----------------------------------------------------------------------------------------------------

        /// <summary><para>method outline:</para>
        /// <para>データのQueue積み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = TryPushObject(csData) </para>
        /// </example>
        /// <param name="csData">データ</param>
        /// <returns>Boolean　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>データのQueue積み込み Queue 満杯ならば、false で返る</para>
        /// </remarks>
        public Boolean TryPushObject(HySDataRoot csData)
        {
            Boolean bRtn = false;
            this.MutexLock();

            long lNextWritePnt = m_lWritePnt + 1;
            if (lNextWritePnt >= m_lMaxQueue)
            {
                lNextWritePnt = 0;
            }
            if (lNextWritePnt != m_lReadPnt)
            {
                m_csNode[m_lWritePnt].SetObject(csData);
                m_lWritePnt += 1;
                if (m_lWritePnt >= m_lMaxQueue)
                {
                    m_lWritePnt = 0;
                }
                bRtn = true;
            }
            this.MutexUnlock();

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>データの取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataRoot csDataRoot = TryPullObject() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>HySDataRoot　データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>データ読み出し Queue 空ならば、null で返る</para>
        /// </remarks>
        public HySDataRoot TryPullObject()
        {
            HySDataRoot csRtn = null;
            this.MutexLock();

            if (m_lReadPnt != m_lWritePnt)
            {
                csRtn = m_csNode[m_lReadPnt].GetObject();

                m_csNode[m_lReadPnt].SetObject(null);  //取り外してしまった後にはNULLを入れておく

                m_lReadPnt += 1;
                if (m_lReadPnt >= m_lMaxQueue)
                {
                    m_lReadPnt = 0;
                }
            }

            this.MutexUnlock();

            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>キュー番号の積み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Boolean bWork = TryPushNumber(lNumber) </para>
        /// </example>
        /// <param name="lNumber">キューの番号</param>
        /// <returns>Boolean　true:=正常, false:=異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>数（long）のQueue積み込み Queue 満杯ならば、falseで返る</para>
        /// </remarks>
        public Boolean TryPushNumber(long lNumber)
        {
            Boolean bRtn = false;
            this.MutexLock();

            long lNextWritePnt = m_lWritePnt + 1;
            if (lNextWritePnt >= m_lMaxQueue)
            {
                lNextWritePnt = 0;
            }
            if (lNextWritePnt != m_lReadPnt)
            {
                m_csNode[m_lWritePnt].SetNumber(lNumber);
                m_lWritePnt += 1;
                if (m_lWritePnt >= m_lMaxQueue)
                {
                    m_lWritePnt = 0;
                }
                bRtn = true;
            }
            this.MutexUnlock();

            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>キュー番号取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lWork = TryPullNumber() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>long　キュー番号</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>数（long）の読み出し Queue 空ならば、-1 で返る</para>
        /// </remarks>
        public long TryPullNumber()
        {
            long lRtn = -1;
            this.MutexLock();

            if (m_lReadPnt != m_lWritePnt)
            {
                lRtn = m_csNode[m_lReadPnt].GetNumber();
                m_lReadPnt += 1;
                if (m_lReadPnt >= m_lMaxQueue)
                {
                    m_lReadPnt = 0;
                }
            }

            this.MutexUnlock();

            return lRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>排他制御設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MutexLock() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void MutexLock()
        {
            m_csPushPull.Wait();
        }

        /// <summary><para>method outline:</para>
        /// <para>排他制御解除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> MutexUnlock() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected void MutexUnlock()
        {
            m_csPushPull.Release();
        }
    }
}
