﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using CommonMP.HYSSOP.Interface;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>XMLノードクラス（C# Wrapper）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySXmlNode : HySRoot
    {
        /// <summary> XML ノード </summary>
        protected XmlNode m_csXmlNode;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csXMLReader = HySXmlNode( csNode ) </para>
        /// </example>
        /// <param name="csNode">C# XML ノード</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal HySXmlNode( XmlNode csNode )
        {
            m_csXmlNode = csNode;
            
        }
        /// <summary><para>method outline:</para>
        /// <para>配下のノードリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNodeList csNodeList = GetChildNodeList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ノードリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNodeList GetChildNodeList()
        {
            return new HySXmlNodeList(m_csXmlNode.ChildNodes);
        }
        /// <summary><para>method outline:</para>
        /// <para>配下のノードをタグ指定で取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNodeList csNodeList = GetChildNodeListByTagName(sTagName) </para>
        /// </example>
        /// <param name="sTagName">タグ名称</param>
        /// <returns>ノードリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNodeList GetChildNodeListByTagName(string sTagName)
        {
            HySXmlNodeList csRtnNodeList = new HySXmlNodeList();
            XmlNode csNode=null;
            XmlNodeList childNode = m_csXmlNode.ChildNodes;
            int lNodeNum = childNode.Count;

            for (int lLp = 0; lLp < lNodeNum; lLp++)
            {
                csNode = childNode.Item(lLp);
                if (csNode.Name.Equals(sTagName) == true)
                {
                    csRtnNodeList.AddNode(csNode);
                }
            }
            return csRtnNodeList;
        }
        /// <summary><para>method outline:</para>
        /// <para>属性値をで取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sAttvibute = GetAttribute(sAttributeName) </para>
        /// </example>
        /// <param name="sAttributeName">属性名称</param>
        /// <returns>属性値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetAttribute(string sAttributeName)
        {
            return ((XmlElement)m_csXmlNode).GetAttribute(sAttributeName);
        }

        /// <summary><para>method outline:</para>
        /// <para>名称取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> string sName = GetName() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>名称</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetName()
        {
            return m_csXmlNode.Name;
        }

        //----------------------------------------------
        // XML 構築用
        //----------------------------------------------
        /// <summary><para>method outline:</para>
        /// <para>属性設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetAttribute(sAttribute,sVal) </para>
        /// </example>
        /// <param name="sAttribute">属性名</param>
        /// <param name="sVal">値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetAttribute(string sAttribute, string sVal)
        {
            ((XmlElement)m_csXmlNode).SetAttribute(sAttribute, sVal);
        }
        /// <summary><para>method outline:</para>
        /// <para>子ノード追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> AppendChild(csNode) </para>
        /// </example>
        /// <param name="csNode">子ノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void AppendChild(HySXmlNode csNode)
        {
            ((XmlElement)m_csXmlNode).AppendChild(csNode.m_csXmlNode);
            //csNode.m_csXmlNode = null;
        }

        /// <summary><para>method outline:</para>
        /// <para>属性値をクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveAllAttributes() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveAllAttributes()
        {
            ((XmlElement)m_csXmlNode).RemoveAllAttributes();
        }
        /// <summary><para>method outline:</para>
        /// <para>全ての属性値、子供をクリア</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveAll() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void RemoveAll()
        {
            ((XmlElement)m_csXmlNode).RemoveAll();
        }
        /// <summary><para>method outline:</para>
        /// <para>ノード生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> CreateElement() </para>
        /// </example>
        /// <param name="sName">名称</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public HySXmlNode CreateElement(string sName, HySXmlWriter csXmlWriter)
        {
            return new HySXmlNode((csXmlWriter.GetXmlDocument()).CreateElement(sName));
        }
        //static public HySXmlNode CreateElement(string name)
        //{
        //    XmlElement csNode = this.m_csXmlNode.Clone();
        //    csNode.RemoveAll();
        //    return new HySXmlNode(csNode);
        //}
        /// <summary><para>method outline:</para>
        /// <para>ＸＭＬノードインスタンス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> XmlNode csXmlNode = GetXmlNode( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ノード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>一般からは使用禁止</para>
        /// </remarks>
        internal XmlNode GetXmlNode()
        {
            return m_csXmlNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>配下の子孫ノードをタグ指定で取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNodeList csNodeList = GetElementsByTagName(sTagName) </para>
        /// </example>
        /// <param name="sTagName">タグ名称</param>
        /// <returns>ノードリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNodeList GetElementsByTagName(string sTagName)
        {
            HySXmlNodeList csRtnNodeList = new HySXmlNodeList();
            XmlNode csNode = null;
            XmlNodeList csNodeList = ((XmlElement)m_csXmlNode).GetElementsByTagName(sTagName);
            int lNodeNum = csNodeList.Count;

            for (int lLp = 0; lLp < lNodeNum; lLp++)
            {
                csNode = csNodeList.Item(lLp);
                csRtnNodeList.AddNode(csNode);
            }
            return csRtnNodeList;
        }
        /// <summary><para>method outline:</para>
        /// <para>連結値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetInnerText(sVal) </para>
        /// </example>
        /// <param name="sVal">連結値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetInnerText(string sVal)
        {
            ((XmlElement)m_csXmlNode).InnerText = sVal;
        }

        /// <summary><para>method outline:</para>
        /// <para>連結値取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> GetInnerText(sVal) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>連結値</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string GetInnerText()
        {
            return ((XmlElement)m_csXmlNode).InnerText;
        }

        /// <summary><para>method outline:</para>
        /// <para>子ノード追加（参照ノードの直後に挿入）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InsertAfter(csNewChild,csRefChild) </para>
        /// </example>
        /// <param name="csNewChild">追加ノード</param>
        /// <param name="csRefChild">参照ノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode InsertAfter(HySXmlNode csNewChild, HySXmlNode csRefChild)
        {
            return new HySXmlNode(((XmlElement)m_csXmlNode).InsertAfter(csNewChild.m_csXmlNode, csRefChild.m_csXmlNode));
        }

        /// <summary><para>method outline:</para>
        /// <para>子ノード追加（参照ノードの直前に挿入）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> InsertBefore(csNewChild,csRefChild) </para>
        /// </example>
        /// <param name="csNewChild">追加ノード</param>
        /// <param name="csRefChild">参照ノード</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode InsertBefore(HySXmlNode csNewChild, HySXmlNode csRefChild)
        {
            return new HySXmlNode(((XmlElement)m_csXmlNode).InsertBefore(csNewChild.m_csXmlNode, csRefChild.m_csXmlNode));
        }

        /// <summary><para>method outline:</para>
        /// <para>子ノード削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> RemoveChild(csRefChild) </para>
        /// </example>
        /// <param name="csRefChild">削除対象ノード</param>
        /// <returns>削除対象ノード自身</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode RemoveChild(HySXmlNode csRefChild)
        {
            return new HySXmlNode(((XmlElement)m_csXmlNode).RemoveChild(csRefChild.GetXmlNode()));
        }

        /// <summary><para>method outline:</para>
        /// <para>ノードのコメントチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IsComment() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>bool true : コメント行　false : 非コメント行</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool IsComment()
        {
            bool bRtn = false;

            if (m_csXmlNode.NodeType == XmlNodeType.Comment)
            {
                bRtn = true;
            }

            return bRtn;
        }
    }
}
