﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

using CommonMP.HYSSOP.Interface;

namespace CommonMP.HYSSOP.CoreImpl.HSTools
{
    /// <summary><para>class outline:</para>
    /// <para>XMLノードリストクラス（C# Wrapper）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class HySXmlNodeList : HySRoot
    {
        /// <summary> XML ノードリスト </summary>
        protected XmlNodeList m_csXmlNodeList = null;

        /// <summary> ノードリスト </summary>
        protected List<XmlNode> m_csNodeList = null;
   
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNodeList csList = HySXmlNodeList( csXmlNodeList ) </para>
        /// </example>
        /// <param name="csXmlNodeList">C# XML ノードリスト</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal HySXmlNodeList(XmlNodeList csXmlNodeList)
        {
            m_csXmlNodeList = csXmlNodeList;
            m_csNodeList = null;
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNodeList csList = HySXmlNodeList( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        internal HySXmlNodeList()
        {
            m_csXmlNodeList = null;
            m_csNodeList = new List<XmlNode>();
        }
        /// <summary><para>method outline:</para>
        /// <para>ノード数を取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lCnt =GetCount() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ノード数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetCount()
        {
            if (m_csXmlNodeList != null)
            {
                return (long)m_csXmlNodeList.Count;
            }
            else
            {
                return (long)m_csNodeList.Count;
            }

        }
        /// <summary><para>method outline:</para>
        /// <para>指定位置のノードを取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csNode =GetNode(lIndex) </para>
        /// </example>
        /// <param name="lIndex">インデックス位置</param>
        /// <returns>ノード</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySXmlNode GetNode(long lIndex)
        {
            if (m_csXmlNodeList != null)
            {
                if (lIndex < m_csXmlNodeList.Count)
                {
                    return new HySXmlNode(m_csXmlNodeList.Item((int)lIndex));
                }
                else
                {
                    return null;
                }

            }
            else
            {
                if (lIndex < m_csNodeList.Count)
                {
                    return new HySXmlNode(m_csNodeList[(int)lIndex]);
                }
                else
                {
                    return null;
                }
            }

        }
        /// <summary><para>method outline:</para>
        /// <para>ノードを追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySXmlNode csNode =AddNode(csNode) </para>
        /// </example>
        /// <param name="csNode">ノード</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>デフォルトコンストラクターで new した場合のみ有効</para>
        /// </remarks>
        internal bool AddNode(XmlNode csNode)
        {
            bool bRtn = false;
            if (m_csNodeList != null)
            {
                m_csNodeList.Add(csNode);
                bRtn = true;
            }
            return bRtn;
        }
    }
}
